/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.script.CreateGroovyScriptRunConfigurationCommand;
import com.hello2morrow.sonargraph.core.command.system.script.ModifyGroovyScriptRunConfigurationCommand;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.RunConfigurationWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class RunConfigurationWizard
extends NonLazySonargraphWizard {
    private final GroovyScript m_script;
    private final FileBasedRunConfiguration m_toBeEdited;
    private RunConfigurationWizardPage m_page;

    public RunConfigurationWizard(GroovyScript script) {
        super("New Script Run Configuration");
        assert (script != null) : "Parameter 'script' of method 'RunConfigurationWizard' must not be null";
        this.m_script = script;
        this.m_toBeEdited = null;
    }

    public RunConfigurationWizard(GroovyScript script, FileBasedRunConfiguration runConfiguration) {
        super("Edit Script Run Configuration");
        assert (script != null) : "Parameter 'script' of method 'RunConfigurationWizard' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'RunConfigurationWizard' must not be null";
        this.m_script = script;
        this.m_toBeEdited = runConfiguration;
    }

    public int getPreferredWidth() {
        return 500;
    }

    public int getPreferredHeight() {
        return 300;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        this.m_page = new RunConfigurationWizardPage(this.m_script, this.m_toBeEdited, (IGroovyProvider)provider.getSoftwareSystem().getExtension(IGroovyProvider.class));
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            CommandResultConsumer consumer = new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null) {
                        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                            @Override
                            public void run() {
                                ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.SCRIPT_VIEW, (String)(this).RunConfigurationWizard.this.m_script.getFileId(), Collections.emptyList(), Collections.singletonList((this).RunConfigurationWizard.this.m_script), (boolean)false);
                            }
                        });
                    }
                }
            };
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            if (this.m_toBeEdited != null) {
                ModifyGroovyScriptRunConfigurationCommand cmd = new ModifyGroovyScriptRunConfigurationCommand(provider, (ModifyGroovyScriptRunConfigurationCommand.IModifyGroovyScriptRunConfigurationInteraction)new ModifyInteraction());
                UserInterfaceAdapter.getInstance().run((Command)cmd, consumer);
            } else {
                CreateGroovyScriptRunConfigurationCommand cmd = new CreateGroovyScriptRunConfigurationCommand(provider, (CreateGroovyScriptRunConfigurationCommand.ICreateRunConfigurationInteraction)new CreateInteraction());
                UserInterfaceAdapter.getInstance().run((Command)cmd, consumer);
            }
            return true;
        }
        return false;
    }

    final class CreateInteraction
    extends StandardCommandInteraction
    implements CreateGroovyScriptRunConfigurationCommand.ICreateRunConfigurationInteraction {
        CreateInteraction() {
        }

        public void processCreationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean collect(CreateGroovyScriptRunConfigurationCommand.CreateRunConfigurationData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setScript(RunConfigurationWizard.this.m_script);
            data.setName(RunConfigurationWizard.this.m_page.getRunConfigurationName());
            data.setDescription(RunConfigurationWizard.this.m_page.getRunConfigurationDescription());
            data.setRunConfigurationParameters(RunConfigurationWizard.this.m_page.getRunConfigurationParameters());
            return true;
        }
    }

    final class ModifyInteraction
    extends StandardCommandInteraction
    implements ModifyGroovyScriptRunConfigurationCommand.IModifyGroovyScriptRunConfigurationInteraction {
        ModifyInteraction() {
        }

        public boolean collect(ModifyGroovyScriptRunConfigurationCommand.ModifyGroovyScriptRunConfigurationData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (RunConfigurationWizard.this.m_toBeEdited != null) : " 'm_toBeEdited' of method 'collect' must not be null";
            data.setRunConfiguration(RunConfigurationWizard.this.m_toBeEdited);
            data.setName(RunConfigurationWizard.this.m_page.getRunConfigurationName());
            data.setDescription(RunConfigurationWizard.this.m_page.getRunConfigurationDescription());
            data.setRunConfigurationParameters(RunConfigurationWizard.this.m_page.getRunConfigurationParameters());
            return true;
        }

        public boolean confirmSaveOnEdit() {
            return UserInterfaceAdapter.getInstance().question("The run configuration will be saved immediately to a new file." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processModificationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

