/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Image;

final class ResolutionBeanAdapter
extends BeanPropertyReader.BeanAdapter<Resolution> {
    private static final DateFormat DATE_TIME_FORMAT = Iso8601DateFormat.createStandardDateTimeFormat();
    private Resolution m_resolution;

    ResolutionBeanAdapter() {
    }

    protected void setAdaptedObject(Resolution resolution) {
        this.m_resolution = resolution;
    }

    public String getVirtualModel() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getVirtualModel' must not be null";
        VirtualModel virtualModel = (VirtualModel)this.m_resolution.getParent(VirtualModel.class, new Class[0]);
        return virtualModel != null ? virtualModel.getName() : null;
    }

    public Image getVirtualModelImage() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getVirtualModelImage' must not be null";
        VirtualModel virtualModel = (VirtualModel)this.m_resolution.getParent(VirtualModel.class, new Class[0]);
        return virtualModel != null ? UiResourceManager.getInstance().getImage((Element)virtualModel) : null;
    }

    public String getDescription() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getDescription' must not be null";
        return this.m_resolution.getDescription();
    }

    public String getDate() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getDate' must not be null";
        return DATE_TIME_FORMAT.format(this.m_resolution.getDate());
    }

    public Date getDateForSort() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getDateForSort' must not be null";
        return this.m_resolution.getDate();
    }

    public int getMatchCount() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getMatchCount' must not be null";
        return this.m_resolution.getMatchingElementsCount();
    }

    public String getPriority() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getPriority' must not be null";
        return this.m_resolution.getPriority().getPresentationName();
    }

    public int getPriorityForSort() {
        assert (this.m_resolution != null) : "Parameter 'm_resolution' of method 'getPriorityForSort' must not be null";
        return this.m_resolution.getPriority().ordinal();
    }

    public String getAssignee() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getAssignedTo' must not be null";
        return this.m_resolution.getAssignee();
    }

    public String getResolutionType() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getResolutionType' must not be null";
        String information = this.m_resolution.getInformation();
        return this.m_resolution.getPresentationName(true) + (String)(information != null && !information.isEmpty() ? " '" + information + "'" : "");
    }

    public Image getResolutionImage() {
        assert (this.m_resolution != null) : "'m_resolution' of method 'getResolutionImage' must not be null";
        return UiResourceManager.getInstance().getImage(this.m_resolution.getImageResourceName());
    }

    public Image getPriorityImage() {
        assert (this.m_resolution != null) : "Parameter 'm_resolution' of method 'getPriorityImage' must not be null";
        Priority priority = this.m_resolution.getPriority();
        switch (priority) {
            case LOW: {
                return UiResourceManager.getInstance().getImage("Low");
            }
            case MEDIUM: {
                return UiResourceManager.getInstance().getImage("Medium");
            }
            case HIGH: {
                return UiResourceManager.getInstance().getImage("High");
            }
            case NONE: {
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        assert (false) : "Unhandled priority: " + String.valueOf(priority);
        return null;
    }

    public String getConfidence() {
        assert (this.m_resolution != null) : "Parameter 'm_resolution' of method 'getConfidence' must not be null";
        String confidence = this.m_resolution.getResolutionMatchingConfidence();
        return confidence != null ? confidence : "n/a";
    }
}

