/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringData;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.ResolutionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.WildcardContentProposalProvider;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.EnumSet;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class MoveRenameRefactoringDialog
extends ResolutionDialog {
    private final RefactoringData m_data;
    private ValidatingTextWidget m_targetParentText;
    private ValidatingTextWidget m_nameText;
    private Label m_collisionInfoLabel;
    private ControlDecoration m_collisionInfoLabeDecoration;
    private ValidatingTextWidget m_targetDirectoryText;

    public MoveRenameRefactoringDialog(Shell parentShell, String title, String assignee, Priority priority, String description, ResolutionDialog.Mode mode, RefactoringData data) {
        super(parentShell, title, null, null, assignee, priority, description, mode, ResolutionDialog.AssigneeMode.SHOW);
        assert (data != null) : "Parameter 'name' of method 'MoveRenameRefactoringDialog' must not be null";
        this.m_data = data;
    }

    @Override
    protected IDialogId getDialogId() {
        return CoreDialogId.MOVE_RENAME_REFACTORING_DIALOG;
    }

    protected Point getMinimumSize() {
        Point minSize = super.getMinimumSize();
        return new Point(minSize.x + 300, minSize.y);
    }

    @Override
    protected Point getPreferredSize() {
        return null;
    }

    private void handleCollisionValidationResult(ValidationResult result) {
        assert (result != null) : "Parameter 'result' of method 'handleCollisionValidationResult' must not be null";
        if (!result.isSuccess()) {
            if (this.m_collisionInfoLabel != null && !this.m_collisionInfoLabel.isDisposed()) {
                if (this.m_collisionInfoLabeDecoration == null) {
                    this.m_collisionInfoLabeDecoration = new ControlDecoration((Control)this.m_collisionInfoLabel, 131200);
                }
                if (result.isSuccess()) {
                    this.m_collisionInfoLabeDecoration.setImage(UiResourceManager.getInstance().getImage("WarningMarker"));
                } else {
                    this.m_collisionInfoLabeDecoration.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
                }
                this.m_collisionInfoLabeDecoration.setDescriptionText(result.toFormattedString());
                this.m_collisionInfoLabeDecoration.show();
            }
        } else if (this.m_collisionInfoLabeDecoration != null) {
            this.m_collisionInfoLabeDecoration.setDescriptionText("");
            this.m_collisionInfoLabeDecoration.hide();
        }
    }

    private GridLayout createGridLayoutForImageAndTextFieldComposite() {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 6;
        layout.verticalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        boolean addMove = false;
        boolean addRename = false;
        switch (this.m_data.getPossibleRefactoringType()) {
            case NONE: {
                assert (false) : "Move/rename refactoring noy possible";
                break;
            }
            case MOVE: {
                addMove = true;
                break;
            }
            case MOVE_RENAME: {
                addMove = true;
                addRename = true;
                break;
            }
            case RENAME: {
                addRename = true;
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf(this.m_data.getPossibleRefactoringType());
                break;
            }
        }
        if (addMove) {
            Label module = new Label(composite, 0);
            module.setText("Target module:");
            module.setLayoutData((Object)new GridData(0, 0, false, false));
            Composite targetModuleImageAndText = new Composite(composite, 0);
            GridLayout targetModuleImageAndTextLayout = this.createGridLayoutForImageAndTextFieldComposite();
            targetModuleImageAndText.setLayoutData((Object)new GridData(4, 0, true, false));
            targetModuleImageAndText.setLayout((Layout)targetModuleImageAndTextLayout);
            Label targetModuleLabel = new Label(targetModuleImageAndText, 0);
            targetModuleLabel.setImage(UiResourceManager.getInstance().getImage(Module.IMAGE_RESOURCE_NAME));
            targetModuleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            String selectedModule = this.m_data.getTargetModule();
            ValidatingTextWidget targetModuleText = new ValidatingTextWidget(targetModuleImageAndText, this.m_data.getModuleNameValidator(), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    String selected = MoveRenameRefactoringDialog.this.m_data.getModuleForName(input);
                    ValidationResult validationResult = MoveRenameRefactoringDialog.this.m_data.setTargetModule(selected);
                    MoveRenameRefactoringDialog.this.handleCollisionValidationResult(validationResult);
                    MoveRenameRefactoringDialog.this.m_targetDirectoryText.updateProposals(MoveRenameRefactoringDialog.this.m_data.getAvailableTargetRootDirectories(selected).toArray(new String[0]));
                    MoveRenameRefactoringDialog.this.setOkButtonState();
                }
            }, selectedModule, this.m_data.getAvailableTargetModules(), EnumSet.of(WildcardContentProposalProvider.WildcardPosition.END));
            targetModuleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label directory = new Label(composite, 0);
            directory.setText("Target root directory:");
            directory.setLayoutData((Object)new GridData(0, 0, false, false));
            Composite targetDirectoryImageAndText = new Composite(composite, 0);
            GridLayout targetDirectoryImageAndTextLayout = this.createGridLayoutForImageAndTextFieldComposite();
            targetDirectoryImageAndText.setLayoutData((Object)new GridData(4, 0, true, false));
            targetDirectoryImageAndText.setLayout((Layout)targetDirectoryImageAndTextLayout);
            Label targetDirectoryLabel = new Label(targetDirectoryImageAndText, 0);
            targetDirectoryLabel.setImage(UiResourceManager.getInstance().getImage(RootDirectoryPath.class.getSimpleName()));
            targetDirectoryLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            String selectedRoot = this.m_data.getTargetRootDirectory().getIdentifyingPath();
            this.m_targetDirectoryText = new ValidatingTextWidget(targetDirectoryImageAndText, this.m_data.getTargetRootDirectoryValidator(), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    ValidationResult validationResult = MoveRenameRefactoringDialog.this.m_data.setTargetRootDirectoryPath(input);
                    MoveRenameRefactoringDialog.this.handleCollisionValidationResult(validationResult);
                    MoveRenameRefactoringDialog.this.setOkButtonState();
                }
            }, selectedRoot, this.m_data.getAvailableTargetRootDirectories(selectedModule), EnumSet.of(WildcardContentProposalProvider.WildcardPosition.END));
            this.m_targetDirectoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label moveToParentNameLabel = new Label(composite, 0);
            moveToParentNameLabel.setText("Target " + StringUtility.toLowerCase((String)this.m_data.getParentKind(), (boolean)true) + ": ");
            moveToParentNameLabel.setLayoutData((Object)new GridData(0, 0, false, false));
            Composite parentImageAndText = new Composite(composite, 0);
            GridLayout parentImageAndTextLayout = this.createGridLayoutForImageAndTextFieldComposite();
            parentImageAndText.setLayout((Layout)parentImageAndTextLayout);
            this.m_collisionInfoLabel = new Label(parentImageAndText, 0);
            this.m_collisionInfoLabel.setImage(UiResourceManager.getInstance().getImage(this.m_data.getParentImageResourceName()));
            this.m_collisionInfoLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            String targetParentName = this.m_data.getTargetParentName();
            this.m_targetParentText = new ValidatingTextWidget(parentImageAndText, this.m_data.getTargetParentNameValidator(), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    ValidationResult result = MoveRenameRefactoringDialog.this.m_data.setTargetParentName(input);
                    MoveRenameRefactoringDialog.this.handleCollisionValidationResult(result);
                    MoveRenameRefactoringDialog.this.setOkButtonState();
                }
            }, targetParentName != null ? targetParentName : this.m_data.getOriginalParentName(), this.m_data.getAvailableTargetParentNames(), EnumSet.of(WildcardContentProposalProvider.WildcardPosition.END));
            this.m_targetParentText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            parentImageAndText.setLayoutData((Object)new GridData(4, 0, true, false));
        } else {
            Label parentNameLabel = new Label(composite, 0);
            parentNameLabel.setText("Parent " + StringUtility.toLowerCase((String)this.m_data.getParentKind(), (boolean)true) + ": ");
            parentNameLabel.setLayoutData((Object)new GridData(0, 0, false, false));
            Composite parentImageAndText = new Composite(composite, 0);
            GridLayout parentImageAndTextLayout = this.createGridLayoutForImageAndTextFieldComposite();
            parentImageAndText.setLayout((Layout)parentImageAndTextLayout);
            this.m_collisionInfoLabel = new Label(parentImageAndText, 0);
            this.m_collisionInfoLabel.setImage(UiResourceManager.getInstance().getImage(this.m_data.getParentImageResourceName()));
            this.m_collisionInfoLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.m_targetParentText = new ValidatingTextWidget(parentImageAndText, new ITextValidator(){

                public ValidationResult isValid(String currentInput, String newInput) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Not expected for disabled ValidatingTextWidget");
                    }
                    return new ValidationResult(false);
                }
            }, new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Not expected for disabled ValidatingTextWidget");
                    }
                }
            }, this.m_data.getOriginalParentName(), false, false, 0);
            this.m_targetParentText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            parentImageAndText.setLayoutData((Object)new GridData(4, 0, true, false));
            parentImageAndText.setEnabled(false);
        }
        if (addRename) {
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText("New " + StringUtility.toLowerCase((String)this.m_data.getRefactoringElementTypePresentationName(), (boolean)true) + " name:");
            nameLabel.setLayoutData((Object)new GridData(0, 0, false, false));
            Composite nameImageAndText = new Composite(composite, 0);
            GridLayout nameImageAndTextLayout = this.createGridLayoutForImageAndTextFieldComposite();
            nameImageAndText.setLayout((Layout)nameImageAndTextLayout);
            Label elementImage = new Label(nameImageAndText, 0);
            elementImage.setImage(UiResourceManager.getInstance().getImage(this.m_data.getElementImageResourceName()));
            elementImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.m_nameText = new ValidatingTextWidget(nameImageAndText, this.m_data.getTargetNameValidator(), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                    ValidationResult validationResult = MoveRenameRefactoringDialog.this.m_data.setTargetName(input);
                    MoveRenameRefactoringDialog.this.handleCollisionValidationResult(validationResult);
                    MoveRenameRefactoringDialog.this.setOkButtonState();
                }
            }, this.m_data.getTargetName(), false, false, 0);
            this.m_nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            nameImageAndText.setLayoutData((Object)new GridData(4, 0, true, false));
        }
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        super.fillDialogArea(composite);
        this.handleCollisionValidationResult(this.m_data.getCollisionValidationResult());
    }

    @Override
    public boolean hasValidData() {
        return super.hasValidData() && this.m_data.hasValidData();
    }

    @Override
    protected boolean hasBeenModified() {
        return super.hasBeenModified() || this.m_data.hasBeenModified();
    }

    @Override
    protected void setOkButtonState() {
        ResolutionDialog.Mode mode = this.getMode();
        if (mode == ResolutionDialog.Mode.CREATE) {
            this.getButton(0).setEnabled(this.hasValidData() && this.m_data.hasBeenModified());
        } else {
            assert (mode == ResolutionDialog.Mode.EDIT) : "Unexpected mode: " + String.valueOf((Object)mode);
            super.setOkButtonState();
        }
    }

    public RefactoringData getData() {
        return this.m_data;
    }
}

