/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.ranking;

import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.ranking.IssueRankBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RankingView
extends WorkbenchSlaveView
implements ISelectionChangedListener {
    private final IssueRankBeanAdapter m_issueBeanAdapter = new IssueRankBeanAdapter();
    private PagingPropertyTableViewer<IssueRank> m_tableViewer;
    private PropertyTableViewerBasedTextSearchHandler m_textSearchProvider;
    private AnalyzerResult m_result;

    public IViewId getViewId() {
        return ViewId.RANKING_VIEW;
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    public boolean supportsCopy() {
        return !this.getSelectedElements().isEmpty();
    }

    public String copy() {
        return this.m_tableViewer.getCopyToClipboardData();
    }

    protected void createViewContent(Composite viewContentArea) {
        Composite content = new Composite(viewContentArea, 0);
        content.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1, (boolean)false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 1730;
        content.setLayoutData((Object)gridData);
        this.m_tableViewer = new PagingPropertyTableViewer(content, (BeanPropertyReader.BeanAdapter)this.m_issueBeanAdapter, "Rank", false, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE, 1000, false);
        this.m_tableViewer.addColumn("Issue", "issueName", "issueName", "issueImage", 180, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Description", "description", "description", null, 380, PropertyTableViewer.ColumnType.TEXT);
        TableViewerColumn column1 = this.m_tableViewer.addColumn("Score", "rank", "rank", null, 80, PropertyTableViewer.ColumnType.NUMBER);
        column1.getColumn().setAlignment(131072);
        column1.getColumn().setWidth(80);
        TableViewerColumn column2 = this.m_tableViewer.addColumn("Urgency", "urgency", "urgency", null, 60, PropertyTableViewer.ColumnType.NUMBER);
        column2.getColumn().setWidth(60);
        TableViewerColumn column3 = this.m_tableViewer.addColumn("Importance", "importance", "importance", null, 80, PropertyTableViewer.ColumnType.NUMBER);
        column3.getColumn().setWidth(80);
        this.m_tableViewer.addColumn("Severity", "severity", "severitySort", "severityImage", 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Category", "categoryName", "categoryName", null, 140, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Element", "elementOrFrom", "elementOrFrom", "elementOrFromImage", 250, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("To Element", "to", "to", "toImage", 250, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.addColumn("Provider", "issueProviderName", "issueProviderName", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_textSearchProvider = new PropertyTableViewerBasedTextSearchHandler(this.m_tableViewer, this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                AnalyzerExecutionLevel analyzerExecutionLevel = WorkbenchRegistry.getInstance().getProvider().getAnalyzerExecutionLevel();
                if (analyzerExecutionLevel == AnalyzerExecutionLevel.FULL) {
                    RankingView.this.clear();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult analyzerResult;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (RankingView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (analyzerResult = event.getResult()).getId() == CoreAnalyzerId.ISSUE_RANKING) {
                    RankingView.this.m_result = analyzerResult;
                    RankingView.this.show(true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (RankingView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.contains((IAnalyzerId)CoreAnalyzerId.ISSUE_RANKING)) {
                    RankingView.this.clear();
                }
            }
        });
        this.addListeners();
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_tableViewer.getTable());
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public List<Element> getSelectedElements() {
        return new ArrayList<Element>(this.m_tableViewer.getSelected());
    }

    private void addListeners() {
        this.m_tableViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_tableViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Control getSelectedViewComponent() {
        return this.m_tableViewer.getTable();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.addStateInfo(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)event.getSelection());
        this.addListeners();
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.getContentArea().setRedraw(false);
        this.removeListeners();
        this.restoreState(state);
        this.addListeners();
        this.getContentArea().setRedraw(true);
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        this.addStateInfo(state);
    }

    private void addStateInfo(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'addStateInfo' must not be null";
        List tableSelection = this.getSelectedElements().stream().filter(e -> e instanceof IssueRank).map(e -> (IssueRank)e).collect(Collectors.toList());
        state.addElementsInformation((IElementGroup)ElementGroups.TABLE_SELECTION, NavigationState.getDescriptors(tableSelection, (IElementResolver)this.getElementResolver()));
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        for (Analyzer analyzer : ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getChildren(Analyzer.class)) {
            if (analyzer.getId().getGroup() != AnalyzerGroup.ISSUE_RANKING || analyzer.getState() != AnalyzerState.FINISHED) continue;
            this.m_result = analyzer.getResult();
            break;
        }
        this.show(mode == WorkbenchView.ShowMode.AWAKE);
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.refresh(restoredFromHistory);
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.clear();
        this.addListeners();
    }

    private void refresh(boolean restoredFromHistory) {
        this.show(restoredFromHistory);
        this.m_textSearchProvider.requestNewFindInfo();
    }

    private void show(boolean restoredFromHistory) {
        NavigationState state;
        assert (this.m_tableViewer != null) : "'m_propertyTableViewer' of method 'show' must not be null";
        this.getContentArea().setRedraw(false);
        this.removeListeners();
        if (this.m_result == null) {
            this.clear();
        } else {
            this.showIssues();
        }
        if (restoredFromHistory && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            this.restoreState(state);
        }
        this.addListeners();
        this.getContentArea().setRedraw(true);
    }

    private void restoreState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        StructuredSelection selection = new StructuredSelection(state.getElements((IElementGroup)ElementGroups.TABLE_SELECTION, IssueRank.class, this.getElementResolver()).toArray());
        this.m_tableViewer.getTableViewer().setSelection((ISelection)selection, true);
    }

    private void showIssues() {
        this.m_tableViewer.showData((Collection)this.m_result.getChildren(IssueRank.class));
    }

    public void clearSelection(Control control) {
        if (control == this.m_tableViewer.getTable()) {
            this.m_tableViewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void clear() {
        this.m_result = null;
        this.m_tableViewer.showData(Collections.emptyList());
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        List rankings = elements.stream().filter(e -> e instanceof IssueRank).map(e -> (IssueRank)e).collect(Collectors.toList());
        this.m_tableViewer.getTableViewer().setSelection((ISelection)new StructuredSelection(rankings), true);
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_tableViewer != null && !this.m_tableViewer.isDisposed() && !this.m_tableViewer.getFilteredInputData().isEmpty();
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getRankedIssues(this.m_tableViewer.getFilteredInputData());
    }

    private static enum ElementGroups implements IElementGroup
    {
        TABLE_SELECTION;

    }
}

