/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.qualitygate.DeleteQualityGateElementsCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

public final class DeleteQualityGateElementsCommandAdapter
extends CompositeCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_QUALITY_GATE_ELEMENTS;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && !elements.isEmpty()) {
            List deletables = ((IQualityGateProvider)provider.getSoftwareSystem().getExtension(IQualityGateProvider.class)).getDeletableElements(elements);
            if (deletables.isEmpty()) {
                return null;
            }
            if (deletables.size() == 1) {
                return new CompositeCommandAdapter.Applicable(((IQualityGateElement)deletables.get(0)).getPresentationKind());
            }
            return new CompositeCommandAdapter.Applicable("Quality Gate Elements");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        final List deletables = ((IQualityGateProvider)provider.getSoftwareSystem().getExtension(IQualityGateProvider.class)).getDeletableElements(elements);
        assert (deletables != null && !deletables.isEmpty()) : "Parameter 'deletables' of method 'apply' must not be empty";
        final QualityGate qualityGate = (QualityGate)((NamedElement)deletables.get(0)).getParent(QualityGate.class, new Class[0]);
        DeleteQualityGateElementsCommand command = new DeleteQualityGateElementsCommand(provider, new DeleteQualityGateElementsCommand.IDeleteInteraction(){

            public boolean collect(DeleteQualityGateElementsCommand.DeleteInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setElementsToDelete(deletables);
                data.setQualityGate(qualityGate);
                return true;
            }

            public void handleResult(OperationResultWithOutcome<QualityGate> result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processDeleteOperationsResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

