/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.MapBackedCombo;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.AbstractQualityGateIssueElementWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class BaselineIssueConditionWizardPage
extends AbstractQualityGateIssueElementWizardPage {
    private MapBackedCombo<Operator> m_operatorCombo;
    private Operator m_operator = Operator.N_A;
    private Operator m_originalOperator;
    private Button m_absoluteThresholdButton;
    private ValidatingTextWidget m_absoluteThresholdText;
    private Float m_absoluteThreshold = null;
    private Float m_originalAbsoluteThreshold;
    private Button m_relativeThresholdButton;
    private ValidatingTextWidget m_relativeThresholdText;
    private Float m_relativeThreshold = null;
    private Float m_originalRelativeThreshold;
    private QualityGateDiffCheck m_check = QualityGateDiffCheck.STRICT;
    private QualityGateDiffCheck m_originalCheck;
    private boolean m_doesIssueTypeSupportMetricId = false;
    private Button m_strictButton;
    private Button m_relaxedButton;

    public BaselineIssueConditionWizardPage(String pageId, IQualityGateProvider provider, List<String> availableIssueIds, List<String> availableMetricIds) {
        super(pageId, "Quality Gate Condition", provider, availableIssueIds, availableMetricIds);
    }

    public BaselineIssueConditionWizardPage(String pageId, IQualityGateProvider provider, List<String> availableIssueIds, List<String> availableMetricIds, String issueType, List<String> severities, List<String> resolutions, String metricId, Operator operator, Float absoluteThreshold, Float relativeThreshold, QualityGateDiffCheck check) {
        super(pageId, "Quality Gate Condition", provider, availableIssueIds, availableMetricIds, issueType, severities, resolutions, metricId);
        this.m_originalOperator = operator;
        this.m_operator = operator;
        this.m_originalAbsoluteThreshold = absoluteThreshold;
        this.m_absoluteThreshold = absoluteThreshold;
        this.m_originalRelativeThreshold = relativeThreshold;
        this.m_relativeThreshold = relativeThreshold;
        this.m_originalCheck = check;
        this.m_check = check;
        this.m_doesIssueTypeSupportMetricId = IssueDiffAgainstBaselineCondition.doesIssueTypeSupportMetricId((String)issueType);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.QUALITY_GATE_BASELINE_ISSUE_CONDITION_WIZARD_PAGE;
    }

    @Override
    boolean isThresholdCondition() {
        return IssueDiffAgainstBaselineCondition.isMetricInfoRelevant((String)this.getIssueType(), (String)this.getMetricId());
    }

    Operator getOperator() {
        return this.m_operator;
    }

    Float getThresholdAbsolute() {
        return this.m_absoluteThreshold;
    }

    Float getThresholdRelative() {
        return this.m_relativeThreshold;
    }

    QualityGateDiffCheck getCheck() {
        if (this.getQualityGateProvider().isRelaxedSupportedByIssueType(this.getIssueType())) {
            return this.m_check;
        }
        return null;
    }

    @Override
    protected boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this.m_operator != this.m_originalOperator || this.m_check != this.m_originalCheck) {
            return true;
        }
        if (!NumberUtility.areEqual((Float)this.m_absoluteThreshold, (Float)this.m_originalAbsoluteThreshold)) {
            return true;
        }
        return !NumberUtility.areEqual((Float)this.m_relativeThreshold, (Float)this.m_originalRelativeThreshold);
    }

    @Override
    protected ValidatingTextOrComboWidget.IConsumer createIssueTypeConsumer() {
        return new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                BaselineIssueConditionWizardPage.this.setIssueType(input != null ? input.trim() : null);
                BaselineIssueConditionWizardPage.this.m_doesIssueTypeSupportMetricId = input != null ? IssueDiffAgainstBaselineCondition.doesIssueTypeSupportMetricId((String)BaselineIssueConditionWizardPage.this.getIssueType()) : false;
                BaselineIssueConditionWizardPage.this.enableMetricIdInput(BaselineIssueConditionWizardPage.this.m_doesIssueTypeSupportMetricId);
                if (BaselineIssueConditionWizardPage.this.m_doesIssueTypeSupportMetricId) {
                    BaselineIssueConditionWizardPage.this.getMetricIdText().validate(false);
                }
                if (input != null && input.trim().length() > 0) {
                    List severities = BaselineIssueConditionWizardPage.this.getQualityGateProvider().getSeveritiesForIssueType(input.trim());
                    BaselineIssueConditionWizardPage.this.updateSeverityChoices(severities);
                }
                BaselineIssueConditionWizardPage.this.m_operatorCombo.setEnabled(BaselineIssueConditionWizardPage.this.m_doesIssueTypeSupportMetricId);
                BaselineIssueConditionWizardPage.this.enableThresholdInput(BaselineIssueConditionWizardPage.this.m_doesIssueTypeSupportMetricId);
                BaselineIssueConditionWizardPage.this.validateInput();
            }
        };
    }

    @Override
    protected void createContent(Composite composite) {
        this.createStandardInputWidgets(composite);
        this.createMetricIdWidgets(composite, "Metric ID:");
        Label operatorLabel = new Label(composite, 0);
        operatorLabel.setText("Operator:");
        operatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_operatorCombo = new MapBackedCombo<Operator>(composite, 8, op -> op.getSymbol());
        this.m_operatorCombo.setLayoutData(new GridData(4, 4, false, false));
        this.m_operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Operator previous = BaselineIssueConditionWizardPage.this.m_operator;
                BaselineIssueConditionWizardPage.this.m_operator = BaselineIssueConditionWizardPage.this.m_operatorCombo.getItemForLabel(BaselineIssueConditionWizardPage.this.m_operatorCombo.getText());
                if (BaselineIssueConditionWizardPage.this.m_operator != previous && (previous == Operator.N_A || BaselineIssueConditionWizardPage.this.m_operator == Operator.N_A)) {
                    BaselineIssueConditionWizardPage.this.enableThresholdInput(BaselineIssueConditionWizardPage.this.m_operator != Operator.N_A);
                }
                BaselineIssueConditionWizardPage.this.validateInput();
            }
        });
        EnumSet<Operator> operators = EnumSet.allOf(Operator.class);
        this.m_operatorCombo.setInput(operators);
        this.m_operatorCombo.selectElement(this.m_operator);
        this.m_absoluteThresholdButton = new Button(composite, 32);
        this.m_absoluteThresholdButton.setText("Absolute Threshold:");
        this.m_absoluteThresholdButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_absoluteThresholdText = new ValidatingTextWidget(composite, this.createFloatValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                BaselineIssueConditionWizardPage.this.m_absoluteThreshold = input != null ? Float.valueOf(Float.parseFloat(input.trim())) : null;
                BaselineIssueConditionWizardPage.this.validateInput();
            }
        }, this.m_absoluteThreshold != null ? this.m_absoluteThreshold.toString() : "", 0);
        this.m_absoluteThresholdText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_absoluteThresholdButton.setSelection(this.m_absoluteThreshold != null);
        this.m_absoluteThresholdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaselineIssueConditionWizardPage.this.m_absoluteThresholdButton.getSelection();
                BaselineIssueConditionWizardPage.this.m_absoluteThresholdText.setEnabled(enabled);
                if (enabled) {
                    if (BaselineIssueConditionWizardPage.this.m_operator == null || BaselineIssueConditionWizardPage.this.m_operator == Operator.N_A) {
                        BaselineIssueConditionWizardPage.this.m_operator = Operator.LESS_OR_EQUAL;
                        BaselineIssueConditionWizardPage.this.m_operatorCombo.selectElement(BaselineIssueConditionWizardPage.this.m_operator);
                    }
                    BaselineIssueConditionWizardPage.this.m_absoluteThresholdText.validate(true);
                } else {
                    BaselineIssueConditionWizardPage.this.m_absoluteThreshold = null;
                    BaselineIssueConditionWizardPage.this.m_absoluteThresholdText.clearDecoration();
                    BaselineIssueConditionWizardPage.this.validateInput();
                }
            }
        });
        this.m_relativeThresholdButton = new Button(composite, 32);
        this.m_relativeThresholdButton.setText("Relative Threshold:");
        this.m_relativeThresholdButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_relativeThresholdButton.setSelection(this.m_relativeThreshold != null);
        this.m_relativeThresholdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaselineIssueConditionWizardPage.this.m_relativeThresholdButton.getSelection();
                BaselineIssueConditionWizardPage.this.m_relativeThresholdText.setEnabled(enabled);
                if (enabled) {
                    if (BaselineIssueConditionWizardPage.this.m_operator == null) {
                        BaselineIssueConditionWizardPage.this.m_operator = Operator.LESS_OR_EQUAL;
                        BaselineIssueConditionWizardPage.this.m_operatorCombo.selectElement(BaselineIssueConditionWizardPage.this.m_operator);
                    }
                    BaselineIssueConditionWizardPage.this.m_relativeThresholdText.validate(true);
                } else {
                    BaselineIssueConditionWizardPage.this.m_relativeThreshold = null;
                    BaselineIssueConditionWizardPage.this.m_relativeThresholdText.clearDecoration();
                    BaselineIssueConditionWizardPage.this.validateInput();
                }
            }
        });
        this.m_relativeThresholdText = new ValidatingTextWidget(composite, this.createFloatValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                BaselineIssueConditionWizardPage.this.m_relativeThreshold = input != null ? Float.valueOf(Float.parseFloat(input)) : null;
                BaselineIssueConditionWizardPage.this.validateInput();
            }
        }, this.m_relativeThreshold != null ? this.m_relativeThreshold.toString() : "", 0);
        this.m_relativeThresholdText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label checkLabel = new Label(composite, 0);
        checkLabel.setText("Type of Check:");
        Composite checkRadioComposite = new Composite(composite, 0);
        checkRadioComposite.setLayout((Layout)new FillLayout(256));
        this.m_strictButton = new Button(checkRadioComposite, 16);
        this.m_strictButton.setText(QualityGateDiffCheck.STRICT.getPresentationName());
        this.m_relaxedButton = new Button(checkRadioComposite, 16);
        this.m_relaxedButton.setText(QualityGateDiffCheck.RELAXED.getPresentationName());
        boolean selectRelaxed = this.m_check == QualityGateDiffCheck.RELAXED;
        this.m_strictButton.setSelection(!selectRelaxed);
        this.m_relaxedButton.setSelection(selectRelaxed);
        this.m_strictButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaselineIssueConditionWizardPage.this.m_check = BaselineIssueConditionWizardPage.this.m_strictButton.getSelection() ? QualityGateDiffCheck.STRICT : QualityGateDiffCheck.RELAXED;
                BaselineIssueConditionWizardPage.this.validateInput();
            }
        });
        this.m_operatorCombo.setEnabled(this.m_operator != null);
        this.enableMetricIdInput(this.m_doesIssueTypeSupportMetricId);
        this.enableThresholdInput(this.m_doesIssueTypeSupportMetricId);
        this.createInfoWidget(composite);
        this.finishCreateContent();
    }

    @Override
    protected void metricIdUpdated(String metricId) {
        if ("Any".equalsIgnoreCase(metricId)) {
            this.m_operatorCombo.setInput(EnumSet.allOf(Operator.class));
            this.m_operator = Operator.N_A;
            this.m_operatorCombo.selectElement(this.m_operator);
        }
    }

    @Override
    protected boolean validateInputFields() {
        boolean relaxedSupported;
        boolean isValid = true;
        String issueType = this.getIssueType();
        this.setInfoText("");
        ArrayList<String> infoLines = new ArrayList<String>();
        if (issueType == null || this.m_doesIssueTypeSupportMetricId && this.getMetricId().trim().length() == 0) {
            isValid = false;
        } else if (this.m_doesIssueTypeSupportMetricId) {
            this.getMetricIdText().validate(false);
            if (!this.getMetricIdText().isValid()) {
                infoLines.add("Invalid metric id.");
            }
            if (!this.m_absoluteThresholdButton.getSelection() && !this.m_relativeThresholdButton.getSelection() && this.m_operator != null && this.m_operator != Operator.N_A) {
                infoLines.add("If operator is specified, either an absolute and/or relative threshold must be defined.");
                isValid = false;
            } else if (this.m_absoluteThresholdButton.isEnabled() && this.m_absoluteThresholdButton.getSelection() && this.m_absoluteThreshold == null) {
                isValid = false;
            } else if (this.m_relativeThresholdButton.isEnabled() && this.m_relativeThresholdButton.getSelection() && this.m_relativeThreshold == null) {
                isValid = false;
            } else if (this.m_absoluteThresholdButton.isEnabled() && this.m_absoluteThresholdButton.getSelection() && this.m_absoluteThreshold != null && this.m_relativeThresholdButton.isEnabled() && this.m_relativeThresholdButton.getSelection() && this.m_relativeThreshold != null) {
                float product = this.m_absoluteThreshold.floatValue() * this.m_relativeThreshold.floatValue();
                if (Float.compare(0.0f, product) > 0) {
                    infoLines.add("Absolute and relative thresholds must either be both < 0 or both > 0.");
                    isValid = false;
                } else if (Float.compare(this.m_absoluteThreshold.floatValue(), 0.0f) == 0 && Float.compare(this.m_relativeThreshold.floatValue(), 0.0f) != 0) {
                    infoLines.add("If absolute threshold is set to 0, relative threshold cannot be != 0.");
                    isValid = false;
                } else if (Float.compare(this.m_relativeThreshold.floatValue(), 0.0f) == 0 && Float.compare(this.m_absoluteThreshold.floatValue(), 0.0f) != 0) {
                    infoLines.add("If relative threshold is set to 0, absolute threshold cannot be != 0.");
                    isValid = false;
                }
            }
        } else {
            this.m_absoluteThresholdText.clearDecoration();
            this.m_relativeThresholdText.clearDecoration();
        }
        isValid = this.validateSeverity(infoLines) && isValid;
        isValid = this.validateResolution(infoLines) && isValid;
        boolean bl = relaxedSupported = issueType == null ? false : this.getQualityGateProvider().isRelaxedSupportedByIssueType(issueType);
        if (this.m_check == null && relaxedSupported) {
            this.m_strictButton.setSelection(relaxedSupported);
            this.m_relaxedButton.setSelection(!relaxedSupported);
            this.m_check = QualityGateDiffCheck.STRICT;
        }
        this.m_strictButton.setEnabled(relaxedSupported);
        this.m_relaxedButton.setEnabled(relaxedSupported);
        if (isValid) {
            String infoText = this.isThresholdCondition() ? ThresholdIssueDiffAgainstBaselineCondition.getPresentationNameLong(this.getSeverities(), this.getResolutions(), (String)this.getMetricId(), (Operator)this.getOperator(), (Float)this.m_absoluteThreshold, (Float)this.m_relativeThreshold, (QualityGateDiffCheck)this.m_check) : IssueDiffAgainstBaselineCondition.getPresentationNameLong((String)issueType, this.getSeverities(), this.getResolutions(), (QualityGateDiffCheck)(relaxedSupported ? this.m_check : null));
            this.setInfoText(infoText);
        } else {
            this.setInfoText(infoLines.stream().collect(Collectors.joining("\n")));
        }
        return isValid;
    }

    @Override
    protected ITextValidator createMetricIdValidator() {
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().isEmpty()) {
                    result.addError("Must not be empty. Use 'Any' as wildcard if metric id is not relevant.");
                } else if ("Any".equalsIgnoreCase(newInput.trim()) && BaselineIssueConditionWizardPage.this.m_operator != Operator.N_A) {
                    result.addError("If operator is specified, a metric id must be provided.");
                }
                return result;
            }
        };
    }

    private void enableThresholdInput(boolean enable) {
        this.m_absoluteThresholdButton.setEnabled(enable);
        this.m_absoluteThresholdText.setEnabled(enable && this.m_absoluteThresholdButton.getSelection());
        this.m_relativeThresholdButton.setEnabled(enable);
        this.m_relativeThresholdText.setEnabled(enable && this.m_relativeThresholdButton.getSelection());
        if (!enable) {
            this.m_absoluteThreshold = null;
            this.m_relativeThreshold = null;
        } else {
            if (this.m_absoluteThreshold == null && this.m_absoluteThresholdButton.getSelection()) {
                this.m_absoluteThresholdText.validate(true);
            }
            if (this.m_relativeThreshold == null && this.m_relativeThresholdButton.getSelection()) {
                this.m_relativeThresholdText.validate(true);
            }
        }
    }
}

