/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.parserdependenciesview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CollectParserDependenciesCommand;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.IViewWithTextFilterWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.SimpleWorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.standalone.parserdependenciesview.DependencyBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CancellableUiWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphView;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ParserDependenciesView
extends SimpleWorkbenchAuxiliaryView
implements IContextWorkbenchView,
IViewWithTextFilterWidget {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserDependenciesView.class);
    private PagingPropertyTableViewer<ContextParserDependency> m_dependenciesViewer;
    private IContextWorkbenchView.ContextAndElement<Element> m_currentlyDisplayed;
    private PropertyTableViewerBasedTextSearchHandler m_textSearchHandler;
    private WorkbenchView m_candidateView;
    private CancellableUiWorkerContext m_currentWorkerContext;
    private CollectParserDependenciesCommand m_currentCommand;

    protected ParserDependenciesView() {
    }

    final IWorkbenchView getCandidateView() {
        return this.m_candidateView;
    }

    @Override
    public boolean isFilterWidgetShown() {
        return this.m_dependenciesViewer != null && !this.m_dependenciesViewer.isDisposed() && this.m_dependenciesViewer.isTextFilterShown();
    }

    @Override
    public final void showFilterWidget(boolean show) {
        if (show) {
            this.m_dependenciesViewer.showTextFilter();
        } else {
            this.m_dependenciesViewer.hideTextFilter();
        }
    }

    final void pin() {
        if (this.m_candidateView != null) {
            if (this.getConnectedView() != this.m_candidateView) {
                this.connect(this.m_candidateView);
                this.handleSelection(this.m_candidateView, this.m_candidateView.getSelectedElements());
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_OPTIONS_CHANGED);
                this.completeNavigationState(state, this.getSelectedElements());
                ViewNavigationManager.getInstance().addNavigationState(state);
            } else {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Pin not possible: already connected to '" + String.valueOf(this.m_candidateView.getViewId()) + ".");
            }
        } else {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Pin not possible: no candidate view.");
        }
    }

    protected final boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        IViewId viewId = view.getViewId();
        if (ViewId.SOURCE_VIEW.equals((Object)viewId) || ViewId.DEPENDENCIES_VIEW.equals((Object)viewId) || ViewId.CYCLE_VIEW.equals((Object)viewId) || view instanceof GraphView && ((GraphView)view).getEndpointType() == EndpointType.PARSER_DEPENDENCY || ViewId.EXPLORATION_VIEW.equals((Object)viewId) || ViewId.ARCHITECTURE_VIEW.equals((Object)viewId)) {
            if (this.m_candidateView != view) {
                this.m_candidateView = view;
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Set as candidate view.");
            } else {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Already set as candidate view.");
            }
            if (this.getConnectedView() == null || force) {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Connect to '" + String.valueOf(view.getViewId()) + "'!");
                return true;
            }
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Do not connect to '" + String.valueOf(view.getViewId()) + "'!");
            return false;
        }
        return false;
    }

    protected final EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.noneOf(Gesture.class);
    }

    public final StructureMode getStructureMode() {
        return StructureMode.NON_RECURSIVE;
    }

    public final IContext getContext() {
        if (this.m_currentlyDisplayed != null) {
            return this.m_currentlyDisplayed.getContext();
        }
        return super.getContext();
    }

    protected final void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_dependenciesViewer = new PagingPropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new DependencyBeanAdapter(CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)), null, true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_dependenciesViewer.addColumn("From File", "fromFileAsString", "fromFileAsString", "fromFileImage", 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumn("Line", "lineNumber", "lineNumberForSort", null, 5, PropertyTableViewer.ColumnType.NUMBER);
        this.m_dependenciesViewer.addColumn("From", "from", "from", "fromImage", 13, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumn(" ", "emptyText", "violation", "dependencyImage", 3, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumn("Dependency", "dependencyInfo", "dependencyInfo", null, 13, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumn("To", "to", "to", "toImage", 24, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumn("To File", "toFileAsString", "toFileAsString", "toFileImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_dependenciesViewer.addColumnValueMapper("lineNumber", (Object)-1, "n/a");
        ArrayList<StrictPair> sortOrder = new ArrayList<StrictPair>();
        sortOrder.add(new StrictPair((Object)"fromFileAsString", (Object)false));
        sortOrder.add(new StrictPair((Object)"lineNumberForSort", (Object)true));
        sortOrder.add(new StrictPair((Object)"toFileAsString", (Object)true));
        sortOrder.add(new StrictPair((Object)"to", (Object)true));
        this.m_dependenciesViewer.setSortOrder(sortOrder);
        this.m_textSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_dependenciesViewer, this.getViewId().getPresentationName());
        this.initialize();
        EventManager.getInstance().attach((EventHandler)new EventHandler<ContextsModifiedEvent>(ContextsModifiedEvent.class, (Object)this){

            public void handleEvent(ContextsModifiedEvent event) {
                if (ParserDependenciesView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && ParserDependenciesView.this.m_currentlyDisplayed != null && !ParserDependenciesView.this.m_currentlyDisplayed.isValid()) {
                    ParserDependenciesView.this.displayOrReset(null);
                }
            }
        });
    }

    private void clear() {
        this.resetPartName();
        this.m_dependenciesViewer.setAdditionalFirstColumnInfo(null);
        this.m_dependenciesViewer.showData(null);
        this.setTitleTooltip(null);
    }

    private void cancelCollect(boolean inDestroy) {
        if (!inDestroy) {
            this.clear();
        }
        if (this.m_currentWorkerContext != null) {
            assert (this.m_currentCommand != null) : "'m_currentCommand' of method 'cancelCollect' must not be null";
            this.m_currentWorkerContext.cancel();
            this.m_currentWorkerContext = null;
            this.m_currentCommand = null;
        }
    }

    protected final void destroyViewContent() {
        this.cancelCollect(true);
        EventManager.getInstance().detach(ContextsModifiedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    protected final void connect(WorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'connect' must not be null";
        this.m_candidateView = view;
        super.connect(view);
    }

    protected final void disconnect() {
        this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.displayOrReset(null);
        this.m_candidateView = null;
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_OPTIONS_CHANGED);
        this.completeNavigationState(state, this.getSelectedElements());
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        super.disconnect();
    }

    protected final void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
            this.displayOrReset(null);
        } else if (this.m_currentlyDisplayed != null) {
            if (this.m_currentlyDisplayed.isValid()) {
                this.displayOrReset(this.m_currentlyDisplayed);
            } else {
                this.displayOrReset(null);
            }
        }
        this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected final void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
            Collection deps = this.m_dependenciesViewer.getInputData();
            if (deps != null) {
                deps.forEach(p -> p.refreshViolationState());
            }
            this.m_dependenciesViewer.getTableViewer().refresh();
            this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected final void softwareSystemHide(WorkbenchView.HideMode mode) {
        this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.displayOrReset(null);
        this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        if (mode == WorkbenchView.HideMode.ASLEEP) {
            this.m_candidateView = null;
        }
        super.softwareSystemHide(mode);
    }

    private Element getElementToBeDisplayed(WorkbenchView connectedView, Element element) {
        ProgrammingElement from;
        SourceFile sourceFile;
        assert (connectedView != null) : "Parameter 'connectedView' of method 'getCurrentlyDisplayedElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getCurrentlyDisplayedElement' must not be null";
        if (connectedView.getViewId() == ViewId.SOURCE_VIEW && element instanceof ParserDependency && (sourceFile = (SourceFile)(from = ((ParserDependency)element).getFrom()).getParent(SourceFile.class, new Class[0])) != null) {
            return sourceFile;
        }
        return element;
    }

    protected final void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        Element element = elements.size() == 1 ? this.getElementToBeDisplayed(connectedView, elements.get(0)) : null;
        this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.displayOrReset(element != null && element.isValid() ? new IContextWorkbenchView.ContextAndElement(connectedView.getContext(), element) : null);
        this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private String calculateAdditionalInfo(List<ContextParserDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'calculateAdditionalInfo' must not be null";
        if (dependencies.isEmpty()) {
            return null;
        }
        THashSet fromFiles = new THashSet();
        THashSet toFiles = new THashSet();
        for (ContextParserDependency next : dependencies) {
            FilePath toFile;
            ProgrammingElement to;
            FilePath fromFile = (FilePath)next.getFrom().getParent(FilePath.class, ParentMode.FIRST_PARENT);
            if (fromFile != null) {
                fromFiles.add(fromFile);
            }
            if ((to = next.getTo()) == null || (toFile = (FilePath)to.getParent(FilePath.class, ParentMode.FIRST_PARENT)) == null) continue;
            toFiles.add(toFile);
        }
        return fromFiles.size() + " -> " + toFiles.size() + " File(s)";
    }

    protected abstract CollectParserDependenciesCommand createCollectionCommand(IContext var1, Element var2);

    private void displayOrReset(IContextWorkbenchView.ContextAndElement<Element> display) {
        this.cancelCollect(false);
        this.m_currentlyDisplayed = display;
        this.m_textSearchHandler.requestNewFindInfo();
        if (this.m_currentlyDisplayed == null || !this.getSoftwareSystemProvider().hasSoftwareSystem() || this.m_dependenciesViewer.isDisposed()) {
            this.m_currentlyDisplayed = null;
            return;
        }
        final CollectParserDependenciesCommand command = this.createCollectionCommand(display.getContext(), display.getElement());
        Result enabledResult = command.isEnabled();
        if (enabledResult.isFailure()) {
            LOGGER.error("Command '" + String.valueOf(command.getId()) + "' not enabled: " + enabledResult.toString() + " for " + String.valueOf(this.m_currentlyDisplayed));
            this.m_currentlyDisplayed = null;
            return;
        }
        this.m_dependenciesViewer.setAdditionalFirstColumnInfo("Calculating...");
        this.m_dependenciesViewer.showData(Collections.emptyList());
        this.m_currentCommand = command;
        this.m_currentWorkerContext = new CancellableUiWorkerContext(this.m_dependenciesViewer.getDisplay());
        UserInterfaceAdapter.getInstance().run((Command)command, (IWorkerContext)this.m_currentWorkerContext, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (ParserDependenciesView.this.m_currentCommand == command && ParserDependenciesView.this.m_dependenciesViewer != null && !ParserDependenciesView.this.m_dependenciesViewer.isDisposed()) {
                    Table table = ParserDependenciesView.this.m_dependenciesViewer.getTable();
                    table.setRedraw(false);
                    boolean clear = true;
                    if (exception == null && ParserDependenciesView.this.getConnectedView() != null && ParserDependenciesView.this.m_currentlyDisplayed != null && ParserDependenciesView.this.m_currentlyDisplayed.isValid() && command.getResult() != null) {
                        ParserDependenciesView.this.m_dependenciesViewer.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)ParserDependenciesView.this);
                        List dependencies = command.getResult().getDependencies();
                        ParserDependenciesView.this.m_dependenciesViewer.setAdditionalFirstColumnInfo(ParserDependenciesView.this.calculateAdditionalInfo(dependencies));
                        ParserDependenciesView.this.m_dependenciesViewer.showData((Collection)dependencies);
                        ParserDependenciesView.this.setTitleTooltip(ParserDependenciesView.this.getConnectedView().getPresentationName() + (String)(dependencies == null || dependencies.isEmpty() ? "" : ": " + ParserDependenciesView.this.m_currentlyDisplayed.getElement().getPresentationName(false)));
                        ParserDependenciesView.this.m_dependenciesViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)ParserDependenciesView.this);
                        clear = false;
                    }
                    if (clear) {
                        ParserDependenciesView.this.clear();
                    }
                    table.setRedraw(true);
                    ParserDependenciesView.this.m_currentCommand = null;
                    ParserDependenciesView.this.m_currentWorkerContext = null;
                }
            }
        });
    }

    private List<Element> getElementsFromSelection(IStructuredSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'getElementsFromSelection' must not be null";
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>(selection.size());
        for (Object next : selection.toList()) {
            assert (next instanceof ContextParserDependency) : "Unexpected class in method 'getElementsFromSelection': " + String.valueOf(next);
            elements.add((Element)((ContextParserDependency)next).getElement());
        }
        return elements;
    }

    @Override
    protected final Map<Element, Element> getElementMapping(Collection<Element> currentInput) {
        assert (currentInput != null) : "Parameter 'currentInput' of method 'getElementMapping' must not be null";
        if (currentInput.isEmpty()) {
            return Collections.emptyMap();
        }
        THashMap mapping = new THashMap();
        for (Element next : currentInput) {
            assert (next != null && next instanceof ContextParserDependency) : "Unexpected class in method 'getElementMapping': " + String.valueOf(next);
            mapping.put(next.getElement(), next);
        }
        return mapping;
    }

    public List<Element> getSelectedElements() {
        return this.getElementsFromSelection(this.m_dependenciesViewer.getSelection());
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        this.m_dependenciesViewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    protected PropertyTableViewer<? extends Element> getViewer() {
        return this.m_dependenciesViewer;
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_currentlyDisplayed != null && this.m_dependenciesViewer != null && !this.m_dependenciesViewer.isDisposed() && !this.m_dependenciesViewer.getFilteredInputData().isEmpty();
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getParserDependencies(this.m_currentlyDisplayed.getContext(), this.m_dependenciesViewer.getFilteredInputData());
    }

    public boolean supportsCopy() {
        return this.isActive() && this.m_dependenciesViewer.hasCopyToClipBoardData();
    }

    public String copy() {
        return this.m_dependenciesViewer.getCopyToClipboardData();
    }

    public final Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected final ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }
}

