/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.foundation.calculations.SimpleStatistics;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MetricsInfo
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsInfo.class);
    private final Label m_values;
    private final Label m_minValue;
    private final Label m_maxValue;
    private final Label m_meanValue;
    private final Label m_stdDeviationValue;
    private final Label m_medianValue;
    private final Label m_lowerThreshold;
    private final Label m_upperThreshold;

    private static Label addLabel(Composite parent, String text, boolean bold) {
        assert (parent != null) : "Parameter 'parent' of method 'addLabel' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'addLabel' must not be empty";
        Label label = new Label(parent, 0);
        label.setText(text);
        if (bold) {
            label.setFont(UiResourceManager.getInstance().getFont(1));
        }
        label.setLayoutData((Object)new GridData(1, 1, true, false));
        return label;
    }

    private static Composite createColumnComposite(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createColumnComposite' must not be null";
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        Composite column = new Composite(parent, 0);
        column.setLayout((Layout)gridLayout);
        return column;
    }

    MetricsInfo(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginLeft = 4;
        gridLayout.marginRight = 4;
        gridLayout.marginTop = 4;
        gridLayout.marginBottom = 4;
        gridLayout.marginHeight = 4;
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        Composite firstColumn = MetricsInfo.createColumnComposite(this);
        firstColumn.setLayoutData((Object)new GridData(1, 1, false, false));
        MetricsInfo.addLabel(firstColumn, "Values: ", true);
        this.m_values = MetricsInfo.addLabel(firstColumn, "n/a", false);
        MetricsInfo.addLabel(firstColumn, "Minimum: ", true);
        this.m_minValue = MetricsInfo.addLabel(firstColumn, "n/a", false);
        MetricsInfo.addLabel(firstColumn, "Maximum: ", true);
        this.m_maxValue = MetricsInfo.addLabel(firstColumn, "n/a", false);
        Composite secondColumn = MetricsInfo.createColumnComposite(this);
        secondColumn.setLayoutData((Object)new GridData(1, 1, false, false));
        MetricsInfo.addLabel(secondColumn, "Arithmetic average: ", true);
        this.m_meanValue = MetricsInfo.addLabel(secondColumn, "n/a", false);
        MetricsInfo.addLabel(secondColumn, "Standard deviation: ", true);
        this.m_stdDeviationValue = MetricsInfo.addLabel(secondColumn, "n/a", false);
        MetricsInfo.addLabel(secondColumn, "Median: ", true);
        this.m_medianValue = MetricsInfo.addLabel(secondColumn, "n/a", false);
        Composite thirdColumn = MetricsInfo.createColumnComposite(this);
        thirdColumn.setLayoutData((Object)new GridData(1, 1, true, false));
        MetricsInfo.addLabel(thirdColumn, "Lower threshold: ", true);
        this.m_lowerThreshold = MetricsInfo.addLabel(thirdColumn, "n/a", false);
        MetricsInfo.addLabel(thirdColumn, "Upper threshold: ", true);
        this.m_upperThreshold = MetricsInfo.addLabel(thirdColumn, "n/a", false);
    }

    private List<Number> getValues(List<IMetricValue> metricValues) {
        if (metricValues == null) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            List nullValues = metricValues.stream().filter(v -> v.getValue() == null).collect(Collectors.toList());
            for (IMetricValue next : nullValues) {
                LOGGER.error("Unexpected null values for metric {}", (Object)next.getMetricDescriptor().getPresentationName());
            }
            assert (nullValues.isEmpty()) : "Detected unexpected null values! Check log file for details!";
        }
        return metricValues.stream().map(v -> v.getValue()).filter(n -> n != null).sorted().collect(Collectors.toList());
    }

    void reset() {
        this.setRedraw(false);
        this.m_values.setText("n/a");
        this.m_minValue.setText("n/a");
        this.m_maxValue.setText("n/a");
        this.m_meanValue.setText("n/a");
        this.m_stdDeviationValue.setText("n/a");
        this.m_medianValue.setText("n/a");
        this.m_lowerThreshold.setText("n/a");
        this.m_upperThreshold.setText("n/a");
        this.getParent().layout(true, true);
        this.setRedraw(true);
    }

    void update(IMetricDescriptor metricDescriptor, List<IMetricValue> metricValues, IThresholdProvider thresholdProvider) {
        this.setRedraw(false);
        this.m_values.setText("n/a");
        this.m_minValue.setText("n/a");
        this.m_maxValue.setText("n/a");
        this.m_meanValue.setText("n/a");
        this.m_stdDeviationValue.setText("n/a");
        this.m_medianValue.setText("n/a");
        this.m_lowerThreshold.setText("n/a");
        this.m_upperThreshold.setText("n/a");
        if (metricDescriptor != null) {
            List<Number> values;
            IMetricThreshold metricThreshold;
            IMetricThreshold iMetricThreshold = metricThreshold = thresholdProvider != null ? thresholdProvider.getThreshold(metricDescriptor) : null;
            if (metricThreshold != null) {
                this.m_lowerThreshold.setText(NumberUtility.format((Number)metricThreshold.getLowerThreshold()));
                this.m_upperThreshold.setText(NumberUtility.format((Number)metricThreshold.getUpperThreshold()));
            }
            if (!(values = this.getValues(metricValues)).isEmpty()) {
                OptionalDouble stdDeviation;
                this.m_values.setText(NumberUtility.format((Number)values.size()));
                this.m_minValue.setText(NumberUtility.format((Number)values.get(0)));
                this.m_maxValue.setText(NumberUtility.format((Number)values.get(values.size() - 1)));
                OptionalDouble mean = SimpleStatistics.average(values);
                if (mean.isPresent()) {
                    this.m_meanValue.setText(NumberUtility.format((Number)mean.getAsDouble()));
                }
                if ((stdDeviation = SimpleStatistics.standardDeviation(values)).isPresent()) {
                    this.m_stdDeviationValue.setText(NumberUtility.format((Number)stdDeviation.getAsDouble()));
                }
                this.m_medianValue.setText(NumberUtility.format((Number)SimpleStatistics.median(values)));
            }
        }
        this.getParent().layout(true, true);
        this.setRedraw(true);
    }
}

