/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.ExportQualityModelCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.ExportQualityModel;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ExportQualityModelDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class ExportQualityModelHandler
extends CommandHandlerWithCorrespondingCommand {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EXPORT_QUALITY_MODEL;
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem)) {
            return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.QUALITY_MODEL_DATA_AVAILABLE});
        }
        return false;
    }

    @Execute
    protected void execute() {
        ExportQualityModelCommand cmd = new ExportQualityModelCommand(WorkbenchRegistry.getInstance().getProvider(), (ExportQualityModelCommand.IInteraction)new Interaction());
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }

    private class Interaction
    extends StandardCommandInteraction
    implements ExportQualityModelCommand.IInteraction {
        private Interaction() {
        }

        public boolean confirm(final ExportQualityModel model) {
            assert (model != null) : "Parameter 'model' of method 'confirm' must not be null";
            RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                public void run() {
                    ExportQualityModelDialog dialog = new ExportQualityModelDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "", model);
                    if (dialog.open() == 0) {
                        model.setFilePath(dialog.getDirectory().getNormalizedPath() + "/" + dialog.getName() + CoreFileType.QUALITY_MODEL.getDefaultExtension());
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
        }

        public boolean confirmOverwrite() {
            return UserInterfaceAdapter.getInstance().question("Do you want to overwrite the existing quality model file?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processExportResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

