/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview.LogicalNamespacesViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview.LogicalNamespacesViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.presentationmodeview.PresentationModeView;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.CreateMoveRenameRefactoringHandler;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;

public final class LogicalNamespacesView
extends PresentationModeView
implements DropTargetAdapter.IDropTargetActionHandler<NamedElement>,
DragSourceAdapter.IDragActionHandler<NamedElement> {
    private static final String KEY = "LogicalNamespacesView.scope";
    private LogicalNamespacesViewContentAndLabelProvider m_contentAndLabelProvider;
    private NamespaceUtility.LogicalProgrammingElementInfo m_logicalProgrammingElementInfo;
    private LogicalNamespacesViewComparator m_comparator;
    private LogicalNamespaceScope m_scope;
    private MoveRenameRefactoringInfo m_moveRenameDragAndDropInfo;
    private List<NamedElement> m_dragSelection;

    public LogicalNamespacesView() {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        String scopeStandardName = eclipsePreferences.get(KEY, LogicalNamespaceScope.MODULE.getStandardName());
        this.m_scope = LogicalNamespaceScope.MODULE.getStandardName().equals(scopeStandardName) ? LogicalNamespaceScope.MODULE : LogicalNamespaceScope.SYSTEM;
    }

    private void setLogicalNamespaceScope(TreeViewer treeViewer, SoftwareSystem softwareSystem) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'setLogicalNamespaceScope' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setLogicalNamespaceScope' must not be null";
        switch (this.m_scope) {
            case MODULE: {
                treeViewer.setInput(softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class));
                break;
            }
            case SYSTEM: {
                treeViewer.setInput(softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class));
                break;
            }
            default: {
                assert (false) : "Unhandled scope: " + String.valueOf(this.m_scope);
                break;
            }
        }
    }

    void setLogicalNamespaceScope(LogicalNamespaceScope scope) {
        assert (scope != null) : "Parameter 'scope' of method 'setLogicalNamespaceScope' must not be null";
        if (this.m_scope != scope) {
            this.m_scope = scope;
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            if (softwareSystem != null) {
                this.removeListeners();
                TreeViewer treeViewer = this.getTreeViewer();
                treeViewer.getTree().setRedraw(false);
                this.setLogicalNamespaceScope(treeViewer, softwareSystem);
                treeViewer.getTree().setRedraw(true);
                this.addListeners();
            }
            this.createAndAddNavigationState(NavigationState.Type.VIEW_OPTIONS_CHANGED);
            IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
            eclipsePreferences.put(KEY, this.m_scope.getStandardName());
            PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
        }
    }

    LogicalNamespaceScope getLogicalNamespaceScope() {
        return this.m_scope;
    }

    protected void createViewContent(Composite viewContentArea) {
        super.createViewContent(viewContentArea);
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter((StructuredViewer)this.getTreeViewer(), this, Collections.singletonList(NamedElement.class), false);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.getTreeViewer(), 2, Collections.singletonList(dropTargetAdapter), Collections.singletonList(NamedElement.class), this);
    }

    @Override
    public boolean validateDrag(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'validateDrag' must not be empty";
        MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isMoveRenameRefactoringPossible(new ArrayList<NamedElement>(elements));
        if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME) && this.getElementInteractor().dragAndDropStarted()) {
            this.m_moveRenameDragAndDropInfo = info;
            this.m_dragSelection = elements;
            return true;
        }
        return false;
    }

    @Override
    public void dragFinished() {
        this.m_moveRenameDragAndDropInfo = null;
        this.m_dragSelection = null;
        this.getElementInteractor().dragAndDropFinished();
    }

    @Override
    public boolean validateDrop(NamedElement target, int operation, TransferData transferType) {
        assert (target != null) : "Parameter 'target' of method 'validateDrop' must not be null";
        if (this.m_moveRenameDragAndDropInfo != null) {
            if (this.m_dragSelection.contains(target)) {
                return false;
            }
            MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isPossibleMoveRefactoringTarget(this.m_moveRenameDragAndDropInfo, (Element)target);
            if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME)) {
                this.m_moveRenameDragAndDropInfo = info;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean perform(NamedElement target, DropLocation location, List<NamedElement> dropped, StructuredViewer viewer) {
        assert (target != null) : "Parameter 'target' of method 'perform' must not be null";
        assert (location != null) : "Parameter 'location' of method 'perform' must not be null";
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'perform' must not be empty";
        if (this.m_moveRenameDragAndDropInfo != null) {
            IIssueProvider issueProvider = (IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class);
            CreateMoveRenameRefactoringHandler.requestUserToPerformMoveRenameRefactoring(issueProvider, this.m_moveRenameDragAndDropInfo);
            this.m_moveRenameDragAndDropInfo = null;
            return true;
        }
        this.m_moveRenameDragAndDropInfo = null;
        return false;
    }

    public IViewId getViewId() {
        return ViewId.LOGICAL_NAMESPACES_VIEW;
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'configureTreeViewer' must not be null";
        this.m_contentAndLabelProvider = new LogicalNamespacesViewContentAndLabelProvider();
        treeViewer.setContentProvider((IContentProvider)this.m_contentAndLabelProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.m_contentAndLabelProvider);
        this.m_comparator = new LogicalNamespacesViewComparator(this.m_contentAndLabelProvider);
        treeViewer.setComparator((ViewerComparator)this.m_comparator);
        treeViewer.setUseHashlookup(true);
        PresentationMode presentationMode = this.getPresentationMode();
        this.m_contentAndLabelProvider.setPresentationMode(presentationMode);
        this.m_comparator.setPresentationMode(presentationMode);
        this.m_contentAndLabelProvider.setViewContentFilters(WorkbenchRegistry.getInstance().getViewContentFilters((IViewId)ViewId.LOGICAL_NAMESPACES_VIEW));
        this.m_comparator.setCategoryProvider(new CategoryProvider(WorkbenchRegistry.getInstance().getViewCategoryProviders((IViewId)ViewId.LOGICAL_NAMESPACES_VIEW)));
    }

    protected Class<?> getParentClassForExpansion() {
        return ILogicalElement.class;
    }

    @Override
    protected void presentationModeChanged() {
        this.m_contentAndLabelProvider.setPresentationMode(this.getPresentationMode());
        this.m_comparator.setPresentationMode(this.getPresentationMode());
    }

    public void softwareSystemShow(WorkbenchView.ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemShow' must not be null";
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.getControl().setRedraw(false);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        this.m_comparator.setSoftwareSystem(softwareSystem);
        this.m_contentAndLabelProvider.setPresentationMode(this.getPresentationMode());
        this.m_comparator.setPresentationMode(this.getPresentationMode());
        this.setLogicalNamespaceScope(treeViewer, softwareSystem);
        treeViewer.getControl().setRedraw(true);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    protected NamedElement getInput(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getInput' must not be null";
        return this.m_scope.equals((Object)LogicalNamespaceScope.SYSTEM) ? (NamedElement)softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class) : (NamedElement)softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class);
    }

    public void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.getTreeViewer().getControl().setRedraw(false);
        this.m_comparator.setSoftwareSystem(null);
        this.getTreeViewer().setInput(null);
        this.getTreeViewer().getControl().setRedraw(true);
        this.m_moveRenameDragAndDropInfo = null;
        this.m_logicalProgrammingElementInfo = null;
    }

    @Override
    protected void collectViewDataForState(Map<IStateData, Object> viewData) {
        assert (viewData != null) : "Parameter 'viewData' of method 'collectViewDataForState' must not be null";
        viewData.put(StateData.SCOPE, this.m_scope);
        super.collectViewDataForState(viewData);
    }

    @Override
    protected void aboutToRestoreNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'aboutToRestoreNavigationState' must not be null";
        LogicalNamespaceScope scopeFromState = (LogicalNamespaceScope)state.getConstant((IStateData)StateData.SCOPE);
        assert (scopeFromState != null) : "Parameter 'scopeFromState' of method 'aboutToRestoreNavigationState' must not be null";
        if (!this.m_scope.equals((Object)scopeFromState)) {
            this.m_scope = scopeFromState;
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            if (softwareSystem != null) {
                this.setLogicalNamespaceScope(this.getTreeViewer(), this.getSoftwareSystem());
            }
        }
        super.aboutToRestoreNavigationState(state);
    }

    protected void aboutToSelectAndReveal(StructuredSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'aboutToSelectAndReveal' must not be null";
        if (selection.size() == 1) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.getTree().setRedraw(false);
            Object selected = selection.getFirstElement();
            if (selected instanceof LogicalProgrammingElement && this.m_logicalProgrammingElementInfo != null) {
                for (LogicalProgrammingElement next : this.m_logicalProgrammingElementInfo.getLogicalProgrammingElementsPath()) {
                    treeViewer.reveal((Object)next.getParent());
                }
            } else {
                if (selected instanceof LogicalProgrammingElement || selected instanceof LogicalNamespace || selected instanceof LogicalNamespaceRoot) {
                    NamedElement namedElement = (NamedElement)selected;
                    LogicalNamespaceRoot logicalNamespaceRoot = (LogicalNamespaceRoot)namedElement.getParent(LogicalNamespaceRoot.class, ParentMode.SELF_OR_FIRST_PARENT);
                    assert (logicalNamespaceRoot != null) : "'logicalNamespaceRoot' of method 'aboutToSelectAndReveal' must not be null";
                    if (!this.m_scope.equals((Object)logicalNamespaceRoot.getScope())) {
                        SoftwareSystem softwareSystem = this.getSoftwareSystem();
                        assert (softwareSystem != null) : "'softwareSystem' of method 'aboutToSelectAndReveal' must not be null";
                        this.m_scope = logicalNamespaceRoot.getScope();
                        this.setLogicalNamespaceScope(treeViewer, softwareSystem);
                    }
                }
                if (selected instanceof LogicalProgrammingElement) {
                    LogicalProgrammingElement logicalProgrammingElement = (LogicalProgrammingElement)selected;
                    NamespaceUtility.LogicalProgrammingElementInfo logicalProgrammingElementInfo = NamespaceUtility.getLogicalProgrammingElementInfo((ProgrammingElement)logicalProgrammingElement.getPrimaryProgrammingElement(), (boolean)this.m_scope.equals((Object)LogicalNamespaceScope.SYSTEM));
                    assert (logicalProgrammingElementInfo != null);
                    for (LogicalProgrammingElement next : logicalProgrammingElementInfo.getLogicalProgrammingElementsPath()) {
                        if (!next.isValid()) continue;
                        treeViewer.reveal((Object)next.getParent());
                    }
                }
            }
            treeViewer.getTree().setRedraw(true);
        }
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        if (elements.size() == 1 && elements.get(0) instanceof ProgrammingElement) {
            ProgrammingElement programmingElement = (ProgrammingElement)elements.get(0);
            this.m_logicalProgrammingElementInfo = NamespaceUtility.getLogicalProgrammingElementInfo((ProgrammingElement)programmingElement, (boolean)this.m_scope.equals((Object)LogicalNamespaceScope.SYSTEM));
            if (this.m_logicalProgrammingElementInfo != null) {
                super.selectAndReveal(new StructuredSelection((Object)this.m_logicalProgrammingElementInfo.getLeafLogicalProgrammingElement()));
                this.m_logicalProgrammingElementInfo = null;
                WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
                return;
            }
        }
        super.finishShowInView(sourceViewId, elements, options);
    }

    static enum StateData implements IStateData
    {
        SCOPE;

    }
}

