/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.issuesview;

import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

public final class IssueBeanAdapter
extends BeanPropertyReader.BeanAdapter<Issue> {
    private Issue m_issue;

    protected final void setAdaptedObject(Issue issue) {
        this.m_issue = issue;
    }

    private Issue getIssue() {
        assert (this.m_issue != null) : "'m_issue' of method 'getIssue' must not be null";
        return this.m_issue;
    }

    private static ElementWithIssues getAffectedElement(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getAffectedElement' must not be null";
        Element affectedElement = issue.getAffectedElement();
        assert (affectedElement instanceof ElementWithIssues) : "Unexpected class: " + affectedElement.getClass().getName();
        return (ElementWithIssues)affectedElement;
    }

    private static Dependency getAffectedDependency(Issue issue) {
        ElementWithIssues affectedElement = IssueBeanAdapter.getAffectedElement(issue);
        assert (affectedElement instanceof Dependency) : "Unexpected class: " + affectedElement.getClass().getName();
        return (Dependency)affectedElement;
    }

    public String getIssueName() {
        return IssueBeanAdapter.getIssueName(this.m_issue);
    }

    public static String getIssueName(Issue issue) {
        assert (issue != null) : "'issue' of method 'getName' must not be null";
        return issue.getName();
    }

    public Image getIssueImage() {
        return IssueBeanAdapter.getIssueImage(this.getIssue());
    }

    public static Image getIssueImage(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getIssueImage' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return UiResourceManager.getInstance().getImage("ElementIssue");
        }
        if (issue instanceof DependencyIssue) {
            return UiResourceManager.getInstance().getImage("DependencyIssue");
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    public String getSeverity() {
        return IssueBeanAdapter.getSeverity(this.m_issue);
    }

    public static String getSeverity(Issue issue) {
        assert (issue != null) : "'issue' of method 'getSeverity' must not be null";
        return issue.getSeverity().getPresentationName();
    }

    public int getSeveritySort() {
        assert (this.m_issue != null) : "'m_issue' of method 'getSeveritySort' must not be null";
        return this.m_issue.getSeverity().ordinal();
    }

    public Image getSeverityImage() {
        return IssueBeanAdapter.getSeverityImage(this.m_issue);
    }

    public static Image getImage(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'getImage' must not be null";
        switch (severity) {
            case INFO: {
                return UiResourceManager.getInstance().getImage("Info");
            }
            case WARNING: {
                return UiResourceManager.getInstance().getImage("Warning");
            }
            case ERROR: {
                return UiResourceManager.getInstance().getImage("Error");
            }
            case NONE: {
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        assert (false) : "Unhandled severity: " + String.valueOf(severity);
        return null;
    }

    public static Image getSeverityImage(Issue issue) {
        assert (issue != null) : "'issue' of method 'getSeverityImage' must not be null";
        return IssueBeanAdapter.getImage(issue.getSeverity());
    }

    public String getCategoryName() {
        return IssueBeanAdapter.getCategoryName(this.m_issue);
    }

    public static String getCategoryName(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getCategoryName' must not be null";
        return issue.getId().getCategory().getPresentationName();
    }

    public String getIssueProviderName() {
        return IssueBeanAdapter.getIssueProviderName(this.m_issue);
    }

    public static String getIssueProviderName(Issue issue) {
        assert (issue != null) : "'issue' of method 'getIssueProviderName' must not be null";
        return issue.getProvider().getPresentationName();
    }

    public static String getElementOrFrom(Issue issue, boolean shortName) {
        assert (issue != null) : "Parameter 'issue' of method 'getElementOrFrom' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return IssueBeanAdapter.getAffectedElement(issue).getPresentationName(shortName);
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = IssueBeanAdapter.getAffectedDependency(issue);
            return dependency.getUnderlyingFrom().getPresentationName(shortName);
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    public String getElementOrFrom() {
        return IssueBeanAdapter.getElementOrFrom(this.m_issue, true);
    }

    public String getElementOrFromTooltip() {
        return IssueBeanAdapter.getElementOrFrom(this.m_issue, false);
    }

    public static String getElementOrFromTooltip(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getElementOrFromTooltip' must not be null";
        return IssueBeanAdapter.getElementOrFrom(issue, false);
    }

    public Image getElementOrFromImage() {
        return IssueBeanAdapter.getElementOrFromImage(this.m_issue);
    }

    public static Image getElementOrFromImage(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getElementOrFromImage' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return UiResourceManager.getInstance().getImage((Element)IssueBeanAdapter.getAffectedElement(issue));
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = IssueBeanAdapter.getAffectedDependency(issue);
            return UiResourceManager.getInstance().getImage((Element)dependency.getUnderlyingFrom());
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    private static String getTo(boolean shortName, Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getTo' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return "n/a";
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = IssueBeanAdapter.getAffectedDependency(issue);
            return dependency.getUnderlyingTo().getPresentationName(shortName);
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    public String getTo() {
        return IssueBeanAdapter.getTo(true, this.getIssue());
    }

    public static String getTo(Issue issue) {
        return IssueBeanAdapter.getTo(true, issue);
    }

    public String getToTooltip() {
        return IssueBeanAdapter.getTo(false, this.getIssue());
    }

    public static String getToTooltip(Issue issue) {
        return IssueBeanAdapter.getTo(false, issue);
    }

    public static Image getToImage(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getToImage' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        if (issue instanceof NamedElementIssue) {
            return null;
        }
        if (issue instanceof DependencyIssue) {
            Dependency dependency = IssueBeanAdapter.getAffectedDependency(issue);
            return UiResourceManager.getInstance().getImage((Element)dependency.getUnderlyingTo());
        }
        assert (false) : "Unexpected class: " + issue.getClass().getName();
        return null;
    }

    public Image getToImage() {
        return IssueBeanAdapter.getToImage(this.getIssue());
    }

    public String getDescription() {
        return IssueBeanAdapter.getDescription(this.m_issue);
    }

    public static String getDescription(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getDescription' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        return issue.getDescription();
    }
}

