/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.help;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpContext;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public final class DynamicHelpView
extends WorkbenchAuxiliaryView {
    private List<Object> m_currentObjects;
    private StyledText m_content;

    public IViewId getViewId() {
        return ViewId.DYNAMIC_HELP_VIEW;
    }

    protected boolean supportsSleep() {
        return false;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_content = new StyledText(viewContentArea, 72);
        this.m_content.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        HelpRegistry.getInstance().setContextHelpText(Arrays.asList(HelpRegistry.getInstance().getDefaultHelpContext()), this.m_content);
        this.initialize();
    }

    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        IViewId viewId = view.getViewId();
        return !viewId.equals(ViewId.DYNAMIC_HELP_VIEW);
    }

    protected void performViewSelected(IWorkbenchView view) {
        if (view != null && view != this) {
            HelpRegistry.getInstance().register((Object)view, view.getHelpContextId());
            super.performViewSelected(view);
        }
    }

    protected void initialize() {
        WorkbenchView connectedToView = this.getConnectedView();
        if (connectedToView == null) {
            connectedToView = WorkbenchRegistry.getInstance().getCurrentlySelectedView();
        }
        if (connectedToView != null) {
            HelpRegistry.getInstance().register((Object)connectedToView, connectedToView.getHelpContextId());
        }
        super.initialize();
    }

    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        if (this.m_content != null && !this.m_content.isDisposed()) {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(connectedView);
            objects.addAll(elements);
            if (objects.equals(this.m_currentObjects)) {
                return;
            }
            this.m_currentObjects = objects;
            HelpRegistry helpRegistry = HelpRegistry.getInstance();
            ArrayList<HelpContext> contexts = new ArrayList<HelpContext>(objects.size());
            for (Object e : objects) {
                HelpContext context = helpRegistry.getContext(e);
                if (context == null) continue;
                contexts.add(context);
            }
            helpRegistry.setContextHelpText(contexts.isEmpty() ? Arrays.asList(helpRegistry.getDefaultHelpContext()) : contexts, this.m_content);
        }
        super.handleSelection(connectedView, elements);
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }
}

