/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

final class TreeViewerDeltaChangeFilter
extends ViewerFilter {
    private final IDiffElement.Change m_changeToHide;
    private int m_numberOfFiltered = 0;
    private int m_numberOfShownRoots = 0;
    private final Class<?> m_filterClass;

    public TreeViewerDeltaChangeFilter(IDiffElement.Change changeToHide) {
        assert (changeToHide != null) : "Parameter 'changeToHide' of method 'TreeViewerDeltaChangeFilter' must not be null";
        this.m_changeToHide = changeToHide;
        this.m_filterClass = null;
    }

    public TreeViewerDeltaChangeFilter(IDiffElement.Change changeToHide, Class<?> filterClass) {
        assert (changeToHide != null) : "Parameter 'changeToHide' of method 'TreeViewerDeltaChangeFilter' must not be null";
        assert (filterClass != null) : "Parameter 'filterClass' of method 'TreeViewerDeltaChangeFilter' must not be null";
        this.m_changeToHide = changeToHide;
        this.m_filterClass = filterClass;
    }

    public IDiffElement.Change getChangeToHide() {
        return this.m_changeToHide;
    }

    public int getNumberOfFiltered() {
        return this.m_numberOfFiltered;
    }

    public int getNumberOfShownRoots() {
        return this.m_numberOfShownRoots;
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        return super.filter(viewer, parentPath, elements);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean show;
        assert (element != null && element instanceof IDiffElement) : "Unexpected class in method 'select': " + String.valueOf(element);
        if (this.m_filterClass != null && !this.m_filterClass.isAssignableFrom(element.getClass())) {
            return true;
        }
        IDiffElement delta = (IDiffElement)element;
        boolean bl = show = delta.getChange() != this.m_changeToHide;
        if (!show) {
            ++this.m_numberOfFiltered;
        } else {
            ++this.m_numberOfShownRoots;
        }
        return show;
    }
}

