/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerExecutionLevelChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.IgnoreDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.RefactoringDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ModuleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.RootDirectoryDiff;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.diffview.CycleDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffTabFolderViewOptions;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffViewDoubleClickSupport;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffViewTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffViewUtility;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DuplicateDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IgnoreDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.IssueDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.MetricValueDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.RefactoringDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewComponent;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewConfiguration;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewElementGroup;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewHeader;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemDiffViewStateData;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SystemInfoDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.TaskDiffTab;
import com.hello2morrow.sonargraph.ui.standalone.diffview.WorkspaceDiffTab;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public final class SystemDiffView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
SelectionListener {
    private final List<DiffViewTab<?, ?>> m_diffViewTabs = new ArrayList(9);
    private SystemDiffViewHeader m_header;
    private Label m_status;
    private CTabFolder m_tabFolder;
    private SystemDiffViewConfiguration m_configuration;
    private DiffViewTab<Tree, TreeViewer> m_systemInfoTab;
    private DiffViewTab<Table, TableViewer> m_metricTab;
    private DiffViewTab<Tree, TreeViewer> m_workspaceTab;
    private DiffViewTab<Table, TableViewer> m_issuesTab;
    private DiffViewTab<Table, TableViewer> m_ignoresTab;
    private DiffViewTab<Table, TableViewer> m_tasksTab;
    private DiffViewTab<Table, TableViewer> m_refactoringsTab;
    private DiffViewTab<Tree, TreeViewer> m_cyclesTab;
    private DiffViewTab<Tree, TreeViewer> m_duplicatesTab;
    private SystemDiffViewComponent m_selectedViewComponent = SystemDiffViewComponent.CONFIGURATION;
    private BaseTextSearchHandler m_textSearchHandler;
    private DiffTabFolderViewOptions m_previousViewOptions;
    private boolean m_analyzersRunning;

    public IViewId getViewId() {
        return ViewId.SYSTEM_DIFF_VIEW;
    }

    private void updateStatus(SoftwareSystem softwareSystem) {
        Object text = "";
        String tooltip = null;
        if (softwareSystem != null) {
            ISystemDiffProvider diffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
            SystemDiffConfiguration diffConfiguration = diffProvider.getSystemDiffConfiguration();
            BaselineType baselineType = diffConfiguration.getBaselineType();
            if (baselineType != null) {
                text = baselineType.getPresentationName() + " baseline active. ";
                boolean executesOnCurrentLevel = diffProvider.executesOnCurrentAnalyzerExecutionLevel();
                boolean systemIsClearable = softwareSystem.isClearable();
                if (executesOnCurrentLevel && systemIsClearable) {
                    if (this.m_analyzersRunning) {
                        text = (String)text + "Waiting for analyzers to complete...";
                    } else {
                        List issues = diffProvider.getSystemDiffComputationErrorIssues();
                        if (!issues.isEmpty()) {
                            tooltip = issues.stream().map(i -> i.getDescription()).collect(Collectors.joining(",\n"));
                            text = (String)text + "Failed to compute system diff!";
                        } else {
                            SoftwareSystemDiff systemDiff = diffProvider.getSoftwareSystemDiff();
                            if (systemDiff != null) {
                                text = (String)text + "System diff computed on " + Iso8601DateFormat.formatDateAndTime((Date)new Date(systemDiff.getTimeStampOfDeltaCreation())) + ".";
                            }
                        }
                    }
                } else {
                    if (!systemIsClearable) {
                        text = (String)text + "System is empty" + (executesOnCurrentLevel ? "." : " and ");
                    }
                    if (!executesOnCurrentLevel) {
                        String info = "System diff analyzer is only executed for analyzer execution level '" + CoreAnalyzerId.SYSTEM_DIFF.getExecutionLevel().getPresentationName() + "'.";
                        text = (String)text + (String)(!systemIsClearable ? StringUtility.firstCharacterCase((String)info, (boolean)true) : info);
                    }
                }
            } else {
                text = "Inactive.";
            }
        } else {
            text = "n/a";
        }
        this.m_status.setText((String)text);
        this.m_status.setToolTipText(tooltip);
    }

    private void addDiffViewTabListeners() {
        this.m_diffViewTabs.forEach(tab -> tab.getViewer().addSelectionChangedListener((ISelectionChangedListener)this));
    }

    private void removeDiffViewTabListeners() {
        this.m_diffViewTabs.forEach(tab -> tab.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this));
    }

    private void clearDiffViewTabs() {
        this.removeDiffViewTabListeners();
        this.m_diffViewTabs.forEach(tab -> tab.clear());
        this.addDiffViewTabListeners();
    }

    private void handleAnalyzerExecutionLevelChanged() {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        this.updateStatus(softwareSystem);
        if (softwareSystem != null) {
            this.m_header.show(softwareSystem);
            this.m_configuration.show(softwareSystem);
        }
    }

    private void handleAnalyzersStarted() {
        this.m_analyzersRunning = true;
        this.updateStatus(this.getSoftwareSystem());
    }

    private void handleAnalyzersFinished() {
        this.m_analyzersRunning = false;
        this.updateStatus(this.getSoftwareSystem());
    }

    private void handleSystemDiffResultCleared() {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'handleSystemDiffResultCleared' must not be null";
        this.clearDiffViewTabs();
    }

    private void handleSystemDiffResultAvaliable(SoftwareSystemDiff systemDiff) {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        this.m_analyzersRunning = false;
        this.updateStatus(softwareSystem);
        this.m_header.show(softwareSystem);
        this.m_configuration.show(softwareSystem);
        List issues = ((ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class)).getSystemDiffComputationErrorIssues();
        if (!issues.isEmpty() || systemDiff == null) {
            this.clearDiffViewTabs();
        } else {
            this.removeDiffViewTabListeners();
            this.m_diffViewTabs.forEach(tab -> tab.show(systemDiff));
            this.addDiffViewTabListeners();
        }
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemShow' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        SoftwareSystemDiff systemDiff = ((ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class)).getSoftwareSystemDiff();
        if (systemDiff == null && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.CALCULATING})) {
            this.m_analyzersRunning = true;
            this.updateStatus(softwareSystem);
            this.m_header.show(softwareSystem);
            this.m_configuration.show(softwareSystem);
        } else {
            this.handleSystemDiffResultAvaliable(systemDiff);
        }
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.BASELINE_MODIFIED)) {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            this.updateStatus(softwareSystem);
            this.m_header.show(softwareSystem);
            this.m_configuration.show(softwareSystem);
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemHide' must not be null";
        this.m_configuration.clear();
        this.m_header.clear();
        this.clearDiffViewTabs();
        this.m_status.setText("");
        this.m_status.setToolTipText(null);
        this.m_analyzersRunning = false;
        super.softwareSystemHide(mode);
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        this.addStateInfo(state, null, null);
    }

    public Search supportsSearch() {
        return this.getSelectedDiffTab() != null ? Search.FIND_TEXT : Search.NONE;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        Composite content = new Composite(viewContentArea, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_header = new SystemDiffViewHeader(content);
        this.m_header.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        Label statusTextLabel = new Label(content, 0);
        statusTextLabel.setFont(UiResourceManager.getInstance().getFont(1));
        statusTextLabel.setText("Status:");
        statusTextLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_status = new Label(content, 0);
        this.m_status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_status.setText("n/a");
        this.m_tabFolder = SwtUtility.createTabFolder((Composite)content);
        this.m_tabFolder.setBackground(content.getBackground());
        this.m_tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_configuration = new SystemDiffViewConfiguration(this.m_tabFolder);
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (IDialogId)this.getViewId());
        this.m_systemInfoTab = new SystemInfoDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_systemInfoTab);
        this.m_metricTab = new MetricValueDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_metricTab);
        this.m_workspaceTab = new WorkspaceDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_workspaceTab);
        this.m_issuesTab = new IssueDiffTab(this.m_tabFolder, preferences);
        this.m_diffViewTabs.add(this.m_issuesTab);
        this.m_ignoresTab = new IgnoreDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_ignoresTab);
        this.m_tasksTab = new TaskDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_tasksTab);
        this.m_refactoringsTab = new RefactoringDiffTab(this.m_tabFolder);
        this.m_diffViewTabs.add(this.m_refactoringsTab);
        this.m_cyclesTab = new CycleDiffTab(this.m_tabFolder, preferences);
        this.m_diffViewTabs.add(this.m_cyclesTab);
        this.m_duplicatesTab = new DuplicateDiffTab(this.m_tabFolder, preferences);
        this.m_diffViewTabs.add(this.m_duplicatesTab);
        this.m_tabFolder.setSelection(this.m_configuration.getTabItem());
        this.m_textSearchHandler = this.m_systemInfoTab.createTextSearchHandler(this.getViewId().getPresentationName());
        this.m_tabFolder.addSelectionListener((SelectionListener)this);
        this.m_tabFolder.setTopRight(null);
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (SystemDiffView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SystemDiffView.this.handleAnalyzersStarted();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (SystemDiffView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SystemDiffView.this.handleAnalyzersFinished();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult analyzerResult;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (SystemDiffView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (analyzerResult = event.getResult()).getId() == CoreAnalyzerId.SYSTEM_DIFF) {
                    SystemDiffView.this.handleSystemDiffResultAvaliable((SoftwareSystemDiff)analyzerResult.getUniqueChild(SoftwareSystemDiff.class));
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (SystemDiffView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.contains((IAnalyzerId)CoreAnalyzerId.SYSTEM_DIFF)) {
                    SystemDiffView.this.handleSystemDiffResultCleared();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerExecutionLevelChangedEvent>(AnalyzerExecutionLevelChangedEvent.class, (Object)this){

            public void handleEvent(AnalyzerExecutionLevelChangedEvent event) {
                if (SystemDiffView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SystemDiffView.this.handleAnalyzerExecutionLevelChanged();
                }
            }
        });
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerExecutionLevelChangedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public List<Element> getSelectedElements() {
        DiffViewTab<?, ?> selectedTab = this.getSelectedDiffTab();
        IStructuredSelection selection = selectedTab != null ? selectedTab.getSelection() : null;
        ArrayList<Element> selectedElements = new ArrayList<Element>();
        if (selection != null) {
            for (Object next : selection.toList()) {
                assert (next instanceof IDiffElement) : "Wrong class: " + next.getClass().getCanonicalName();
                selectedElements.add((Element)((NamedElement)next).getElement());
            }
            return selectedElements;
        }
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        return softwareSystem != null ? Collections.singletonList(softwareSystem) : Collections.emptyList();
    }

    private DiffViewTab<?, ?> getSelectedDiffTab() {
        switch (this.m_selectedViewComponent) {
            case SYSTEM_INFO: {
                return this.m_systemInfoTab;
            }
            case METRICS: {
                return this.m_metricTab;
            }
            case WORKSPACE: {
                return this.m_workspaceTab;
            }
            case ISSUES: {
                return this.m_issuesTab;
            }
            case IGNORE: {
                return this.m_ignoresTab;
            }
            case TASK: {
                return this.m_tasksTab;
            }
            case REFACTORING: {
                return this.m_refactoringsTab;
            }
            case CYCLES: {
                return this.m_cyclesTab;
            }
            case DUPLICATES: {
                return this.m_duplicatesTab;
            }
        }
        return null;
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedViewComponent) {
            case CONFIGURATION: {
                return this.m_configuration.getControl();
            }
            case SYSTEM_INFO: {
                return this.m_systemInfoTab.getControl();
            }
            case METRICS: {
                return this.m_metricTab.getControl();
            }
            case WORKSPACE: {
                return this.m_workspaceTab.getControl();
            }
            case ISSUES: {
                return this.m_issuesTab.getControl();
            }
            case IGNORE: {
                return this.m_ignoresTab.getControl();
            }
            case TASK: {
                return this.m_tasksTab.getControl();
            }
            case REFACTORING: {
                return this.m_refactoringsTab.getControl();
            }
            case CYCLES: {
                return this.m_cyclesTab.getControl();
            }
            case DUPLICATES: {
                return this.m_duplicatesTab.getControl();
            }
        }
        assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    public List<Control> getControlsForInteraction() {
        ArrayList<Control> controls = new ArrayList<Control>(this.m_diffViewTabs.stream().map(tab -> tab.getControl()).collect(Collectors.toList()));
        controls.add((Control)this.m_configuration);
        return controls;
    }

    public List<Control> getViewComponents() {
        return this.getControlsForInteraction();
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_configuration.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.CONFIGURATION;
        } else if (component == this.m_systemInfoTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.SYSTEM_INFO;
        } else if (component == this.m_metricTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.METRICS;
        } else if (component == this.m_workspaceTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.WORKSPACE;
        } else if (component == this.m_issuesTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.ISSUES;
        } else if (component == this.m_ignoresTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.IGNORE;
        } else if (component == this.m_tasksTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.TASK;
        } else if (component == this.m_refactoringsTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.REFACTORING;
        } else if (component == this.m_cyclesTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.CYCLES;
        } else if (component == this.m_duplicatesTab.getControl()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.DUPLICATES;
        }
    }

    public boolean doubleClicked(Element doubleClickedElement) {
        return DiffViewDoubleClickSupport.handleDoubleClick(doubleClickedElement, this.getSoftwareSystem(), this.getInstallation());
    }

    public NamedElement getLinkNamedElement(Element element) {
        return DiffViewUtility.getLinkNamedElement(element);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeDiffViewTabListeners();
        Object source = event.getSource();
        assert (source != null) : "Parameter 'source' of method 'selectionChanged' must not be null";
        String viewPresentationName = this.getViewId().getPresentationName();
        if (source == this.m_systemInfoTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.SYSTEM_INFO;
            this.m_textSearchHandler = this.m_systemInfoTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_metricTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.METRICS;
            this.m_textSearchHandler = this.m_metricTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_workspaceTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.WORKSPACE;
            this.m_textSearchHandler = this.m_workspaceTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_issuesTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.ISSUES;
            this.m_textSearchHandler = this.m_issuesTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_cyclesTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.CYCLES;
            this.m_textSearchHandler = this.m_cyclesTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_ignoresTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.IGNORE;
            this.m_textSearchHandler = this.m_ignoresTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_tasksTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.TASK;
            this.m_textSearchHandler = this.m_tasksTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_refactoringsTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.REFACTORING;
            this.m_textSearchHandler = this.m_refactoringsTab.createTextSearchHandler(viewPresentationName);
        } else if (source == this.m_duplicatesTab.getViewer()) {
            this.m_selectedViewComponent = SystemDiffViewComponent.DUPLICATES;
            this.m_textSearchHandler = this.m_duplicatesTab.createTextSearchHandler(viewPresentationName);
        } else assert (false) : "Unhandled source: " + source.getClass().getName();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.addStateInfo(state, null, null);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.initializeTextSearchData();
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)event.getSelection());
        this.addDiffViewTabListeners();
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        DiffViewTab<?, ?> selectedTab = this.getSelectedDiffTab();
        if (selectedTab != null && selectedTab.getControl() == control) {
            selectedTab.clearSelection();
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.getContentArea().setRedraw(false);
        this.removeDiffViewTabListeners();
        this.restoreState(state);
        this.addDiffViewTabListeners();
        this.getContentArea().setRedraw(true);
    }

    private void restoreState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.m_selectedViewComponent = (SystemDiffViewComponent)state.getConstant((IStateData)SystemDiffViewStateData.SELECTED_VIEW_COMPONENT);
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'restoreNavigationState' must not be null";
        switch (this.m_selectedViewComponent) {
            case CONFIGURATION: {
                this.m_tabFolder.setSelection(this.m_configuration.getTabItem());
                break;
            }
            case SYSTEM_INFO: {
                this.m_tabFolder.setSelection(this.m_systemInfoTab.getTabItem());
                TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_systemInfoTab.getViewer(), (NavigationState)state, (IElementResolver)this.getElementResolver());
                break;
            }
            case METRICS: {
                this.m_tabFolder.setSelection(this.m_metricTab.getTabItem());
                StructuredSelection selectionMetric = new StructuredSelection(state.getElements((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, MetricValueDiff.class, this.getElementResolver()).toArray());
                this.m_metricTab.getViewer().setSelection((ISelection)selectionMetric);
                break;
            }
            case WORKSPACE: {
                this.m_tabFolder.setSelection(this.m_workspaceTab.getTabItem());
                TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_workspaceTab.getViewer(), (NavigationState)state, (IElementResolver)this.getElementResolver());
                break;
            }
            case ISSUES: {
                this.m_tabFolder.setSelection(this.m_issuesTab.getTabItem());
                StructuredSelection selection = new StructuredSelection(state.getElements((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, NamedElement.class, this.getElementResolver()).toArray());
                this.m_issuesTab.getViewer().setSelection((ISelection)selection);
                break;
            }
            case IGNORE: {
                this.m_tabFolder.setSelection(this.m_ignoresTab.getTabItem());
                StructuredSelection selectionIgnore = new StructuredSelection(state.getElements((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, IgnoreDefinitionDiff.class, this.getElementResolver()).toArray());
                this.m_ignoresTab.getViewer().setSelection((ISelection)selectionIgnore);
                break;
            }
            case TASK: {
                this.m_tabFolder.setSelection(this.m_tasksTab.getTabItem());
                StructuredSelection selectionTask = new StructuredSelection(state.getElements((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, TaskDefinitionDiff.class, this.getElementResolver()).toArray());
                this.m_tasksTab.getViewer().setSelection((ISelection)selectionTask);
                break;
            }
            case REFACTORING: {
                this.m_tabFolder.setSelection(this.m_refactoringsTab.getTabItem());
                StructuredSelection selectionRefactoring = new StructuredSelection(state.getElements((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, RefactoringDefinitionDiff.class, this.getElementResolver()).toArray());
                this.m_refactoringsTab.getViewer().setSelection((ISelection)selectionRefactoring);
                break;
            }
            case CYCLES: {
                this.m_tabFolder.setSelection(this.m_cyclesTab.getTabItem());
                TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_cyclesTab.getViewer(), (NavigationState)state, (IElementResolver)this.getElementResolver());
                break;
            }
            case DUPLICATES: {
                this.m_tabFolder.setSelection(this.m_duplicatesTab.getTabItem());
                TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_duplicatesTab.getViewer(), (NavigationState)state, (IElementResolver)this.getElementResolver());
                break;
            }
        }
    }

    private void addStateInfo(NavigationState state, TreeExpansionEvent event, TreeBasedViewNavigationStateUtility.TreeOperation operation) {
        assert (state != null) : "Parameter 'state' of method 'addStateInfo' must not be null";
        switch (this.m_selectedViewComponent) {
            case CONFIGURATION: {
                break;
            }
            case SYSTEM_INFO: {
                HashMap stateData = new HashMap(1);
                TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_systemInfoTab.getViewer(), (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, stateData);
                break;
            }
            case METRICS: {
                List metricToAdd = this.getSelectedElements().stream().filter(e -> e instanceof MetricValueDiff).map(e -> (MetricValueDiff)e).collect(Collectors.toList());
                Set metricDescriptors = NavigationState.getDescriptors(metricToAdd, (IElementResolver)this.getElementResolver());
                state.addElementsInformation((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, metricDescriptors);
                break;
            }
            case WORKSPACE: {
                HashMap workspaceStateData = new HashMap(1);
                TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_workspaceTab.getViewer(), (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, workspaceStateData);
                break;
            }
            case ISSUES: {
                List issuesToAdd = this.getSelectedElements().stream().filter(e -> e instanceof NamedElement).map(e -> (NamedElement)e).collect(Collectors.toList());
                Set issueDescriptors = NavigationState.getDescriptors(issuesToAdd, (IElementResolver)this.getElementResolver());
                state.addElementsInformation((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, issueDescriptors);
                break;
            }
            case IGNORE: {
                List ignoreToAdd = this.getSelectedElements().stream().filter(e -> e instanceof IgnoreDefinitionDiff).map(e -> (IgnoreDefinitionDiff)e).collect(Collectors.toList());
                Set ignoreDescriptors = NavigationState.getDescriptors(ignoreToAdd, (IElementResolver)this.getElementResolver());
                state.addElementsInformation((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, ignoreDescriptors);
                break;
            }
            case TASK: {
                List taskToAdd = this.getSelectedElements().stream().filter(e -> e instanceof TaskDefinitionDiff).map(e -> (TaskDefinitionDiff)e).collect(Collectors.toList());
                Set taskDescriptors = NavigationState.getDescriptors(taskToAdd, (IElementResolver)this.getElementResolver());
                state.addElementsInformation((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, taskDescriptors);
                break;
            }
            case REFACTORING: {
                List refactoringToAdd = this.getSelectedElements().stream().filter(e -> e instanceof RefactoringDefinitionDiff).map(e -> (RefactoringDefinitionDiff)e).collect(Collectors.toList());
                Set refactoringDescriptors = NavigationState.getDescriptors(refactoringToAdd, (IElementResolver)this.getElementResolver());
                state.addElementsInformation((IElementGroup)SystemDiffViewElementGroup.TABLE_SELECTION, refactoringDescriptors);
                break;
            }
            case CYCLES: {
                HashMap cycleStateData = new HashMap(1);
                TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_cyclesTab.getViewer(), (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, cycleStateData);
                break;
            }
            case DUPLICATES: {
                HashMap duplicateStateData = new HashMap(1);
                TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getElementResolver(), (TreeViewer)this.m_duplicatesTab.getViewer(), (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)operation, duplicateStateData);
                break;
            }
        }
        state.addConstant((IStateData)SystemDiffViewStateData.SELECTED_VIEW_COMPONENT, (Enum)this.m_selectedViewComponent);
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        if (event.getSource() == this.m_tabFolder) {
            CTabItem selectedTab = this.m_tabFolder.getSelection();
            Optional<DiffViewTab> tabOptional = this.m_diffViewTabs.stream().filter(tab -> tab.getTabItem() == selectedTab).findFirst();
            if (this.m_previousViewOptions != null) {
                this.m_previousViewOptions.dispose();
                this.m_previousViewOptions = null;
            }
            if (tabOptional.isPresent()) {
                DiffViewTab tab2 = tabOptional.get();
                DiffTabFolderViewOptions viewOptions = tab2.getViewOptions();
                if (viewOptions != null) {
                    Control menu = viewOptions.createControl((Composite)this.m_tabFolder, tab2.getTitle());
                    this.m_tabFolder.setTopRight(menu, 131072);
                } else {
                    this.m_tabFolder.setTopRight(null);
                }
                this.m_previousViewOptions = viewOptions;
                String viewPresentationName = this.getViewId().getPresentationName();
                if (selectedTab == this.m_systemInfoTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.SYSTEM_INFO;
                    this.m_textSearchHandler = this.m_systemInfoTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_metricTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.METRICS;
                    this.m_textSearchHandler = this.m_metricTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_workspaceTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.WORKSPACE;
                    this.m_textSearchHandler = this.m_workspaceTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_issuesTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.ISSUES;
                    this.m_textSearchHandler = this.m_issuesTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_cyclesTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.CYCLES;
                    this.m_textSearchHandler = this.m_cyclesTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_ignoresTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.IGNORE;
                    this.m_textSearchHandler = this.m_ignoresTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_tasksTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.TASK;
                    this.m_textSearchHandler = this.m_tasksTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_refactoringsTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.REFACTORING;
                    this.m_textSearchHandler = this.m_refactoringsTab.createTextSearchHandler(viewPresentationName);
                } else if (selectedTab == this.m_duplicatesTab.getTabItem()) {
                    this.m_selectedViewComponent = SystemDiffViewComponent.DUPLICATES;
                    this.m_textSearchHandler = this.m_duplicatesTab.createTextSearchHandler(viewPresentationName);
                } else assert (false) : "Unhandled tab item: " + selectedTab.getText();
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
                this.addStateInfo(state, null, null);
                ViewNavigationManager.getInstance().addNavigationState(state);
                this.initializeTextSearchData();
                DiffViewTab<?, ?> diffTab = this.getSelectedDiffTab();
                if (diffTab != null) {
                    IStructuredSelection selection = diffTab.getSelection();
                    if (selection == null) {
                        selection = new StructuredSelection((Object)diffTab.getControl());
                    }
                    this.getSelectionProviderAdapter().handleSelectionChanged(selection);
                }
            } else if (selectedTab == this.m_configuration.getTabItem()) {
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
                this.addStateInfo(state, null, null);
                ViewNavigationManager.getInstance().addNavigationState(state);
                this.initializeTextSearchData();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (sourceViewId != null) : "Parameter 'sourceViewId' of method 'finishShowInView' must not be null";
        assert (elements != null && elements.size() == 1) : "Parameter 'elements' of method 'finishShowInView' must be a single element";
        assert (elements.get(0) instanceof IDiffElement) : "Unexpected class in method 'finishShowInView': " + String.valueOf(elements.get(0));
        this.updateStatus(this.getSoftwareSystem());
        IDiffElement element = (IDiffElement)elements.get(0);
        DiffViewTab<Object, Object> tab = element instanceof IIssueDiff ? (element instanceof CycleGroupIssueDiff ? this.m_cyclesTab : (element instanceof DuplicateCodeBlockIssueDiff ? this.m_duplicatesTab : this.m_issuesTab)) : (element instanceof ResolutionDefinitionDiff ? (element instanceof IgnoreDefinitionDiff ? this.m_ignoresTab : (element instanceof RefactoringDefinitionDiff ? this.m_refactoringsTab : (element instanceof TaskDefinitionDiff ? this.m_tasksTab : null))) : (element instanceof CyclicElementDiff ? this.m_cyclesTab : (element instanceof DuplicateCodeBlockOccurrenceDiff ? this.m_duplicatesTab : (element instanceof ModuleDiff || element instanceof RootDirectoryDiff ? this.m_workspaceTab : null))));
        if (tab != null) {
            this.m_tabFolder.setSelection(tab.getTabItem());
            StructuredSelection selection = new StructuredSelection((Object)element);
            tab.getViewer().setSelection((ISelection)selection);
        }
    }

    public void showViewComponent(IStandardEnumeration viewComponent) {
        assert (viewComponent != null) : "Parameter 'viewComponent' of method 'showViewComponent' must not be null";
        this.updateStatus(this.getSoftwareSystem());
        if (viewComponent instanceof SystemDiffViewComponent) {
            switch ((SystemDiffViewComponent)viewComponent) {
                case CONFIGURATION: {
                    this.m_tabFolder.setSelection(this.m_configuration.getTabItem());
                    break;
                }
                case SYSTEM_INFO: {
                    this.m_tabFolder.setSelection(this.m_systemInfoTab.getTabItem());
                    break;
                }
                case METRICS: {
                    this.m_tabFolder.setSelection(this.m_metricTab.getTabItem());
                    break;
                }
                case WORKSPACE: {
                    this.m_tabFolder.setSelection(this.m_workspaceTab.getTabItem());
                    break;
                }
                case ISSUES: {
                    this.m_tabFolder.setSelection(this.m_issuesTab.getTabItem());
                    break;
                }
                case IGNORE: {
                    this.m_tabFolder.setSelection(this.m_ignoresTab.getTabItem());
                    break;
                }
                case TASK: {
                    this.m_tabFolder.setSelection(this.m_tasksTab.getTabItem());
                    break;
                }
                case REFACTORING: {
                    this.m_tabFolder.setSelection(this.m_refactoringsTab.getTabItem());
                    break;
                }
                case CYCLES: {
                    this.m_tabFolder.setSelection(this.m_cyclesTab.getTabItem());
                    break;
                }
                case DUPLICATES: {
                    this.m_tabFolder.setSelection(this.m_duplicatesTab.getTabItem());
                    break;
                }
            }
        }
    }
}

