/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.enterprise.AbstractDownloadFromServerCommand;
import com.hello2morrow.sonargraph.core.command.enterprise.DownloadReportFromServerCommand;
import com.hello2morrow.sonargraph.core.model.enterprise.IConnectionValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteReportInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionResult;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.diffview.BaselineActionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.diffview.CreateBaselineWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SelectBaselineTypePage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractRequestRemoteInfoWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.BaselineAction;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.ConnectionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteReportWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteSystemWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SonargraphEnterprisePreferenceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.ActivityEventBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.LazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Date;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;

final class DownloadBaselineWizard
extends LazySonargraphWizard
implements IPageChangingListener,
IPageChangedListener {
    private final SonargraphEnterprisePreferenceProvider m_preferenceProvider;
    private final ConnectionWizardPage m_connectionWizardPage;
    private final RemoteSystemWizardPage m_remoteSystemWizardPage;
    private final RemoteReportWizardPage m_remoteReportWizardPage;
    private final BaselineActionWizardPage m_actionWizardPage;
    private final ISoftwareSystemProvider m_systemProvider;
    private final SonargraphEnterpriseConnection m_connectionData;
    private final IConnectionValidator m_validator;
    private final SelectBaselineTypePage m_selectBaselineTypePage;
    private BaselineAction m_selectedAction;
    private CreateBaselineWizardPage m_nameAndDirectoryPage;

    DownloadBaselineWizard(ISoftwareSystemProvider systemProvider) {
        super("Download Baseline");
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'DownloadBaselineWizard' must not be null";
        assert (systemProvider.hasSoftwareSystem()) : "Missing software system";
        this.m_systemProvider = systemProvider;
        this.m_preferenceProvider = new SonargraphEnterprisePreferenceProvider();
        Installation installation = this.m_systemProvider.getInstallation();
        ISonargraphEnterpriseProvider enterpriseExtension = (ISonargraphEnterpriseProvider)installation.getExtension(ISonargraphEnterpriseProvider.class);
        this.m_connectionData = this.m_preferenceProvider.loadConnectionData();
        this.m_validator = enterpriseExtension.getConnectionValidator();
        this.m_connectionWizardPage = new ConnectionWizardPage(this.m_validator, this.m_connectionData);
        this.m_connectionWizardPage.setWizard((IWizard)this);
        StandaloneProxySettingsProvider proxyProvider = new StandaloneProxySettingsProvider();
        ProxySettings proxySettings = proxyProvider.getProxySettings(true);
        this.m_remoteSystemWizardPage = new RemoteSystemWizardPage(this.m_systemProvider, enterpriseExtension, proxySettings);
        this.m_remoteSystemWizardPage.setWizard((IWizard)this);
        this.m_remoteReportWizardPage = new RemoteReportWizardPage(enterpriseExtension, proxySettings);
        this.m_remoteReportWizardPage.setWizard((IWizard)this);
        this.m_selectBaselineTypePage = new SelectBaselineTypePage(SelectBaselineTypePage.Mode.OPEN);
        this.m_selectBaselineTypePage.setWizard((IWizard)this);
        this.m_actionWizardPage = new BaselineActionWizardPage();
        this.m_actionWizardPage.setWizard((IWizard)this);
    }

    public int getPageCount() {
        return 6;
    }

    public IWizardPage getStartingPage() {
        return this.m_connectionWizardPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.m_connectionWizardPage) {
            return this.m_remoteSystemWizardPage;
        }
        if (page == this.m_remoteSystemWizardPage) {
            return this.m_remoteReportWizardPage;
        }
        if (page == this.m_remoteReportWizardPage) {
            return this.m_selectBaselineTypePage;
        }
        if (page == this.m_selectBaselineTypePage) {
            RemoteReportInfo remoteReportInfo = (RemoteReportInfo)this.m_remoteReportWizardPage.getSelection();
            Date dateTime = Iso8601DateFormat.parseDataAndTime((String)remoteReportInfo.getTimestamp(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSSX");
            String timestamp = Iso8601DateFormat.formatDateAndTimeForFileName((Date)dateTime);
            String fileName = remoteReportInfo.getSystemName() + "_" + timestamp;
            this.m_nameAndDirectoryPage = CreateBaselineWizardPage.create(WorkbenchRegistry.getInstance().getSoftwareSystem(), this.m_selectBaselineTypePage.getBaselineType(), fileName, ((RemoteReportInfo)this.m_remoteReportWizardPage.getSelection()).getContextInfo(), false);
            this.m_nameAndDirectoryPage.setWizard((IWizard)this);
            return this.m_nameAndDirectoryPage;
        }
        if (page == this.m_nameAndDirectoryPage) {
            return this.m_actionWizardPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.m_remoteSystemWizardPage) {
            return this.m_connectionWizardPage;
        }
        if (page == this.m_remoteReportWizardPage) {
            return this.m_remoteSystemWizardPage;
        }
        if (page == this.m_selectBaselineTypePage) {
            return this.m_remoteReportWizardPage;
        }
        if (page == this.m_nameAndDirectoryPage) {
            return this.m_selectBaselineTypePage;
        }
        if (page == this.m_selectBaselineTypePage) {
            return this.m_nameAndDirectoryPage;
        }
        return null;
    }

    public IWizardPage getPage(String name) {
        if (name.equals(this.m_connectionWizardPage.getName())) {
            return this.m_connectionWizardPage;
        }
        if (name.equals(this.m_remoteSystemWizardPage.getName())) {
            return this.m_remoteSystemWizardPage;
        }
        if (name.equals(this.m_remoteReportWizardPage.getName())) {
            return this.m_remoteReportWizardPage;
        }
        if (name.equals(this.m_selectBaselineTypePage.getName())) {
            return this.m_selectBaselineTypePage;
        }
        if (this.m_nameAndDirectoryPage != null && name.equals(this.m_nameAndDirectoryPage.getName())) {
            return this.m_nameAndDirectoryPage;
        }
        if (name.equals(this.m_actionWizardPage.getName())) {
            return this.m_actionWizardPage;
        }
        return null;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            this.m_preferenceProvider.saveConnectionData(connection.getServer(), connection.getPort(), connection.getClientKey(), connection.useProxy());
            String systemId = this.m_systemProvider.getSoftwareSystem().getId();
            this.m_preferenceProvider.saveBaselineAction(systemId, this.m_actionWizardPage.getSelectedAction());
            this.m_selectedAction = this.m_actionWizardPage.getSelectedAction();
            return true;
        }
        return false;
    }

    public boolean canFinish() {
        return this.m_nameAndDirectoryPage != null && this.m_nameAndDirectoryPage.isPageComplete() && this.m_actionWizardPage.getSelectedAction() != null && this.getBaselineReport() != null;
    }

    public BaselineAction getSelectedAction() {
        return this.m_selectedAction;
    }

    public void handlePageChanging(PageChangingEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handlePageChanging' must not be null";
        if (event.getCurrentPage() instanceof AbstractRequestRemoteInfoWizardPage) {
            ((AbstractRequestRemoteInfoWizardPage)((Object)event.getCurrentPage())).disableEscapeKeyListener();
        }
        if (event.getCurrentPage() == this.m_connectionWizardPage) {
            SonargraphEnterpriseConnection data = this.m_connectionWizardPage.getConnectionData();
            this.m_preferenceProvider.saveConnectionData(data.getServer(), data.getPort(), data.getClientKey(), data.useProxy());
        }
        if (event.getCurrentPage() == this.m_nameAndDirectoryPage && event.getTargetPage() == this.m_actionWizardPage) {
            TFile targetFile = new TFile((File)this.m_nameAndDirectoryPage.getDirectory(), this.m_nameAndDirectoryPage.getFileName() + CoreFileType.REPORT_XML.getDefaultExtension());
            boolean download = targetFile.exists() ? UserInterfaceAdapter.getInstance().question("Baseline XML report file already exists. Do you want to download again?", false) == UserInterfaceAdapter.Feedback.CONFIRMED : true;
            if (download) {
                this.downloadXmlReport(event, targetFile);
            } else {
                this.m_actionWizardPage.setTargetFile(targetFile);
            }
        }
    }

    private void downloadXmlReport(PageChangingEvent event, final TFile targetFile) {
        ActivityEventBasedWorkerContext cancelableWorkerContext = new ActivityEventBasedWorkerContext(this.m_systemProvider);
        final OperationResultWithOutcome commandResult = new OperationResultWithOutcome("Downloading Report");
        final RemoteSystemInfo remoteSystem = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
        final SonargraphEnterpriseConnection connectionData = this.m_connectionWizardPage.getConnectionData();
        final RemoteReportInfo reportInfo = (RemoteReportInfo)this.m_remoteReportWizardPage.getSelection();
        final HttpConnectionConsumer consumer = new HttpConnectionConsumer((IWorkerContext)cancelableWorkerContext){
            private final /* synthetic */ IWorkerContext val$cancelableWorkerContext;
            {
                this.val$cancelableWorkerContext = iWorkerContext;
            }

            public boolean hasBeenCanceled() {
                return this.val$cancelableWorkerContext.hasBeenCanceled();
            }
        };
        DownloadReportFromServerCommand downloadCommand = new DownloadReportFromServerCommand(this.m_systemProvider, (AbstractDownloadFromServerCommand.IInteraction)new AbstractDownloadFromServerCommand.IInteraction<RemoteReportInfo>(){

            public void processResult(OperationResultWithOutcome<TFile> result) {
                commandResult.addMessagesFrom(result);
                commandResult.setOutcome((Object)((TFile)result.getOutcome()));
                if (result.isFailure() && consumer.getResult() == HttpConnectionResult.FAILURE) {
                    commandResult.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, consumer.getLastMessage(), new Object[0]);
                }
            }

            public boolean collect(AbstractDownloadFromServerCommand.CommandInteractionData<RemoteReportInfo> data) {
                data.setInfoProvider(DownloadReportFromServerCommand.getInfoProvider((ISoftwareSystemProvider)DownloadBaselineWizard.this.m_systemProvider, (SonargraphEnterpriseConnection)connectionData, (ProxySettings)new StandaloneProxySettingsProvider().getProxySettings(true), (IConnectionConsumer)consumer));
                data.setRemoteSystem(remoteSystem);
                data.setRemoteInfo((Object)reportInfo);
                data.setTargetFile(targetFile);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)downloadCommand, (IWorkerContext)cancelableWorkerContext);
        if (commandResult.isFailure()) {
            UserInterfaceAdapter.getInstance().process((OperationResult)commandResult);
            event.doit = false;
        } else {
            this.m_actionWizardPage.setTargetFile((TFile)commandResult.getOutcome());
        }
        if (cancelableWorkerContext.hasBeenCanceled()) {
            event.doit = false;
        }
    }

    public void pageChanged(PageChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'pageChanged' must not be null";
        IWizardContainer container = this.getContainer();
        if (container != null) {
            SwtUtility.consumeUiEvents((Control)container.getShell());
        }
        if (event.getSelectedPage() == this.m_remoteSystemWizardPage) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            boolean changedConnection = this.m_remoteSystemWizardPage.setConnection(connection);
            if (changedConnection) {
                this.m_remoteSystemWizardPage.execute();
            }
        } else if (event.getSelectedPage() == this.m_remoteReportWizardPage) {
            SonargraphEnterpriseConnection connection = this.m_connectionWizardPage.getConnectionData();
            boolean changedConnection = this.m_remoteReportWizardPage.setConnection(connection);
            RemoteSystemInfo remoteSystem = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
            boolean changedSystem = this.m_remoteReportWizardPage.updateInfo(remoteSystem);
            if (changedConnection || changedSystem) {
                this.m_remoteReportWizardPage.execute();
            }
        } else if (event.getSelectedPage() == this.m_actionWizardPage) {
            RemoteSystemInfo remoteSystem = (RemoteSystemInfo)this.m_remoteSystemWizardPage.getSelection();
            BaselineAction preferredAction = this.m_preferenceProvider.getBaselineAction(remoteSystem.getId(), BaselineAction.USE_AS_BASELINE);
            this.m_actionWizardPage.setDefaultBaselineAction(preferredAction);
        }
    }

    public TFile getBaselineReport() {
        return this.m_actionWizardPage.getDownloadedReport();
    }

    public BaselineType getBaselineType() {
        return this.m_selectBaselineTypePage.getBaselineType();
    }
}

