/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginProvider;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ConfigurationDialogHelper;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.IAnalyzerPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PluginPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PreferencePageRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;

final class DiffViewDoubleClickSupport {
    DiffViewDoubleClickSupport() {
    }

    public static boolean handleDoubleClick(Element doubleClickedElement, SoftwareSystem softwareSystem, Installation installation) {
        assert (doubleClickedElement != null) : "Parameter 'doubleClickedElement' of method 'handleDoubleClick' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'handleDoubleClick' must not be null";
        Element element = doubleClickedElement instanceof IIssueDiff ? ((IIssueDiff)doubleClickedElement).getCurrentElement() : (doubleClickedElement instanceof IDiffElement ? ((IDiffElement)doubleClickedElement).getCurrentElement() : doubleClickedElement);
        if (element instanceof AnalyzerConfigurationFile) {
            if (softwareSystem != null) {
                IPreferenceNode[] rootNodes;
                PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(softwareSystem.getUsedLanguages(), ((IPluginProvider)installation.getExtension(IPluginProvider.class)).getPlugins());
                IAnalyzerId analyzerId = ((AnalyzerConfigurationFile)element).getAnalyzerId();
                String pageId = null;
                IPreferenceNode[] iPreferenceNodeArray = rootNodes = preferenceManager.getRootSubNodes();
                int n = rootNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnalyzerPreferencePage nextAnalyzerPreferencePage;
                    IPreferenceNode nextNode = iPreferenceNodeArray[n2];
                    IPreferencePage nextPage = nextNode.getPage();
                    if (nextPage instanceof IAnalyzerPreferencePage && analyzerId.equals((nextAnalyzerPreferencePage = (IAnalyzerPreferencePage)nextPage).getAnalyzerId())) {
                        pageId = nextAnalyzerPreferencePage.getId();
                        break;
                    }
                    ++n2;
                }
                if (pageId != null) {
                    ConfigurationDialogHelper.openPreferencePage(preferenceManager, pageId);
                    return true;
                }
            }
        } else if (element instanceof PluginConfigurationFile && softwareSystem != null) {
            IPreferenceNode[] rootNodes;
            PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(softwareSystem.getUsedLanguages(), ((IPluginProvider)installation.getExtension(IPluginProvider.class)).getPlugins());
            String pluginId = ((PluginConfigurationFile)element).getPluginId();
            String pageId = null;
            IPreferenceNode[] iPreferenceNodeArray = rootNodes = preferenceManager.getRootSubNodes();
            int n = rootNodes.length;
            int n3 = 0;
            while (n3 < n) {
                PluginPreferencePage nextPluginPreferencePage;
                String nextPluginId;
                IPreferenceNode nextNode = iPreferenceNodeArray[n3];
                IPreferencePage nextPage = nextNode.getPage();
                if (nextPage instanceof PluginPreferencePage && pluginId.equals(nextPluginId = (nextPluginPreferencePage = (PluginPreferencePage)nextPage).getPluginId())) {
                    pageId = nextPluginPreferencePage.getId();
                    break;
                }
                ++n3;
            }
            if (pageId != null) {
                ConfigurationDialogHelper.openPreferencePage(preferenceManager, pageId);
                return true;
            }
        }
        return false;
    }
}

