/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class CreateBaselineWizardPage
extends StandardWizardPage {
    private static final CoreDialogId ID = CoreDialogId.CREATE_BASELINE;
    private TFile m_directory;
    private String m_name;
    private String m_description;
    private final BaselineType m_type;
    private final boolean m_descriptionEditable;

    public static CreateBaselineWizardPage create(SoftwareSystem softwareSystem, BaselineType type, String name, String description, boolean descriptionEditable) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'create' must not be null";
        assert (type != null) : "Parameter 'type' of method 'create' must not be null";
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        List baselines = systemDiffProvider.getRecentlyUsedBaselineReports(type);
        TFile directory = baselines.isEmpty() ? (type == BaselineType.SYSTEM ? systemDiffProvider.getBaselinesDirectory().getDirectoryFile() : systemDiffProvider.getHiddenBaselinesDirectory()) : ((BaselineInfo)baselines.get(0)).getFile().getParentFile();
        String nameToUse = name != null ? name : systemDiffProvider.getBaselineFileNameProposal();
        CreateBaselineWizardPage wizardPage = new CreateBaselineWizardPage(type, directory, nameToUse, description != null ? description : "", descriptionEditable);
        return wizardPage;
    }

    private CreateBaselineWizardPage(BaselineType type, TFile directory, String name, String description, boolean descriptionEditable) {
        super(ID.getStandardName(), "Create New " + type.getPresentationName() + " Baseline");
        assert (directory != null) : "Parameter 'directory' of method 'CreateBaselineWizardPage' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'CreateBaselineWizardPage' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'CreateBaselineWizardPage' must not be null";
        this.m_type = type;
        this.m_directory = directory;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptionEditable = descriptionEditable;
        this.m_description = description;
    }

    protected IDialogId getDialogId() {
        return ID;
    }

    protected void createContent(Composite composite) {
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        directoryLabel.setText("Directory: ");
        if (this.m_type == BaselineType.SYSTEM) {
            Text directoryText = new Text(composite, 0);
            directoryText.setLayoutData((Object)new GridData(4, 4, true, false));
            directoryText.setEditable(false);
            Files files = (Files)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getUniqueExistingChild(Files.class);
            String path = FileUtility.calculateRelativePath((TFile)this.m_directory, (TFile)files.getBaseDirectory().getDirectoryFile());
            directoryText.setText(path);
        } else {
            ValidatingPathWidget directory = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

                public void setPath(TFile input, boolean inputModified) {
                    if (inputModified) {
                        CreateBaselineWizardPage.this.m_directory = input;
                        CreateBaselineWizardPage.this.inputChanged();
                    }
                }
            }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ_WRITE), 1, this.m_directory, false);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 500;
            directory.setLayoutData((Object)gridData);
        }
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        nameLabel.setText("Name: ");
        ValidatingTextWidget name = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                TFile baseline;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().length() == 0) {
                    result.addError("Must not be empty");
                    return result;
                }
                String fileName = newInput.trim();
                String extension = CoreFileType.BASELINE.getDefaultExtension();
                if (fileName.toLowerCase().endsWith(extension)) {
                    result.addWarning("Extension " + extension + " will be added automatically");
                }
                if ((baseline = new TFile((File)CreateBaselineWizardPage.this.m_directory, fileName + extension)).exists()) {
                    result.addWarning("Baseline with the same name already exists and will be overwritten");
                    return result;
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (inputModified) {
                    CreateBaselineWizardPage.this.m_name = input;
                    CreateBaselineWizardPage.this.inputChanged();
                }
            }
        }, this.m_name, 0);
        name.setLayoutData((Object)new GridData(4, 4, true, false));
        Label contextInfoLabel = new Label(composite, 0);
        contextInfoLabel.setText("Description: ");
        contextInfoLabel.setLayoutData((Object)new GridData(4, Platform.isWindows() ? 128 : 0x1000000, false, false));
        final Text description = new Text(composite, 2818);
        description.setLayoutData((Object)new GridData(4, 4, true, true));
        description.setText(this.m_description);
        description.setEditable(this.m_descriptionEditable);
        description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBaselineWizardPage.this.m_description = description.getText();
            }
        });
    }

    private void inputChanged() {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.m_directory != null && this.m_name != null && this.m_name.length() > 0;
    }

    public String getReportDescription() {
        return this.m_description;
    }

    public TFile getDirectory() {
        return this.m_directory;
    }

    public String getFileName() {
        return this.m_name;
    }
}

