/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.diffview.DiffViewTab;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

abstract class AbstractTableViewerBasedDiffTab<T>
extends DiffViewTab<Table, TableViewer> {
    private final PropertyTableViewer<T> m_tableViewer;

    protected AbstractTableViewerBasedDiffTab(CTabFolder parent, String title, String imageName, String defaultSortProperty) {
        super(parent, title, imageName);
        this.m_tableViewer = new PagingPropertyTableViewer((Composite)parent, this.createBeanAdapter(), defaultSortProperty, true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.getTabItem().setControl(this.m_tableViewer);
        this.m_tableViewer.setBackground(UiResourceManager.getInstance().getBackgroundColor());
    }

    protected AbstractTableViewerBasedDiffTab(CTabFolder parent, String title, String imageName, String defaultSortProperty, String hideButtonLabel) {
        super(parent, title, imageName);
        assert (hideButtonLabel != null && hideButtonLabel.length() > 0) : "Parameter 'hideButtonLabel' of method 'AbstractTableViewerBasedDiffTab' must not be empty";
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tableViewer = new PagingPropertyTableViewer(composite, this.createBeanAdapter(), defaultSortProperty, true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_tableViewer.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_tableViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button hideButton = new Button(composite, 32);
        hideButton.setLayoutData((Object)new GridData(4, 1024, true, false));
        hideButton.setSelection(false);
        hideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableViewerBasedDiffTab.this.hideElements(hideButton.getSelection());
            }
        });
        hideButton.setText(hideButtonLabel);
        this.getTabItem().setControl((Control)composite);
    }

    protected void hideElements(boolean hide) {
    }

    abstract BeanPropertyReader.BeanAdapter<T> createBeanAdapter();

    @Override
    final void clear() {
        this.m_tableViewer.showData(null);
        this.setExclamationMarkInTabTitle(false);
    }

    protected final PropertyTableViewer<T> getPropertyTableViewer() {
        return this.m_tableViewer;
    }

    @Override
    final IStructuredSelection getSelection() {
        return this.m_tableViewer.getSelection();
    }

    @Override
    final void clearSelection() {
        this.m_tableViewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    final TableViewer getViewer() {
        return this.m_tableViewer.getTableViewer();
    }

    final Table getControl() {
        return this.m_tableViewer.getTable();
    }

    @Override
    final BaseTextSearchHandler createTextSearchHandler(String viewPresentationName) {
        return new PropertyTableViewerBasedTextSearchHandler(this.m_tableViewer, viewPresentationName);
    }
}

