/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ImageExtension;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.FileDialog;

public final class ExportToImageHandler
extends CommandHandler {
    private static final ImageExtension LINUX_IMAGE_EXTENSION = ImageExtension.PNG;

    private final String getMenuLabel(IWorkbenchView workbenchView) {
        if (workbenchView != null) {
            return "Export " + workbenchView.getExportImageSourceInfo() + " To Image...";
        }
        return "Export To Image...";
    }

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return true;
            }

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'getLabel' must not be null");
                }
                return ExportToImageHandler.this.getMenuLabel(null);
            }

            public IMenuGroup getMenuGroup() {
                return IContextMenuContributor.SpecialMenuGroup.FIRST;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection, @Optional MMenuItem menuItem) {
        IWorkbenchView workbenchView;
        if (selection != null && (workbenchView = selection.getWorkbenchView()) != null && workbenchView.supportsImageExport()) {
            if (menuItem != null) {
                menuItem.setLabel(this.getMenuLabel(workbenchView));
            }
            return true;
        }
        if (menuItem != null) {
            menuItem.setLabel(this.getMenuLabel(null));
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        IWorkbenchView workbenchView = selection.getWorkbenchView();
        assert (workbenchView != null) : "'workbenchView' of method 'execute' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'export' must not be null";
        FileDialog saveDialog = new FileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 8192);
        ImageExtension[] supportedExtensions = ImageExtension.values();
        String[] filterNames = new String[supportedExtensions.length];
        String[] filterExtensions = new String[supportedExtensions.length];
        String[] fullExtensions = new String[supportedExtensions.length];
        int i = 0;
        while (i < supportedExtensions.length) {
            filterNames[i] = supportedExtensions[i].getFilterName();
            filterExtensions[i] = supportedExtensions[i].getSimpleExtension();
            fullExtensions[i] = supportedExtensions[i].getExtension();
            ++i;
        }
        if (Platform.isLinux()) {
            saveDialog.setFilterNames(new String[]{LINUX_IMAGE_EXTENSION.getFilterName()});
            saveDialog.setFilterExtensions(new String[]{"*" + LINUX_IMAGE_EXTENSION.getExtension()});
        } else {
            saveDialog.setFilterNames(filterNames);
            saveDialog.setFilterExtensions(filterExtensions);
        }
        saveDialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("ExportImage"));
        String initialExportImageName = workbenchView.getInitialExportImageName();
        if (initialExportImageName != null && !initialExportImageName.isEmpty()) {
            saveDialog.setFileName(initialExportImageName);
        }
        SaveResult saveResult = null;
        String path = saveDialog.open();
        if (path != null && !path.trim().isEmpty()) {
            int filterIndex = saveDialog.getFilterIndex();
            if (Platform.isLinux()) {
                saveResult = new SaveResult(path, LINUX_IMAGE_EXTENSION.getExtension());
            } else if (filterIndex >= 0 && filterIndex < filterExtensions.length) {
                saveResult = new SaveResult(path, fullExtensions[filterIndex]);
            }
        }
        if (saveResult != null) {
            OperationResult result;
            TFile targetFile = new TFile(saveResult.getFullPath());
            if (targetFile.exists()) {
                StringBuilder question = new StringBuilder("Overwrite existing file '" + saveResult.getFullPath() + "'?");
                UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question(question.toString(), false);
                if (feedback != UserInterfaceAdapter.Feedback.CONFIRMED) {
                    return;
                }
            }
            if ((result = workbenchView.exportToImage(targetFile)).isSuccess()) {
                result.addInfo((OperationResult.IMessageCause)ExportMessageCause.IMAGE_EXPORTED_TO_FILE, "File: " + FileUtility.getIdentifyingPath((TFile)targetFile));
            }
            UserInterfaceAdapter.getInstance().process(result);
        }
        WorkbenchRegistry.getInstance().getProvider().setLocation("ExportImage", saveDialog.getFilterPath());
    }

    static enum ExportMessageCause implements OperationResult.IMessageCause
    {
        IMAGE_EXPORTED_TO_FILE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    static final class SaveResult {
        private final String m_fullPath;

        SaveResult(String path, String fullExtension) {
            assert (path != null && path.length() > 0) : "Parameter 'path' of method 'SaveResult' must not be empty";
            assert (fullExtension != null && !fullExtension.isEmpty()) : "Parameter 'fullExtension' of method 'SaveResult' must not be empty";
            this.m_fullPath = path.endsWith(fullExtension) ? path : path + fullExtension;
        }

        public String getFullPath() {
            return this.m_fullPath;
        }
    }
}

