/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.export.ExcelExportCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.FileDialog;

public abstract class ExportToExcelBaseHandler
extends CommandHandlerWithCorrespondingCommand {
    public final ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EXCEL_EXPORT;
    }

    protected abstract boolean supportsExcelExport(IWorkbenchView var1);

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                return ExportToExcelBaseHandler.this.supportsExcelExport(workbenchView);
            }
        };
    }

    protected abstract String getCorrespondingMenuItem();

    protected abstract String getInitialMenuLabel();

    protected abstract String getMenuLabel(IWorkbenchView var1);

    @CanExecute
    public final boolean canExecute(IEclipseContext eclipseContext, @Optional MMenuItem menuItem) {
        IWorkbenchView workbenchView;
        if (menuItem == null) {
            menuItem = (MMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)eclipseContext, (MUIElement)WorkbenchRegistry.getInstance().getMainApplicationWindow().getMainMenu(), (String)this.getCorrespondingMenuItem(), MMenuItem.class);
            assert (menuItem != null) : "'menuItem' of method 'canExecute' must not be null";
        }
        menuItem.setLabel(this.getInitialMenuLabel());
        if (this.isAvailable(menuItem) && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.EXPORT_NOT_BLOCKED}) && (workbenchView = WorkbenchRegistry.getInstance().getCurrentlySelectedView()) != null && this.supportsExcelExport(workbenchView)) {
            menuItem.setLabel(this.getMenuLabel(workbenchView));
            return true;
        }
        return false;
    }

    protected abstract List<ExportData> getExportData(IWorkbenchView var1, IWorkerContext var2);

    protected abstract String getExportFileBaseName(IWorkbenchView var1);

    @Execute
    public final void execute() {
        TFile file;
        final IWorkbenchView workbenchView = WorkbenchRegistry.getInstance().getCurrentlySelectedView();
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'execute' must not be null";
        if (workbenchView.performAnalyzerExecutionLevelCheckOnExcelExport() && !ExportToExcelBaseHandler.performCheck((CommandHandler.Check)CommandHandler.Check.LEVEL, (boolean)true)) {
            return;
        }
        FileDialog saveDialog = new FileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 8192);
        saveDialog.setFilterNames(new String[]{"XLS (*.xls)"});
        saveDialog.setFilterExtensions(new String[]{"*.xls"});
        saveDialog.setFileName(this.getExportFileBaseName(workbenchView) + "_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date()) + ".xls");
        saveDialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("ExportExcel"));
        String filePathName = saveDialog.open();
        if (filePathName == null || filePathName.trim().length() == 0) {
            return;
        }
        if (!filePathName.endsWith(".xls")) {
            filePathName = filePathName.concat(".xls");
        }
        if ((file = new TFile(filePathName)).exists() && UserInterfaceAdapter.getInstance().question("Export file already exists. Overwrite existing file?", false) != UserInterfaceAdapter.Feedback.CONFIRMED) {
            return;
        }
        ExcelExportCommand excelExportCommand = new ExcelExportCommand(WorkbenchRegistry.getInstance().getProvider(), new ExcelExportCommand.IExcelExportInteraction(){

            public INavigationState getNavigationState() {
                return null;
            }

            public boolean collect(ExcelExportCommand.ExcelExportInteractionData data, IWorkerContext workerContext) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                List<ExportData> excelExportData = ExportToExcelBaseHandler.this.getExportData(workbenchView, workerContext);
                data.setExcelExportData(excelExportData);
                data.setExcelFile(file);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)excelExportCommand);
        WorkbenchRegistry.getInstance().getProvider().setLocation("ExportExcel", saveDialog.getFilterPath());
    }
}

