/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionListener
implements IExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionListener.class);

    public void notHandled(String commandId, NotHandledException exception) {
        LOGGER.error("Command [" + commandId + "] has not been handled: " + ExceptionUtility.collectAll((Throwable)exception));
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
        LOGGER.error("Command [" + commandId + "] failed to complete execution: " + ExceptionUtility.collectAll((Throwable)exception));
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Command [" + commandId + "] executed successfully.");
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Command [" + commandId + "] is about to be executed. Passed in event:\n" + String.valueOf(event));
        }
    }
}

