/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class FocusableToolTip
implements Listener {
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 100;
    private static final int MAX_HEIGHT = 600;
    private static final Point MIN_SIZE = new Point(300, 100);
    private final Display m_display;
    private final Control m_control;
    private final IToolTipProvider m_provider;
    private final int m_delayInMilliSeconds;
    private Shell m_shell;
    private Label m_focusLabel;
    private Text m_tooltipText;
    private Text m_focusedTooltipText;
    private ToolTipThread m_thread;

    private static GridLayout createLayout() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public FocusableToolTip(Control control, IToolTipProvider provider, int delayInMilliSeconds) {
        assert (control != null) : "Parameter 'control' of method 'FocusableToolTip' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'FocusableToolTip' must not be null";
        assert (!control.isDisposed()) : "Already disposed: " + String.valueOf(control);
        assert (delayInMilliSeconds > 0) : "'delayInMilliSeconds' must be greater than 0";
        this.m_display = control.getDisplay();
        assert (!this.m_display.isDisposed()) : "Already disposed: " + String.valueOf(this.m_display);
        this.m_control = control;
        this.m_provider = provider;
        this.m_delayInMilliSeconds = delayInMilliSeconds;
        this.m_display.addFilter(1, (Listener)this);
        this.m_display.addFilter(3, (Listener)this);
        this.m_control.addListener(12, (Listener)this);
        this.m_control.addListener(5, (Listener)this);
        this.m_control.addListener(37, (Listener)this);
        this.m_control.addListener(32, (Listener)this);
        this.m_control.setToolTipText("");
    }

    public FocusableToolTip(Control control, IToolTipProvider provider) {
        this(control, provider, 700);
    }

    private void openTooltip(Point location, String text) {
        assert (location != null) : "Parameter 'location' of method 'openTooltip' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'openTooltip' must not be empty";
        this.m_shell = new Shell(this.m_control.getShell(), 4);
        this.m_shell.setLayout((Layout)FocusableToolTip.createLayout());
        this.m_tooltipText = new Text((Composite)this.m_shell, 586);
        this.m_tooltipText.setForeground(UiResourceManager.getInstance().getForegroundColor());
        this.m_tooltipText.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_tooltipText.setText(text);
        this.m_tooltipText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tooltipText.addListener(4, (Listener)this);
        Label separator = new Label((Composite)this.m_shell, 262);
        separator.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_focusLabel = new Label((Composite)this.m_shell, 131072);
        this.m_focusLabel.setForeground(UiResourceManager.getInstance().getForegroundColor());
        this.m_focusLabel.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_focusLabel.setText("Click to focus");
        this.m_focusLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_focusLabel.addListener(4, (Listener)this);
        Point tooltipTextSize = this.m_tooltipText.computeSize(300, -1);
        Point separatorSize = separator.computeSize(-1, -1);
        Point focusLabelSize = this.m_focusLabel.computeSize(-1, -1);
        Point toolTipAnchor = this.m_control.toDisplay(location);
        Point idealToolTipSize = new Point(Math.max(tooltipTextSize.x, focusLabelSize.x), tooltipTextSize.y + separatorSize.y + focusLabelSize.y);
        Rectangle toolTipBounds = new Rectangle(toolTipAnchor.x, toolTipAnchor.y, Math.max(idealToolTipSize.x, 300), Math.min(idealToolTipSize.y, 600));
        SwtUtility.adjustToMonitorBounds((Rectangle)toolTipBounds, (Shell)this.m_shell);
        this.m_shell.setMinimumSize(MIN_SIZE);
        this.m_shell.setBounds(toolTipBounds);
        this.m_shell.setVisible(true);
    }

    private void openFocusedTooltip(Rectangle bounds, String text) {
        assert (bounds != null) : "Parameter 'bounds' of method 'openFocusedTooltip' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'openFocusedTooltip' must not be empty";
        Shell shell = this.m_display.getActiveShell();
        this.m_shell = new Shell(shell, 20);
        this.m_shell.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_shell.setLayout((Layout)FocusableToolTip.createLayout());
        this.m_focusedTooltipText = new Text((Composite)this.m_shell, 586);
        this.m_focusedTooltipText.setForeground(UiResourceManager.getInstance().getForegroundColor());
        this.m_focusedTooltipText.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_focusedTooltipText.setText(text);
        this.m_focusedTooltipText.setLayoutData((Object)new GridData(1808));
        this.m_focusedTooltipText.addListener(1, (Listener)this);
        Label separator = new Label((Composite)this.m_shell, 262);
        separator.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        separator.setLayoutData((Object)new GridData(4, 0, true, false));
        Label escLabel = new Label((Composite)this.m_shell, 131072);
        escLabel.setForeground(UiResourceManager.getInstance().getForegroundColor());
        escLabel.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        escLabel.setText("ESC to close");
        escLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_shell.setMinimumSize(MIN_SIZE);
        this.m_shell.setBounds(bounds);
        this.m_shell.setVisible(true);
        this.m_focusedTooltipText.setFocus();
    }

    public void closeTooltip() {
        if (this.m_shell != null) {
            this.m_shell.dispose();
            this.m_shell = null;
            this.m_focusLabel = null;
            this.m_tooltipText = null;
            this.m_focusedTooltipText = null;
        }
    }

    public final void handleEvent(Event event) {
        if (this.m_thread != null) {
            this.m_thread.setShowToolTip(false);
            this.m_thread.setCloseToolTip(false);
            this.m_thread = null;
        }
        try {
            switch (event.type) {
                case 4: {
                    assert (this.m_shell != null) : "'m_shell' of method 'handleEvent' must not be null";
                    assert (this.m_tooltipText != null) : "'m_tooltip' of method 'handleEvent' must not be null";
                    Rectangle bounds = this.m_shell.getBounds();
                    String text = this.m_tooltipText.getText();
                    this.closeTooltip();
                    this.openFocusedTooltip(bounds, text);
                    break;
                }
                case 1: {
                    if (this.m_tooltipText != null || this.m_focusedTooltipText != null && event.keyCode == 27) {
                        this.closeTooltip();
                    }
                    break;
                }
                case 12: {
                    if (!this.m_display.isDisposed() && this.m_display.getThread() == Thread.currentThread()) {
                        this.m_display.removeFilter(1, (Listener)this);
                        this.m_display.removeFilter(3, (Listener)this);
                    }
                    this.closeTooltip();
                    break;
                }
                case 3: {
                    if (this.m_tooltipText != null) {
                        if (event.widget != this.m_tooltipText && event.widget != this.m_focusLabel) {
                            this.closeTooltip();
                        }
                    } else if (this.m_focusedTooltipText != null && event.widget != this.m_focusedTooltipText) {
                        this.closeTooltip();
                    }
                    break;
                }
                case 5: {
                    if (this.m_tooltipText != null) {
                        Rectangle toolTipBounds = this.m_shell.getBounds();
                        Rectangle extendedBounds = new Rectangle(toolTipBounds.x - 10, toolTipBounds.y - 10, toolTipBounds.width + 20, toolTipBounds.height + 20);
                        Point point = this.m_control.toDisplay(event.x, event.y);
                        if (!extendedBounds.contains(point)) {
                            this.closeTooltip();
                        }
                    }
                    break;
                }
                case 37: {
                    if (this.m_tooltipText != null) {
                        this.closeTooltip();
                    }
                    break;
                }
                case 32: {
                    if (this.m_tooltipText != null || this.m_focusedTooltipText != null) break;
                    this.m_thread = new ToolTipThread(new Point(event.x, event.y));
                    this.m_control.getDisplay().timerExec(this.m_delayInMilliSeconds, (Runnable)this.m_thread);
                }
                default: {
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.closeTooltip();
        }
    }

    public static interface IToolTipProvider {
        public String getToolTipText(Point var1);
    }

    private final class ToolTipThread
    extends Thread {
        private final Point m_location;
        private boolean m_showToolTip = true;
        private boolean m_closeToolTip;

        ToolTipThread(Point location) {
            assert (location != null) : "Parameter 'location' of method 'ToolTipThread' must not be null";
            this.m_location = location;
        }

        void setShowToolTip(boolean show) {
            this.m_showToolTip = show;
        }

        void setCloseToolTip(boolean close) {
            this.m_closeToolTip = close;
        }

        @Override
        public void run() {
            if (this.m_showToolTip) {
                this.m_showToolTip = false;
                FocusableToolTip.this.closeTooltip();
                String text = FocusableToolTip.this.m_provider.getToolTipText(this.m_location);
                if (text != null && !text.isEmpty()) {
                    FocusableToolTip.this.openTooltip(this.m_location, text);
                    if (FocusableToolTip.this.m_thread != null) {
                        FocusableToolTip.this.m_thread.setCloseToolTip(true);
                        FocusableToolTip.this.m_display.timerExec(7000, (Runnable)FocusableToolTip.this.m_thread);
                    }
                }
            } else if (this.m_closeToolTip) {
                this.m_closeToolTip = false;
                FocusableToolTip.this.closeTooltip();
            }
        }
    }
}

