/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public final class DropTargetAdapter<T>
extends ViewerDropAdapter {
    private final IDropTargetActionHandler<T> m_handler;
    private final List<Class<? extends T>> m_dropClasses;
    private final boolean m_supportsEmptyDrop;
    private List<T> m_selection;
    private T m_target;
    private DropLocation m_location;

    public static final int convertToPosition(DropLocation location, int positionOfTarget, int numberOfChildren) {
        assert (location != null) : "Parameter 'location' of method 'convertToPosition' must not be null";
        assert (positionOfTarget >= 0) : "Parameter 'positionOfTarget' of method 'convertToPosition' must not be nagative";
        assert (numberOfChildren >= 0) : "Parameter 'numberOfChildren' of method 'convertToPosition' must not be nagative";
        assert (positionOfTarget < numberOfChildren) : "'positionOfTarget' of method 'convertToPosition' out of range";
        switch (location) {
            case BEFORE: {
                return positionOfTarget;
            }
            case AFTER: 
            case ON: {
                return positionOfTarget + 1;
            }
        }
        assert (false) : "Unhandled location: " + String.valueOf(location);
        return -1;
    }

    public DropTargetAdapter(StructuredViewer viewer, IDropTargetActionHandler<T> handler, List<Class<? extends T>> dropClasses, boolean supportsEmptyDrop) {
        super((Viewer)viewer);
        assert (viewer != null) : "Parameter 'viewer' of method 'DragTargetAdapter' must not be null";
        assert (handler != null) : "Parameter 'handler' of method 'DropTargetAdapter' must not be null";
        assert (dropClasses != null && dropClasses.size() > 0) : "Parameter 'dropClasses' of method 'DragTargetAdapter' must not be empty";
        this.m_handler = handler;
        this.m_dropClasses = dropClasses;
        this.m_supportsEmptyDrop = supportsEmptyDrop;
    }

    public StructuredViewer getViewer() {
        return (StructuredViewer)super.getViewer();
    }

    public void connectWithViewer(int operations, Transfer[] transfer) {
        StructuredViewer viewer = this.getViewer();
        if (viewer.getControl().getData("DropTarget") == null) {
            viewer.addDropSupport(operations, transfer, (DropTargetListener)this);
        }
    }

    public void setSelection(List<T> selection) {
        this.m_selection = selection;
    }

    public void drop(DropTargetEvent event) {
        Object target = this.determineTarget(event);
        int location = this.determineLocation(event);
        switch (location) {
            case 1: {
                this.m_location = DropLocation.BEFORE;
                break;
            }
            case 2: {
                this.m_location = DropLocation.AFTER;
                break;
            }
            case 3: {
                this.m_location = DropLocation.ON;
                break;
            }
            default: {
                this.m_location = this.m_supportsEmptyDrop ? DropLocation.AFTER : null;
            }
        }
        this.m_target = target;
        super.drop(event);
    }

    public boolean performDrop(Object data) {
        if ((this.m_supportsEmptyDrop || this.m_target != null) && this.m_location != null && this.m_selection != null && this.m_selection.size() > 0) {
            boolean result = this.m_handler.perform(this.m_target, this.m_location, this.m_selection, this.getViewer());
            this.m_selection = null;
            this.m_location = null;
            this.m_target = null;
            return result;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target != null) {
            boolean isValid = false;
            for (Class<T> next : this.m_dropClasses) {
                if (!next.isAssignableFrom(target.getClass())) continue;
                isValid = true;
                break;
            }
            if (isValid) {
                return this.m_handler.validateDrop(target, operation, transferType);
            }
            return false;
        }
        return this.m_supportsEmptyDrop;
    }

    public static interface IDropTargetActionHandler<T> {
        public static final /* synthetic */ boolean $assertionsDisabled;

        default public boolean validateDrop(T target, int operation, TransferData transferType) {
            assert (target != null) : "Parameter 'target' of method 'validateDrop' must not be null";
            return true;
        }

        public boolean perform(T var1, DropLocation var2, List<T> var3, StructuredViewer var4);
    }
}

