/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.Marker;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MarkerPaintListener
implements PaintListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkerPaintListener.class);
    private final StyledText m_styledText;
    private final Map<Integer, List<Marker>> m_lineToMarkers;

    MarkerPaintListener(StyledText styledText, Map<Integer, List<Marker>> lineToMarker) {
        assert (styledText != null) : "Parameter 'styledText' of method 'MarkerPaintListener' must not be null";
        assert (lineToMarker != null) : "Parameter 'lineToMarker' of method 'MarkerPaintListener' must not be null";
        this.m_styledText = styledText;
        this.m_lineToMarkers = lineToMarker;
    }

    public void paintControl(PaintEvent event) {
        assert (event != null) : "Parameter 'event' of method 'paintControl' must not be null";
        int lineHeight = this.m_styledText.getLineHeight();
        int firstVisibleLine = this.m_styledText.getTopIndex();
        int lastVisibleLine = Math.min(firstVisibleLine + this.m_styledText.getClientArea().height / lineHeight, this.m_styledText.getLineCount());
        for (Map.Entry<Integer, List<Marker>> nextEntry : this.m_lineToMarkers.entrySet()) {
            int nextLine = nextEntry.getKey();
            for (Marker nextMarker : nextEntry.getValue()) {
                int nextLineOffset;
                block7: {
                    if (nextLine < firstVisibleLine || nextLine > lastVisibleLine) continue;
                    nextLineOffset = 1;
                    try {
                        nextLineOffset = this.m_styledText.getOffsetAtLine(nextLine == 0 ? nextLine : nextLine - 1);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.error("Error painting marker. Failed to get offset at widget line: " + (nextLine - 1) + "; firstVisibleLine = " + firstVisibleLine + ", lastVisibleLine = " + lastVisibleLine);
                        if (nextLine < 0) {
                            nextLineOffset = 0;
                        }
                        if (nextLine > this.m_styledText.getLineCount()) {
                            nextLineOffset = this.m_styledText.getOffsetAtLine(this.m_styledText.getLineCount() - 1);
                        }
                        if ($assertionsDisabled) break block7;
                        throw new AssertionError((Object)"Invalid line number");
                    }
                }
                Point nextLineLocation = this.m_styledText.getLocationAtOffset(nextLineOffset);
                Image nextMarkerImage = UiResourceManager.getInstance().getImage(nextMarker.getImageResourceName());
                event.gc.drawImage(nextMarkerImage, 0, 0, nextMarkerImage.getBounds().width, nextMarkerImage.getBounds().height, 0, nextLineLocation.y + 1, lineHeight, lineHeight - 2);
            }
        }
    }
}

