/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.EditableModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.EditorPreferences;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.MultilineInformation;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SyntaxHighlightMode;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EditableSourceViewWidget
extends SourceViewWidget
implements ExtendedModifyListener,
VerifyListener,
IEclipsePreferences.IPreferenceChangeListener,
PaintListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditableSourceViewWidget.class);
    private static final String CR = "\u00a4";
    private static final String LF = "\u00b6";
    private static final String BLANK = "\u00b7";
    private static final String TAB = "\u00bb";
    private static final String CR_LF = "\u00a4\u00b6";
    private final EditorPreferences m_editorPreferences = new EditorPreferences();
    private final DeltaUndoRedo m_deltaUndoRedo = new DeltaUndoRedo();
    private final IOriginator m_originator;
    private boolean m_isInPasteOperation;
    private boolean m_isUndo;
    private boolean m_isRedo;

    public EditableSourceViewWidget(Composite parent, boolean isReadOnly, IOriginator originator) {
        super(parent, isReadOnly);
        assert (originator != null) : "Parameter 'originator' of method 'EditableSourceViewWidget' must not be null";
        this.m_originator = originator;
    }

    public void setInPasteOperation(boolean inPasteOperation) {
        this.m_isInPasteOperation = inPasteOperation;
    }

    protected abstract IFormatter getFormatter(FormatterOptions var1);

    private void addListeners() {
        StyledText styledText = this.getSourceWidget();
        styledText.addVerifyListener((VerifyListener)this);
        styledText.addExtendedModifyListener((ExtendedModifyListener)this);
        styledText.addPaintListener((PaintListener)this);
        PreferencesUtility.getPreferences((String)EditorPreferences.getId()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private void removeListeners() {
        StyledText styledText = this.getSourceWidget();
        styledText.removeVerifyListener((VerifyListener)this);
        styledText.removeExtendedModifyListener((ExtendedModifyListener)this);
        styledText.removePaintListener((PaintListener)this);
        PreferencesUtility.getPreferences((String)EditorPreferences.getId()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    @Override
    protected final void sourceFileShown(FilePath sourceFile) {
        if (!this.isReadOnly()) {
            this.addListeners();
        }
        super.sourceFileShown(sourceFile);
    }

    @Override
    public final void clear() {
        if (!this.isReadOnly()) {
            this.removeListeners();
        }
        super.clear();
    }

    public final void clearUndoRedo() {
        this.m_deltaUndoRedo.clear();
    }

    private final List<String> getInvolvedLines(StyledText styledText, int firstSelectedLine, int lastSelectedLine) {
        assert (styledText != null) : "Parameter 'styledText' of method 'getInvolvedLines' must not be null";
        assert (firstSelectedLine >= 0) : "'firstSelectedLine' should be positive";
        assert (lastSelectedLine < styledText.getLineCount()) : "'lastSelectedLine' is out of range";
        assert (firstSelectedLine <= lastSelectedLine) : "Incorrect values for first and last selected lines";
        ArrayList<String> lines = new ArrayList<String>();
        int i = firstSelectedLine;
        while (i <= lastSelectedLine) {
            lines.add(SwtUtility.getLineWithLineBreak((StyledText)styledText, (int)i));
            ++i;
        }
        return lines;
    }

    public final void verifyText(VerifyEvent event) {
        boolean isPasteOperation;
        assert (event != null) : "Parameter 'event' of method 'verifyText' must not be null";
        event.text = StringUtility.harmonizeNewLineBreaks((String)event.text);
        IFormatter formatter = this.getFormatter(this.m_editorPreferences.getFormatterOptions());
        boolean bl = isPasteOperation = this.m_isInPasteOperation || event.text.length() > 1;
        if (!isPasteOperation && event.end == event.start && event.text.endsWith(StringUtility.DEFAULT_LINE_SEPARATOR)) {
            String text = this.getSourceWidget().getText();
            Pair indentationAfterNewline = formatter.getIndentationAfterNewline(text, event.start);
            String first = (String)indentationAfterNewline.getFirst();
            if (first != null && !first.isEmpty()) {
                event.text = event.text + first;
            }
        } else if (!isPasteOperation && event.end == event.start && "}".equals(event.text)) {
            String tabString = formatter.getTabString();
            int count = tabString.length();
            assert (count > 0) : "getTabString must not return empty String";
            if (event.start - count > 0 && this.getSourceWidget().getTextRange(event.start - count, count).equals(tabString)) {
                this.getSourceWidget().replaceTextRange(event.start - count, count, "}");
                event.doit = false;
                return;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("verifyText (modification): '" + StringUtility.showWhitespace((String)event.text) + "'");
        }
        this.setSyntaxHighlightMode(SyntaxHighlightMode.ON_MODIFY);
    }

    protected abstract void modified(EditableModifiableFile var1);

    public final void modifyText(ExtendedModifyEvent event) {
        assert (event != null) : "Parameter 'event' of method 'modifyText' must not be null";
        FilePath sourceFile = this.getSourceFile();
        assert (sourceFile != null && sourceFile instanceof EditableModifiableFile) : "Unexpected class in method 'modifyText': " + String.valueOf(sourceFile);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Modify text of '" + sourceFile.getIdentifyingPath() + "'");
        }
        if (this.m_isUndo) {
            this.m_deltaUndoRedo.pushRedo(event);
        } else {
            this.m_deltaUndoRedo.pushUndo(event);
            if (!this.m_isRedo) {
                this.m_deltaUndoRedo.clearRedo();
            }
            this.modified((EditableModifiableFile)sourceFile);
        }
    }

    private final String addBlockCommentsToLines(List<String> lines) {
        assert (lines != null) : "Parameter 'lines' of method 'addCommentsToLines' must not be null";
        StringBuilder contentToReplace = new StringBuilder();
        for (String line : lines) {
            String lineWithComment = "//" + line;
            contentToReplace.append(lineWithComment);
        }
        return contentToReplace.toString();
    }

    private final String removeBlockComments(List<String> lines) {
        assert (lines != null) : "Parameter 'lines' of method 'addBlockIndentationToLines' must not be null";
        StringBuilder contentToReplace = new StringBuilder();
        for (String line : lines) {
            if (!line.trim().startsWith("//") || line.length() < 3) continue;
            int index = line.indexOf("//");
            contentToReplace.append(line.substring(0, index));
            contentToReplace.append(line.substring(index + "//".length()));
        }
        return contentToReplace.toString();
    }

    private final String addBlockIndentationToLines(List<String> lines) {
        assert (lines != null && !lines.isEmpty()) : "Parameter 'lines' of method 'addBlockIndentationToLines' must not be empty";
        IFormatter formatter = this.getFormatter(this.m_editorPreferences.getFormatterOptions());
        StringBuilder contentToReplace = new StringBuilder();
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            String lineWithTabs = formatter.getTabString() + line;
            contentToReplace.append(lineWithTabs);
            ++i;
        }
        return contentToReplace.toString();
    }

    public final void handleOperation(Operation operation) {
        MultilineInformation multiLineInfo;
        String text;
        assert (operation != null) : "Parameter 'operation' of method 'handleOperation' must not be null";
        StyledText styledText = this.getSourceWidget();
        String contentToReplace = this.computeContentToReplace(operation, styledText, text = styledText.getText(), multiLineInfo = MultilineInformation.createMultiLineInformation(styledText, styledText.getSelectionRange()));
        if (contentToReplace == null) {
            return;
        }
        this.replaceContent(operation, styledText, multiLineInfo, text, contentToReplace);
    }

    private String computeContentToReplace(Operation operation, StyledText styledText, String fullText, MultilineInformation multiLineInfo) {
        Object contentToReplace;
        assert (operation != null) : "Parameter 'operation' of method 'computeContentToReplace' must not be null";
        assert (styledText != null) : "Parameter 'styledText' of method 'computeContentToReplace' must not be null";
        assert (fullText != null) : "Parameter 'fullText' of method 'computeContentToReplace' must not be null";
        assert (multiLineInfo != null) : "Parameter 'multiLineInfo' of method 'computeContentToReplace' must not be null";
        List<String> lines = this.getInvolvedLines(styledText, multiLineInfo.getFirstLine(), multiLineInfo.getLastLine());
        switch (operation) {
            case ADD_INDENTATION: {
                if (multiLineInfo.isSelectionInSingleLine()) {
                    boolean moveCaret = styledText.getSelectionCount() == 0;
                    String tabString = this.getFormatter(this.m_editorPreferences.getFormatterOptions()).getTabString();
                    styledText.insert(tabString);
                    if (moveCaret) {
                        styledText.setCaretOffset(styledText.getCaretOffset() + tabString.length());
                    }
                    return null;
                }
                contentToReplace = this.addBlockIndentationToLines(lines);
                break;
            }
            case REMOVE_INDENTATION: {
                contentToReplace = this.getFormatter(this.m_editorPreferences.getFormatterOptions()).removeBlockIndentation(lines);
                break;
            }
            case TOGGLE_BLOCK_COMMENT: {
                boolean removeComments = true;
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (trimmed.startsWith("//")) continue;
                    removeComments = false;
                }
                if (removeComments) {
                    contentToReplace = this.removeBlockComments(lines);
                    break;
                }
                contentToReplace = this.addBlockCommentsToLines(lines);
                break;
            }
            case REPLICATE_LINES: {
                StringBuilder builder = new StringBuilder();
                for (String line : lines) {
                    builder.append(line);
                }
                for (String line : lines) {
                    builder.append(line);
                }
                contentToReplace = builder.toString();
                break;
            }
            case DELETE_LINE: {
                contentToReplace = "";
                break;
            }
            case MOVE_LINES_UP: {
                if (multiLineInfo.getFirstLine() == 0) {
                    return null;
                }
                if (multiLineInfo.isEmptyEndLine()) {
                    String previousLine = styledText.getLine(multiLineInfo.getFirstLine() - 1);
                    String previousLineBreak = styledText.getText(multiLineInfo.getFirstOffsetOfPreviousLine() + previousLine.length(), multiLineInfo.getFirstOffsetOfFirstLine() - 1);
                    assert (StringUtility.DEFAULT_LINE_SEPARATOR.equals(previousLineBreak)) : "LineBreak expected";
                    contentToReplace = previousLineBreak + previousLine;
                    LOGGER.debug("UP from empty end: prev line \n{}", (Object)StringUtility.showWhitespace((String)(previousLine + previousLineBreak)));
                    break;
                }
                if (multiLineInfo.containsEndLine()) {
                    String previousLine = styledText.getLine(multiLineInfo.getFirstLine() - 1);
                    String previousLineBreak = styledText.getText(multiLineInfo.getFirstOffsetOfPreviousLine() + previousLine.length(), multiLineInfo.getFirstOffsetOfFirstLine() - 1);
                    String selection = styledText.getText(multiLineInfo.getFirstOffsetOfFirstLine(), styledText.getCharCount() - 1);
                    contentToReplace = selection + previousLineBreak + previousLine;
                    LOGGER.debug("UP from end: prev line \n{}", (Object)StringUtility.showWhitespace((String)(previousLine + previousLineBreak)));
                    LOGGER.debug("UP from end: selection \n{}", (Object)StringUtility.showWhitespace((String)selection));
                    break;
                }
                String previousLine = styledText.getText(multiLineInfo.getFirstOffsetOfPreviousLine(), multiLineInfo.getFirstOffsetOfFirstLine() - 1);
                String selectionWithLineBreak = styledText.getText(multiLineInfo.getFirstOffsetOfFirstLine(), styledText.getOffsetAtLine(multiLineInfo.getLastLine() + 1) - 1);
                contentToReplace = selectionWithLineBreak + previousLine;
                LOGGER.debug("UP from middle: prev line \n{}", (Object)StringUtility.showWhitespace((String)previousLine));
                LOGGER.debug("UP from middle: selection \n{}", (Object)StringUtility.showWhitespace((String)selectionWithLineBreak));
                break;
            }
            case MOVE_LINES_DOWN: {
                if (multiLineInfo.containsEndLine()) {
                    return null;
                }
                if (multiLineInfo.containsPenultimateLine()) {
                    String lastLineFeed = styledText.getText(multiLineInfo.getLastOffsetOfLastLine(), styledText.getOffsetAtLine(styledText.getLineCount() - 1) - 1);
                    assert (StringUtility.DEFAULT_LINE_SEPARATOR.equals(lastLineFeed)) : "Line break expected, but got '" + lastLineFeed + "'";
                    String nextLine = styledText.getLine(styledText.getLineCount() - 1) + lastLineFeed;
                    String selection = styledText.getTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), multiLineInfo.getSelectionLength());
                    contentToReplace = nextLine + selection;
                    LOGGER.debug("DOWN from penultimate: next line \n{}", (Object)StringUtility.showWhitespace((String)nextLine));
                    LOGGER.debug("DOWN from penultimate: selection \n{}", (Object)StringUtility.showWhitespace((String)selection));
                    break;
                }
                String nextLine = SwtUtility.getLineWithLineBreak((StyledText)styledText, (int)(multiLineInfo.getLastLine() + 1));
                String selection = styledText.getTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), multiLineInfo.getSelectionLength()) + SwtUtility.getLineBreak((StyledText)styledText, (int)multiLineInfo.getLastLine());
                contentToReplace = nextLine + selection;
                LOGGER.debug("DOWN from middle: next line \n{}", (Object)StringUtility.showWhitespace((String)nextLine));
                LOGGER.debug("DOWN from middle: selection \n{}", (Object)StringUtility.showWhitespace((String)selection));
                break;
            }
            case FORMAT_LINES: {
                IFormatter formatter = this.getFormatter(this.m_editorPreferences.getFormatterOptions());
                if (styledText.getSelectionCount() > 0) {
                    contentToReplace = formatter.format(StringUtility.concat(lines, (String)""));
                    break;
                }
                contentToReplace = formatter.format(fullText);
                break;
            }
            default: {
                assert (false) : "Unexpected value for 'blockIndentation' " + String.valueOf((Object)operation);
                contentToReplace = null;
            }
        }
        assert (contentToReplace != null) : "'contentToReplace' of method 'computeContentToReplace' must not be null";
        return contentToReplace;
    }

    private void selectLines(StyledText styledText, int first, int last) {
        assert (styledText != null) : "Parameter 'styledText' of method 'selectLines' must not be null";
        assert (first >= 0) : "Parameter 'first' of method 'selectLines' must be positive";
        assert (last >= first) : "Parameter 'last' of method 'selectLines' must be greater or equal first";
        int bottom = styledText.getLineCount() - 1;
        assert (last <= bottom) : "Parameter 'last' of method 'selectLines' must be lower line count";
        int start = 0;
        int end = 0;
        if (last < bottom) {
            start = styledText.getOffsetAtLine(first);
            end = styledText.getOffsetAtLine(last + 1);
        } else if (first < last) {
            start = styledText.getOffsetAtLine(first);
            end = styledText.getCharCount();
        } else if (styledText.getLine(bottom).isEmpty()) {
            end = start = styledText.getOffsetAtLine(last);
        } else {
            start = styledText.getOffsetAtLine(last);
            end = styledText.getCharCount();
        }
        styledText.setSelection(start, end);
        styledText.showSelection();
    }

    private void replaceContent(Operation operation, StyledText styledText, MultilineInformation multiLineInfo, String fullContent, String contentToReplace) {
        assert (operation != null) : "Parameter 'operation' of method 'replaceContent' must not be null";
        assert (styledText != null) : "Parameter 'styledText' of method 'replaceContent' must not be null";
        assert (multiLineInfo != null) : "Parameter 'multiLineInfo' of method 'replaceContent' must not be null";
        assert (fullContent != null) : "Parameter 'fullContent' of method 'replaceContent' must not be null";
        assert (contentToReplace != null) : "Parameter 'contentToReplace' of method 'replaceContent' must not be null";
        styledText.setRedraw(false);
        try {
            switch (operation) {
                case DELETE_LINE: {
                    if (styledText.getCharCount() != 0) {
                        if (multiLineInfo.isEmptyEndLine()) {
                            int length = multiLineInfo.getLastOffsetOfLastLine() - multiLineInfo.getLinefeedOffsetOfPreviousLine();
                            assert (length == 1 || length == 2) : "Expected length of 1 oder two, but got " + length;
                            styledText.replaceTextRange(multiLineInfo.getLinefeedOffsetOfPreviousLine(), length, "");
                        } else if (multiLineInfo.containsEndLine()) {
                            int linefeedOffset = multiLineInfo.getLinefeedOffsetOfPreviousLine();
                            int additionalChars = multiLineInfo.getFirstOffsetOfFirstLine() - linefeedOffset;
                            LOGGER.debug("DELETE with linefeed of previous line linefeedOffset {} firstOffset {} additionalChars {} charCount {}", new Object[]{linefeedOffset, multiLineInfo.getFirstOffsetOfFirstLine(), additionalChars, styledText.getCharCount()});
                            styledText.replaceTextRange(linefeedOffset, multiLineInfo.getSelectionLength() + additionalChars, "");
                        } else {
                            styledText.replaceTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), styledText.getOffsetAtLine(multiLineInfo.getLastLine() + 1) - multiLineInfo.getFirstOffsetOfFirstLine(), "");
                        }
                    }
                    this.setSyntaxHighlightMode(SyntaxHighlightMode.ON_MODIFY);
                    styledText.redrawRange(0, styledText.getCharCount(), false);
                    break;
                }
                case MOVE_LINES_UP: {
                    assert (multiLineInfo.getFirstLine() > 0) : "Cannot move lines up in the first line";
                    int offsetAtPreviousLine = multiLineInfo.getFirstOffsetOfPreviousLine();
                    styledText.replaceTextRange(offsetAtPreviousLine, contentToReplace.length(), contentToReplace);
                    this.selectLines(styledText, multiLineInfo.getFirstLine() - 1, multiLineInfo.getLastLine() - 1);
                    break;
                }
                case MOVE_LINES_DOWN: {
                    assert (!multiLineInfo.containsEndLine()) : "Cannot move lines down in the last line";
                    styledText.replaceTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), contentToReplace.length(), contentToReplace);
                    this.selectLines(styledText, multiLineInfo.getFirstLine() + 1, multiLineInfo.getLastLine() + 1);
                    break;
                }
                case FORMAT_LINES: {
                    if (styledText.getSelectionCount() > 0) {
                        int length = -multiLineInfo.getFirstOffsetOfFirstLine() + styledText.getOffsetAtLine(multiLineInfo.getLastLine()) + SwtUtility.getLineWithLineBreak((StyledText)styledText, (int)multiLineInfo.getLastLine()).length();
                        LOGGER.debug("FORMAT LINES offset {} length {} replace '{}'", new Object[]{multiLineInfo.getFirstOffsetOfFirstLine(), length, StringUtility.showWhitespace((String)contentToReplace)});
                        styledText.replaceTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), length, contentToReplace);
                        styledText.setSelectionRange(multiLineInfo.getFirstOffsetOfFirstLine(), contentToReplace.length());
                        break;
                    }
                    if (!fullContent.equals(contentToReplace)) {
                        int caretOffset = styledText.getCaretOffset();
                        styledText.replaceTextRange(0, styledText.getCharCount(), contentToReplace);
                        if (caretOffset > 0) {
                            IFormatter formatter = this.getFormatter(this.m_editorPreferences.getFormatterOptions());
                            int caretOffsetToSet = formatter.computeOffset(caretOffset, fullContent, contentToReplace);
                            styledText.setCaretOffset(caretOffsetToSet);
                        }
                    }
                    break;
                }
                case REPLICATE_LINES: {
                    String lastLineBreak = SwtUtility.getLineBreak((StyledText)styledText, (int)multiLineInfo.getLastLine());
                    styledText.replaceTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), multiLineInfo.getSelectionLength() + lastLineBreak.length(), contentToReplace);
                    int half = contentToReplace.length() / 2;
                    this.setCaretOffset(multiLineInfo.getFirstOffsetOfFirstLine() + half);
                    styledText.setSelectionRange(multiLineInfo.getFirstOffsetOfFirstLine() + half, half);
                    break;
                }
                default: {
                    String lastLineBreak = SwtUtility.getLineBreak((StyledText)styledText, (int)multiLineInfo.getLastLine());
                    styledText.replaceTextRange(multiLineInfo.getFirstOffsetOfFirstLine(), multiLineInfo.getSelectionLength() + lastLineBreak.length(), contentToReplace);
                    this.setCaretOffset(multiLineInfo.getFirstOffsetOfFirstLine());
                    styledText.setSelectionRange(multiLineInfo.getFirstOffsetOfFirstLine(), contentToReplace.length());
                    break;
                }
            }
        }
        finally {
            styledText.setRedraw(true);
        }
    }

    public final IOriginator getOriginator() {
        return this.m_originator;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        assert (event != null) : "Parameter 'event' of method 'preferenceChange' must not be null";
        if ("editor.showwhitespace".equals(event.getKey())) {
            this.getSourceWidget().redraw();
        }
        if (EditorPreferences.isKey(event.getKey())) {
            this.m_editorPreferences.refresh();
        }
    }

    private void drawString(StyledText styledText, GC gc, int offset, String text) {
        assert (styledText != null) : "Parameter 'styledText' of method 'drawString' must not be null";
        assert (gc != null) : "Parameter 'gc' of method 'drawString' must not be null";
        Point pt = styledText.getLocationAtOffset(offset);
        gc.drawString(text, pt.x, pt.y, true);
    }

    public void paintControl(PaintEvent event) {
        block25: {
            if (!this.m_editorPreferences.isShowWhiteSpace()) break block25;
            StyledText styledText = this.getSourceWidget();
            int firstVisibleLine = styledText.getTopIndex();
            int lastVisibleLine = JFaceTextUtil.getPartialBottomIndex((StyledText)styledText);
            GC gc = event.gc;
            int alpha = gc.getAlpha();
            gc.setAlpha(100);
            int i = firstVisibleLine;
            while (i <= lastVisibleLine) {
                block27: {
                    String lineBreak;
                    int startOffset = styledText.getOffsetAtLine(i);
                    String line = styledText.getLine(i);
                    int length = line.length();
                    int index = 0;
                    int offset = startOffset;
                    while (offset < startOffset + length) {
                        String nextChar;
                        switch (nextChar = line.substring(index, index + 1)) {
                            case " ": {
                                this.drawString(styledText, gc, offset, BLANK);
                                break;
                            }
                            case "\t": {
                                this.drawString(styledText, gc, offset, TAB);
                            }
                        }
                        ++offset;
                        ++index;
                    }
                    if (i >= styledText.getLineCount() - 1) break block27;
                    switch (lineBreak = SwtUtility.getLineBreak((StyledText)styledText, (int)i)) {
                        case "\r\n": {
                            this.drawString(styledText, gc, startOffset + length, CR_LF);
                            break;
                        }
                        case "\n": {
                            this.drawString(styledText, gc, startOffset + length, LF);
                            break;
                        }
                        case "\r": {
                            this.drawString(styledText, gc, startOffset + length, CR);
                        }
                    }
                }
                ++i;
            }
            gc.setAlpha(alpha);
        }
    }

    protected abstract IUndoRedoEntry createUndoRedoEntry();

    public final IUndoRedoEntry isUndoPossible() {
        if (this.m_deltaUndoRedo.hasUndo()) {
            return this.createUndoRedoEntry();
        }
        return null;
    }

    public final IUndoRedoEntry isRedoPossible() {
        if (this.m_deltaUndoRedo.hasRedo()) {
            return this.createUndoRedoEntry();
        }
        return null;
    }

    private void revertEvent(ExtendedModifyEvent undo) {
        assert (undo != null) : "Parameter 'undo' of method 'revertEvent' must not be null";
        this.getSourceWidget().replaceTextRange(undo.start, undo.length, undo.replacedText);
        this.getSourceWidget().setSelectionRange(undo.start, undo.replacedText.equals("") ? 0 : undo.replacedText.length());
    }

    public final void undo() {
        if (this.m_deltaUndoRedo.hasUndo()) {
            this.m_isUndo = true;
            this.revertEvent(this.m_deltaUndoRedo.popUndo());
            this.m_isUndo = false;
        }
    }

    public final void redo() {
        if (this.m_deltaUndoRedo.hasRedo()) {
            this.m_isRedo = true;
            this.revertEvent(this.m_deltaUndoRedo.popRedo());
            this.m_isRedo = false;
        }
    }

    private static final class DeltaUndoRedo {
        private final Stack<ExtendedModifyEvent> m_undo = new Stack();
        private final Stack<ExtendedModifyEvent> m_redo = new Stack();

        DeltaUndoRedo() {
        }

        void pushUndo(ExtendedModifyEvent delta) {
            this.m_undo.add(delta);
        }

        void pushRedo(ExtendedModifyEvent delta) {
            this.m_redo.add(delta);
        }

        ExtendedModifyEvent popUndo() {
            ExtendedModifyEvent res = this.m_undo.pop();
            return res;
        }

        ExtendedModifyEvent popRedo() {
            ExtendedModifyEvent res = this.m_redo.pop();
            return res;
        }

        void clear() {
            this.m_redo.clear();
            this.m_undo.clear();
        }

        void clearRedo() {
            this.m_redo.clear();
        }

        boolean hasUndo() {
            return !this.m_undo.isEmpty();
        }

        boolean hasRedo() {
            return !this.m_redo.isEmpty();
        }
    }

    public static enum Operation {
        ADD_INDENTATION,
        REMOVE_INDENTATION,
        TOGGLE_BLOCK_COMMENT,
        DELETE_LINE,
        REPLICATE_LINES,
        MOVE_LINES_UP,
        MOVE_LINES_DOWN,
        FORMAT_LINES;

    }
}

