/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.IAnalyzerPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ISonargraphPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.LazyPreferenceNode;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PageDescriptor;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PluginPreferenceNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;

public final class PreferencePageRegistry {
    private static final String EXTENSION_POINT = "com.hello2morrow.sonargraph.standalone.preferencePages";
    private static final String ELEMENT_PAGE = "page";
    private static final String ATTRIBUTE_PARENT_ID = "parentId";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_LABEL = "label";
    private static final String ATTRIBUTE_IMAGE = "image";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_FEATURE = "feature";
    private static final String ATTRIBUTE_IS_SOFTWARE_SYSTEM_BASED = "isSoftwareSystemBased";
    private static final String ATTRIBUTE_TARGET_PLATFORMS = "targetPlatforms";
    private static PreferencePageRegistry s_instance;
    private final IEclipseContext m_eclipseContext;
    private final List<PageDescriptor> m_pageDescriptors = new ArrayList<PageDescriptor>();

    private boolean matchesPlatform(String platforms) {
        assert (platforms != null && platforms.length() > 0) : "Parameter 'platforms' of method 'matchesPlatform' must not be empty";
        boolean matches = false;
        boolean hasAtLeastOneValidEntry = false;
        StringTokenizer tokenizer = new StringTokenizer(platforms, " ,");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken().trim().toUpperCase(Locale.US);
            if (nextToken.equals(TargetPlatform.WIN.name())) {
                hasAtLeastOneValidEntry = true;
                matches = Platform.isWindows();
            } else if (nextToken.equals(TargetPlatform.MAC.name())) {
                hasAtLeastOneValidEntry = true;
                matches = Platform.isMac();
            } else if (nextToken.equals(TargetPlatform.LINUX.name())) {
                hasAtLeastOneValidEntry = true;
                matches = Platform.isLinux();
            } else assert (false) : "Illegal target platform entry: " + nextToken;
            if (matches) break;
        }
        return !hasAtLeastOneValidEntry || matches;
    }

    private PreferencePageRegistry(IEclipseContext eclipseContext) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'PreferenceRegistry' must not be null";
        this.m_eclipseContext = eclipseContext;
        HashMap idToChildPageDescriptors = new HashMap();
        HashMap<String, PageDescriptor> idToPageDescriptor = new HashMap<String, PageDescriptor>();
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)this.m_eclipseContext.get(IExtensionRegistry.class);
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
        int n2 = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement nextConfigurationElement = iConfigurationElementArray[n3];
            String bundleId = nextConfigurationElement.getNamespaceIdentifier();
            if (nextConfigurationElement.getName().equals(ELEMENT_PAGE)) {
                String parentId = nextConfigurationElement.getAttribute(ATTRIBUTE_PARENT_ID);
                String id = nextConfigurationElement.getAttribute(ATTRIBUTE_ID);
                String label = nextConfigurationElement.getAttribute(ATTRIBUTE_LABEL);
                String image = nextConfigurationElement.getAttribute(ATTRIBUTE_IMAGE);
                String clazz = nextConfigurationElement.getAttribute(ATTRIBUTE_CLASS);
                String feature = nextConfigurationElement.getAttribute(ATTRIBUTE_FEATURE);
                String platforms = nextConfigurationElement.getAttribute(ATTRIBUTE_TARGET_PLATFORMS);
                if ((platforms == null || platforms.isEmpty() || this.matchesPlatform(platforms)) && (feature == null || feature.isEmpty() || CommandRegistry.getInstance().isFeatureAvailable(feature))) {
                    boolean isSoftwareSystemBased = Boolean.parseBoolean(nextConfigurationElement.getAttribute(ATTRIBUTE_IS_SOFTWARE_SYSTEM_BASED));
                    if (parentId == null) {
                        PageDescriptor pageDescriptor = new PageDescriptor(bundleId, id, label, image, clazz, isSoftwareSystemBased);
                        this.m_pageDescriptors.add(pageDescriptor);
                        PageDescriptor previous = idToPageDescriptor.put(id, pageDescriptor);
                        assert (previous == null) : "Parameter 'previous' of method 'PreferencePageRegistry' must be null";
                    } else {
                        assert (parentId != null && parentId.length() > 0) : "Parameter 'parentId' of method 'PreferencePageRegistry' must not be empty";
                        ArrayList<PageDescriptor> children = (ArrayList<PageDescriptor>)idToChildPageDescriptors.get(parentId);
                        if (children == null) {
                            children = new ArrayList<PageDescriptor>(5);
                            idToChildPageDescriptors.put(parentId, children);
                        }
                        PageDescriptor pageDescriptor = new PageDescriptor(bundleId, id, label, image, clazz, isSoftwareSystemBased);
                        children.add(pageDescriptor);
                        PageDescriptor previous = idToPageDescriptor.put(id, pageDescriptor);
                        assert (previous == null) : "Parameter 'previous' of method 'PreferencePageRegistry' must be null";
                    }
                }
            } else assert (false) : "Expected element: page";
            ++n3;
        }
        if (!idToChildPageDescriptors.isEmpty()) {
            for (Map.Entry nextEntry : idToChildPageDescriptors.entrySet()) {
                PageDescriptor parentPageDescriptor = (PageDescriptor)idToPageDescriptor.get(nextEntry.getKey());
                assert (parentPageDescriptor != null) : "Parameter 'parentPageDescriptor' of method 'PreferencePageRegistry' must not be null";
                for (PageDescriptor nextChildPageDescriptor : (List)nextEntry.getValue()) {
                    parentPageDescriptor.addChild(nextChildPageDescriptor);
                }
            }
        }
        Comparator<PageDescriptor> comparator = new Comparator<PageDescriptor>(){

            @Override
            public int compare(PageDescriptor pd1, PageDescriptor pd2) {
                if (!$assertionsDisabled && pd1 == null) {
                    throw new AssertionError((Object)"Parameter 'pd1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && pd2 == null) {
                    throw new AssertionError((Object)"Parameter 'pd2' of method 'compare' must not be null");
                }
                int compared = 0;
                compared = pd1.getBundleId().compareTo(pd2.getBundleId());
                if (compared == 0 && (compared = pd1.getLabel().compareTo(pd2.getLabel())) == 0) {
                    compared = pd1.getId().compareTo(pd2.getId());
                }
                return compared;
            }
        };
        this.m_pageDescriptors.sort(comparator);
        this.m_pageDescriptors.forEach(n -> n.sortChildren(comparator));
    }

    public static void createInstance(IEclipseContext eclipseContext) {
        assert (!PreferencePageRegistry.hasInstance()) : "Instance already created";
        s_instance = new PreferencePageRegistry(eclipseContext);
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static PreferencePageRegistry getInstance() {
        assert (PreferencePageRegistry.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        s_instance = null;
    }

    private void addChildren(IPreferenceNode node, PageDescriptor pageDescriptor) {
        assert (node != null) : "Parameter 'node' of method 'addChildren' must not be null";
        assert (pageDescriptor != null) : "Parameter 'pageDescriptor' of method 'addChildren' must not be null";
        for (PageDescriptor nextChildPageDescriptor : pageDescriptor.getChildren()) {
            LazyPreferenceNode nextChildNode = new LazyPreferenceNode(this.m_eclipseContext, nextChildPageDescriptor);
            node.add((IPreferenceNode)nextChildNode);
            this.addChildren(nextChildNode, nextChildPageDescriptor);
        }
    }

    private PreferenceManager getPreferenceManager(Set<Language> usedLanguages, boolean isSoftwareSystemBased, List<SonargraphPlugin> plugins) {
        PreferenceManager preferenceManager = new PreferenceManager();
        for (PageDescriptor nextDescriptor : this.m_pageDescriptors) {
            if (isSoftwareSystemBased != nextDescriptor.isSoftwareSystemBased()) continue;
            LazyPreferenceNode nextTopLevelNode = new LazyPreferenceNode(this.m_eclipseContext, nextDescriptor);
            if (isSoftwareSystemBased) {
                Language nextLanguage;
                nextTopLevelNode.createPage();
                IPreferencePage nextPage = nextTopLevelNode.getPage();
                if (nextPage instanceof ISonargraphPreferencePage && (nextLanguage = ((ISonargraphPreferencePage)nextPage).getLanguage()) != null && !usedLanguages.contains(nextLanguage)) {
                    nextTopLevelNode.disposeResources();
                    continue;
                }
                if (nextPage instanceof IAnalyzerPreferencePage) {
                    ((IAnalyzerPreferencePage)nextPage).setId(nextDescriptor.getId());
                }
            }
            preferenceManager.addToRoot((IPreferenceNode)nextTopLevelNode);
            this.addChildren(nextTopLevelNode, nextDescriptor);
        }
        if (!plugins.isEmpty()) {
            ArrayList<SonargraphPlugin> sortedPlugins = new ArrayList<SonargraphPlugin>(plugins);
            Comparator<SonargraphPlugin> comparator = new Comparator<SonargraphPlugin>(){

                @Override
                public int compare(SonargraphPlugin p1, SonargraphPlugin p2) {
                    if (!$assertionsDisabled && p1 == null) {
                        throw new AssertionError((Object)"Parameter 'p1' of method 'getPreferenceManager' must not be null");
                    }
                    if (!$assertionsDisabled && p2 == null) {
                        throw new AssertionError((Object)"Parameter 'p2' of method 'getPreferenceManager' must not be null");
                    }
                    return p1.getPresentationName().compareTo(p2.getPresentationName());
                }
            };
            sortedPlugins.sort(comparator);
            for (SonargraphPlugin next : sortedPlugins) {
                PluginPreferenceNode nextNode = new PluginPreferenceNode(next);
                nextNode.createPage();
                preferenceManager.addToRoot((IPreferenceNode)nextNode);
            }
        }
        return preferenceManager;
    }

    public PreferenceManager getInstallationPreferenceManager() {
        return this.getPreferenceManager(null, false, Collections.emptyList());
    }

    public PreferenceManager getSoftwareSystemPreferenceManager(Set<Language> usedLanguages, List<SonargraphPlugin> plugins) {
        return this.getPreferenceManager(usedLanguages, true, plugins);
    }

    static enum TargetPlatform {
        LINUX,
        MAC,
        WIN;

    }

    static enum Type {
        INSTALLATION,
        SOFTWARE_SYSTEM;

    }
}

