/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class NameAndDescriptionDialog
extends StandardDialog {
    private final ITextValidator m_nameValidator;
    private final String m_nameFieldLabel;
    private final boolean m_showDescriptionWidget;
    private String m_currentName;
    private String m_currentDescription;
    private boolean m_nameModified;
    private boolean m_descriptionModified;
    private boolean m_hasValidData;
    private ValidatingTextWidget m_validatingNameTextWidget;
    private ValidatingTextWidget m_validatingDescriptionTextWidget;
    private boolean m_isNameEditable = true;

    public NameAndDescriptionDialog(Shell parentShell, String title, String nameFieldLabel, ITextValidator nameValidator, String name, String description) {
        super(parentShell, title);
        assert (parentShell != null) : "Parameter 'parentShell' of method 'NameAndDescriptionDialog' must not be null";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'NameAndDescriptionDialog' must not be empty";
        assert (nameFieldLabel != null && nameFieldLabel.length() > 0) : "Parameter 'nameFieldLabel' of method 'NameAndDescriptionDialog' must not be empty";
        assert (nameValidator != null) : "Parameter 'nameValidator' of method 'NameAndDescriptionDialog' must not be null";
        assert (name != null) : "Parameter 'name' of method 'NameAndDescriptionDialog' must not be null";
        this.m_nameValidator = nameValidator;
        this.m_nameFieldLabel = nameFieldLabel;
        this.m_currentName = name;
        this.m_currentDescription = description;
        this.m_showDescriptionWidget = description != null;
    }

    public NameAndDescriptionDialog(Shell parentShell, String title, ITextValidator nameValidator, String name, String description, boolean isNameEditable) {
        this(parentShell, title, nameValidator, name, description);
        this.m_isNameEditable = isNameEditable;
    }

    public NameAndDescriptionDialog(Shell parentShell, String title, ITextValidator nameValidator, String name, String description) {
        this(parentShell, title, "Name", nameValidator, name, description);
    }

    public NameAndDescriptionDialog(Shell parentShell, String title, ITextValidator nameValidator) {
        this(parentShell, title, "Name", nameValidator, "", "");
    }

    public NameAndDescriptionDialog(Shell parentShell, String title, String nameFieldLabel, ITextValidator nameValidator, boolean showDescription) {
        this(parentShell, title, nameFieldLabel, nameValidator, "", showDescription ? "" : null);
    }

    public final boolean hasValidData() {
        return this.m_hasValidData;
    }

    protected void addWidgetsToDialogAreaBefore(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogArea' must not be null";
    }

    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogArea' must not be null";
    }

    protected final int getNumberOfColumns() {
        return 3;
    }

    protected void nameModified(String name) {
        assert (name != null) : "Parameter 'name' of method 'nameModified' must not be null";
    }

    protected void descriptionModified(String description) {
        assert (description != null) : "Parameter 'description' of method 'descriptionModified' must not be null";
    }

    protected final void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.addWidgetsToDialogAreaBefore(composite);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(this.m_nameFieldLabel + ":");
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_validatingNameTextWidget = new ValidatingTextWidget(composite, this.m_nameValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                NameAndDescriptionDialog.this.m_currentName = text;
                NameAndDescriptionDialog.this.m_nameModified = inputModified;
                NameAndDescriptionDialog.this.validate();
                if (NameAndDescriptionDialog.this.m_currentName != null) {
                    NameAndDescriptionDialog.this.nameModified(NameAndDescriptionDialog.this.m_currentName);
                }
            }
        }, this.m_currentName, 0);
        GridData gridDataText = new GridData(4, 0, true, false, 2, 1);
        gridDataText.widthHint = 280;
        this.m_validatingNameTextWidget.setLayoutData((Object)gridDataText);
        if (this.m_currentDescription != null) {
            Label descriptionLabel = new Label(composite, 0);
            descriptionLabel.setText("Description:");
            descriptionLabel.setLayoutData((Object)new GridData(1, Platform.isWindows() ? 128 : 0x1000000, false, false));
            this.m_validatingDescriptionTextWidget = new ValidatingTextWidget(composite, new ITextValidator(){

                public ValidationResult isValid(String currentInput, String newInput) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
            }, new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                    NameAndDescriptionDialog.this.m_currentDescription = text;
                    NameAndDescriptionDialog.this.m_descriptionModified = inputModified;
                    NameAndDescriptionDialog.this.validate();
                    if (NameAndDescriptionDialog.this.m_currentDescription != null) {
                        NameAndDescriptionDialog.this.descriptionModified(NameAndDescriptionDialog.this.m_currentDescription);
                    }
                }
            }, this.m_currentDescription, true, true, 0);
            GridData gridDataDescription = new GridData(4, 4, true, true, 2, 1);
            gridDataDescription.heightHint = 50;
            this.m_validatingDescriptionTextWidget.setLayoutData((Object)gridDataDescription);
        }
        this.addWidgetsToDialogAreaAfter(composite);
        if (this.m_isNameEditable) {
            this.m_validatingNameTextWidget.setFocus();
        } else {
            this.m_validatingNameTextWidget.setEnabled(false);
            this.m_validatingDescriptionTextWidget.setFocus();
        }
    }

    protected boolean validateAdditionalWidgets() {
        return true;
    }

    protected boolean additionalWidgetsModified() {
        return false;
    }

    protected final ValidatingTextWidget getTextWidget() {
        return this.m_validatingNameTextWidget;
    }

    protected final void validate() {
        this.m_hasValidData = this.m_currentName != null && (!this.m_showDescriptionWidget || this.m_currentDescription != null) && this.validateAdditionalWidgets();
        this.getButton(0).setEnabled(this.m_hasValidData && (this.m_nameModified || this.m_descriptionModified || this.additionalWidgetsModified()));
    }

    public final String getName() {
        assert (this.m_hasValidData) : "Not valid";
        return this.m_currentName;
    }

    public final String getDescription() {
        assert (this.m_hasValidData) : "Not valid";
        return this.m_currentDescription;
    }
}

