/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.ImportQualityModelCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadQualityModelCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ImportQualityModelSelector;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.QualityModelLoader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidatingPathComboWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class ImportQualityModelDialog
extends StandardDialog
implements ISelectionChangedListener,
SelectionListener,
ValidatingPathComboWidget.IConsumer {
    private static final String SETTINGS = "com.hello2morrow.sonargraph.standalone.qmImportHistory";
    private static final String RECENT_QMS = "recentQms";
    private static final int RECENT_QMS_LIMIT = 5;
    private final List<ResolvedQualityModelDescriptorFile> m_resolvedQMFileDescriptors;
    private final IPathValidator m_qualityModelValidator;
    private ImportQualityModel m_importQualityModel;
    private TFile m_currentlySelectedQualityModelSymbolicFile;
    private ValidatingPathComboWidget m_validatingPathWidgetQualityModel;
    private Button m_discardCurrentContentButton;
    private int m_defaultIndex;
    private List<String> m_recentQMS = new ArrayList<String>();
    private ImportQualityModelSelector m_qualityModelSelector;

    public ImportQualityModelDialog(Shell parent, ISoftwareSystemProvider softwareSystemProvider) {
        super(parent, "Import Quality Model");
        this.m_importQualityModel = new ImportQualityModel();
        this.m_qualityModelValidator = ImportQualityModelCommand.getImportQualityModelValidator((ISoftwareSystemProvider)softwareSystemProvider);
        List fileDescriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        this.m_resolvedQMFileDescriptors = QualityModelLoader.loadQualityModelFiles(fileDescriptors);
        int i = 0;
        while (i < this.m_resolvedQMFileDescriptors.size()) {
            Language qualityModelLanguage = this.m_resolvedQMFileDescriptors.get(i).getQualityModelFileDescriptor().getLanguage();
            if (qualityModelLanguage == null) {
                this.m_defaultIndex = i;
                break;
            }
            ++i;
        }
        this.m_currentlySelectedQualityModelSymbolicFile = this.m_resolvedQMFileDescriptors.get(this.m_defaultIndex).getQualityModelFileDescriptor().getSymbolicFile();
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)SETTINGS);
        this.m_recentQMS = PreferencesUtility.get((String)RECENT_QMS, (IEclipsePreferences)settings);
        for (ResolvedQualityModelDescriptorFile nextResolvedDescriptor : this.m_resolvedQMFileDescriptors) {
            String symbolicFilePath = nextResolvedDescriptor.getQualityModelFileDescriptor().getSymbolicFile().getPath();
            if (this.m_recentQMS.contains(symbolicFilePath)) continue;
            this.m_recentQMS.add(symbolicFilePath);
        }
    }

    protected void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        this.m_validatingPathWidgetQualityModel = new ValidatingPathComboWidget(composite, this, this.m_qualityModelValidator, 2, this.m_resolvedQMFileDescriptors.get(this.m_defaultIndex).getQualityModelFileDescriptor().getSymbolicFile(), true, null);
        this.m_validatingPathWidgetQualityModel.setFilterExtensions(new String[]{"*" + CoreFileType.QUALITY_MODEL.getDefaultExtension()});
        this.m_validatingPathWidgetQualityModel.setLayoutData(new GridData(4, 0, true, false));
        this.m_discardCurrentContentButton = new Button(composite, 32);
        this.m_discardCurrentContentButton.setText("Discard existing system files? This will remove all existing system files and import the selected ones!");
        this.m_discardCurrentContentButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_discardCurrentContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportQualityModelDialog.this.m_importQualityModel != null) {
                    ImportQualityModelDialog.this.m_importQualityModel.setDiscardCurrentContent(ImportQualityModelDialog.this.m_discardCurrentContentButton.getSelection());
                }
            }
        });
        this.m_qualityModelSelector = new ImportQualityModelSelector(composite, this.m_importQualityModel, this, this);
        this.m_qualityModelSelector.setLayoutData(new GridData(4, 4, true, true));
        this.setPath(this.m_currentlySelectedQualityModelSymbolicFile, true);
    }

    public boolean hasValidData() {
        if (this.m_importQualityModel == null) {
            return false;
        }
        return this.m_importQualityModel.hasContent();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.hasValidData());
        return control;
    }

    @Override
    public void setPath(TFile input, boolean inputModified) {
        this.m_importQualityModel = null;
        this.m_currentlySelectedQualityModelSymbolicFile = input;
        if (this.m_qualityModelValidator.isValid(null, this.m_currentlySelectedQualityModelSymbolicFile).isSuccess()) {
            this.loadCandidates();
            this.addToHistory(this.m_currentlySelectedQualityModelSymbolicFile.getPath());
            IEclipsePreferences settings = PreferencesUtility.getPreferences((String)SETTINGS);
            PreferencesUtility.put((String)RECENT_QMS, this.m_recentQMS, (IEclipsePreferences)settings);
            PreferencesUtility.save((IEclipsePreferences)settings);
            this.m_validatingPathWidgetQualityModel.setItems(this.m_recentQMS.toArray(new String[this.m_recentQMS.size()]));
            this.m_validatingPathWidgetQualityModel.setSelectedItem(this.m_recentQMS.size() - 1);
        } else {
            this.m_qualityModelSelector.clear();
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.hasValidData());
        }
    }

    private void loadCandidates() {
        TFile realFile = this.m_currentlySelectedQualityModelSymbolicFile;
        for (ResolvedQualityModelDescriptorFile nextResolvedDescriptor : this.m_resolvedQMFileDescriptors) {
            if (!this.m_currentlySelectedQualityModelSymbolicFile.getPath().equals(nextResolvedDescriptor.getQualityModelFileDescriptor().getSymbolicFile().getPath())) continue;
            realFile = nextResolvedDescriptor.getResolvedFile();
            break;
        }
        assert (realFile != null) : "Parameter 'realFile' of method 'loadCandidates' must not be null";
        LoadQualityModelCommand command = new LoadQualityModelCommand(WorkbenchRegistry.getInstance().getProvider(), realFile, false);
        command.runSynchronously();
        ImportQualityModel qualityModel = command.getImportQualityModel();
        this.m_importQualityModel = qualityModel != null ? qualityModel : new ImportQualityModel();
        assert (this.m_importQualityModel != null) : "Parameter 'm_qualityModel' of method 'loadCandidates' must not be null";
        this.m_qualityModelSelector.setInput(this.m_importQualityModel);
    }

    private void addToHistory(String newEntry) {
        ArrayList<String> historyList = new ArrayList<String>(this.m_recentQMS);
        historyList.remove(newEntry);
        historyList.add(historyList.size(), newEntry);
        if (historyList.size() > 5) {
            historyList.remove(1);
        }
        this.m_recentQMS = historyList;
    }

    public ImportQualityModel getQualityModel() {
        return this.m_importQualityModel;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.IMPORT_QUALITY_MODEL_DIALOG;
    }

    public void widgetSelected(SelectionEvent e) {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    protected Point getMinimumSize() {
        return new Point(620, 500);
    }

    protected Point getPreferredSize() {
        return new Point(620, 500);
    }
}

