/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.wizard.StandaloneWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

public abstract class ArchitectureBasedWizardAdapter
extends StandaloneWizardAdapter {
    public final SonargraphWizardAdapter.Category getCategory() {
        return SonargraphWizardAdapter.Category.ARCHITECTURE;
    }

    protected final DirectoryPath getDirectoryPath(ISoftwareSystemProvider provider, List<Element> selected) {
        Element element;
        assert (provider != null) : "Parameter 'provider' of method 'getDirectoryPath' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'getDirectoryPath' must not be null";
        if (selected.size() == 1 && (element = selected.get(0)) instanceof DirectoryPath && ((IArchitectureProvider)provider.getSoftwareSystem().getExtension(IArchitectureProvider.class)).isArchitectureFileDirectory((DirectoryPath)element)) {
            return (DirectoryPath)element;
        }
        return ((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getArchitecture();
    }

    public final boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'isEnabled' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'isEnabled' must not be null";
        if (this.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            return this.getDirectoryPath(provider, selected) != null;
        }
        return false;
    }

    public final boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        if (workbenchView.getViewId() == ViewId.FILES_VIEW) {
            Element element;
            if (selected.isEmpty()) {
                return true;
            }
            if (selected.size() == 1 && (element = selected.get(0)) instanceof DirectoryPath && ((IArchitectureProvider)provider.getSoftwareSystem().getExtension(IArchitectureProvider.class)).isArchitectureFileDirectory((DirectoryPath)element)) {
                return true;
            }
        } else if (workbenchView.getViewId() == ViewId.ARCHITECTURE_VIEW && selected.isEmpty()) {
            return true;
        }
        return false;
    }
}

