/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.GridData;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutManager;
import com.hello2morrow.draw2d.MouseListener;
import com.hello2morrow.draw2d.MouseMotionListener;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.GridPosition;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentAnchorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentBodyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentConnectorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentHeaderFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentInterfaceFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawContainerFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import java.util.List;
import org.eclipse.swt.graphics.Color;

final class UmlComponentFigure
extends DrawNodeFigure<UmlComponent> {
    private UmlComponentHeaderFigure m_header;
    private DrawContainerFigure m_interfaces;
    private UmlComponentBodyFigure m_body;
    private DrawContainerFigure m_connectors;
    private IUmlComponentFigureGridLayout m_gridLayout;
    private GridPosition m_gridPosition;
    private Color m_backgroundColor;

    UmlComponentFigure(UmlComponent component, DrawNodeFigure.INodeFigureProvider<UmlComponent> provider) {
        super((Object)component);
        this.initialize(provider);
    }

    protected void performInitialize(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'performInitialize' must not be null";
        this.setLayoutManager((LayoutManager)DrawUtilities.createGridLayout((int)3));
        DrawContainerFigure placeHolder1 = new DrawContainerFigure();
        this.add((IFigure)placeHolder1, new GridData(4, 4, false, false));
        placeHolder1.addMouseListener((MouseListener)this);
        this.m_header = new UmlComponentHeaderFigure(umlComponent, (MouseListener)this, (MouseMotionListener)this);
        this.add((IFigure)this.m_header, new GridData(4, 4, false, false));
        DrawContainerFigure placeHolder2 = new DrawContainerFigure();
        this.add((IFigure)placeHolder2, new GridData(4, 4, false, false));
        placeHolder2.addMouseListener((MouseListener)this);
        List interfaces = umlComponent.getChildren(UmlComponentInterface.class);
        this.m_interfaces = new DrawContainerFigure();
        this.m_interfaces.setLayoutManager((LayoutManager)DrawUtilities.createGridLayout((int)1, (int)0, (int)8, (int)0, (int)8, (boolean)true));
        this.add((IFigure)this.m_interfaces, new GridData(4, 4, false, false));
        if (!interfaces.isEmpty()) {
            for (UmlComponentInterface nextInterface : interfaces) {
                UmlComponentInterfaceFigure nextUmlInterfaceFigure = new UmlComponentInterfaceFigure(nextInterface);
                this.m_interfaces.add((IFigure)nextUmlInterfaceFigure, (Object)new GridData(4, 0x1000000, true, true));
                nextUmlInterfaceFigure.addMouseListener((MouseListener)this);
            }
        } else {
            this.m_interfaces.setMinimumSize(new Dimension(30, this.m_header.getPreferredSize().height));
            this.m_interfaces.setPreferredSize(new Dimension(30, this.m_header.getPreferredSize().height));
        }
        this.m_body = new UmlComponentBodyFigure(this.m_header.getPreferredSize());
        this.add((IFigure)this.m_body, new GridData(4, 4, true, true));
        List connectors = umlComponent.getChildren(UmlComponentConnector.class);
        this.m_connectors = new DrawContainerFigure();
        this.m_connectors.setLayoutManager((LayoutManager)DrawUtilities.createGridLayout((int)1, (int)0, (int)8, (int)0, (int)8, (boolean)true));
        this.add((IFigure)this.m_connectors, new GridData(4, 4, false, false));
        if (!connectors.isEmpty()) {
            for (UmlComponentConnector nextConnector : connectors) {
                UmlComponentConnectorFigure nextUmlConnectorFigure = new UmlComponentConnectorFigure(nextConnector);
                this.m_connectors.add((IFigure)nextUmlConnectorFigure, (Object)new GridData(4, 0x1000000, true, true));
                nextUmlConnectorFigure.addMouseListener((MouseListener)this);
            }
        } else {
            this.m_connectors.setMinimumSize(new Dimension(30, this.m_header.getPreferredSize().height));
            this.m_connectors.setPreferredSize(new Dimension(30, this.m_header.getPreferredSize().height));
        }
    }

    protected boolean performUpdate(UmlComponent umlComponent) {
        boolean nextUpdated;
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'performUpdate' must not be null";
        boolean updated = false;
        for (Object next : DrawUtilities.findChildFigures(UmlComponentAnchorFigure.class, (IFigure)this)) {
            nextUpdated = next.update();
            boolean bl = updated = updated || nextUpdated;
        }
        for (Object next : DrawUtilities.findChildFigures(UmlComponentDependencyFigure.class, (IFigure)this)) {
            nextUpdated = next.update();
            boolean bl = updated = updated || nextUpdated;
        }
        Color newColor = null;
        if (umlComponent.isSelected()) {
            newColor = UiResourceManager.getInstance().getSelectionColor();
        } else if (umlComponent.isHighlighted()) {
            newColor = UiResourceManager.getInstance().getHighlightColor();
        }
        if (newColor != this.m_backgroundColor) {
            this.m_backgroundColor = newColor;
            this.revalidate();
            this.repaint();
            updated = true;
        }
        for (UmlComponentFigure nextChildComponentFigure : DrawUtilities.findChildFigures(UmlComponentFigure.class, (IFigure)this)) {
            boolean nextUpdated2 = nextChildComponentFigure.performUpdate((UmlComponent)nextChildComponentFigure.getNode());
            boolean bl = updated = updated || nextUpdated2;
        }
        return updated;
    }

    protected void performPaintFigure(Graphics graphics, UmlComponent node) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        Rectangle rect = new Rectangle();
        rect.setLocation(this.m_header.getLocation());
        rect.union(this.m_header.getBounds());
        rect.union(this.m_body.getBounds());
        rect.resize(0, -1);
        graphics.setLineWidth(1);
        if (this.m_backgroundColor != null) {
            graphics.setBackgroundColor(this.m_backgroundColor);
            graphics.fillRectangle(rect);
        }
        graphics.drawRectangle(rect);
        graphics.drawLine(this.m_header.getBounds().getBottomLeft().getTranslated(0, -1), this.m_header.getBounds().getBottomRight().getTranslated(0, -1));
    }

    UmlComponentHeaderFigure getHeader() {
        assert (this.m_header != null) : "'m_header' of method 'getHeader' must not be null";
        return this.m_header;
    }

    UmlComponentBodyFigure getBody() {
        assert (this.m_body != null) : "'m_body' of method 'getBody' must not be null";
        return this.m_body;
    }

    public boolean containsPoint(int x, int y) {
        if (this.getHeader().containsPoint(x, y) || this.getBody().containsPoint(x, y)) {
            return true;
        }
        for (UmlComponentAnchorFigure next : DrawUtilities.findChildFigures(UmlComponentAnchorFigure.class, (IFigure)this)) {
            if (!next.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    UmlComponentAnchorFigure getAnchorFigure(UmlComponentAnchor<? extends ArchitectureElement> anchor) {
        assert (anchor != null) : "Parameter 'anchor' of method 'getAnchorFigure' must not be null";
        List found = DrawUtilities.findChildFigures(UmlComponentAnchorFigure.class, (IFigure)this.m_connectors, f -> ((UmlComponentAnchorFigure)((Object)f)).getUmlComponentAnchor() == anchor);
        if (found.size() == 1) {
            return (UmlComponentAnchorFigure)((Object)found.get(0));
        }
        found = DrawUtilities.findChildFigures(UmlComponentAnchorFigure.class, (IFigure)this.m_interfaces, f -> ((UmlComponentAnchorFigure)((Object)f)).getUmlComponentAnchor() == anchor);
        if (found.size() == 1) {
            return (UmlComponentAnchorFigure)((Object)found.get(0));
        }
        assert (false) : "Anchor not found: " + String.valueOf(anchor);
        return null;
    }

    UmlComponentConnectorFigure getConnectorFigure(UmlComponentConnector sourceConnector) {
        assert (sourceConnector != null) : "Parameter 'sourceConnector' of method 'getConnectorFigure' must not be null";
        List found = DrawUtilities.findChildFigures(UmlComponentConnectorFigure.class, (IFigure)this.m_connectors, f -> ((UmlComponentConnectorFigure)((Object)f)).getUmlComponentAnchor() == sourceConnector);
        assert (found.size() == 1) : "Exactly 1 match expected: " + String.valueOf(found);
        return (UmlComponentConnectorFigure)((Object)found.get(0));
    }

    UmlComponentInterfaceFigure getInterfaceFigure(UmlComponentInterface targetInterface) {
        assert (targetInterface != null) : "Parameter 'targetInterface' of method 'getInterfaceFigure' must not be null";
        List found = DrawUtilities.findChildFigures(UmlComponentInterfaceFigure.class, (IFigure)this.m_interfaces, f -> ((UmlComponentInterfaceFigure)((Object)f)).getUmlComponentAnchor() == targetInterface);
        assert (found.size() == 1) : "Exactly 1 match expected: " + String.valueOf(found);
        return (UmlComponentInterfaceFigure)((Object)found.get(0));
    }

    void setGridProsition(IUmlComponentFigureGridLayout gridLayout, GridPosition gridPosition) {
        assert (gridLayout != null) : "Parameter 'gridLayout' of method 'setGridProsition' must not be null";
        assert (gridPosition != null) : "Parameter 'gridPosition' of method 'setGridProsition' must not be null";
        this.m_gridLayout = gridLayout;
        this.m_gridPosition = gridPosition;
    }

    IUmlComponentFigureGridLayout getGridLayout() {
        assert (this.m_gridLayout != null) : "'m_gridLayout' of method 'getGridLayout' must not be null";
        return this.m_gridLayout;
    }

    GridPosition getGridPosition() {
        assert (this.m_gridPosition != null) : "'m_gridPosition' of method 'getGridPosition' must not be null";
        return this.m_gridPosition;
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(((UmlComponent)this.getNode()).getDebugInfo());
        builder.append("\n");
        builder.append(this.m_gridPosition == null ? "No grid position" : this.m_gridPosition);
        builder.append("\n");
        builder.append(super.getDebugInfo());
        return builder.toString();
    }
}

