/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.ArrowLocator;
import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.PolylineDecoration;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigureAnchor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import org.eclipse.swt.graphics.Color;

final class UmlComponentDependencyFigure
extends DrawConnectionFigure<UmlComponent.UmlComponentDependency> {
    UmlComponentDependencyFigure(UmlComponent.UmlComponentDependency dependency, DrawConnectionFigure.IConnectionFigureProvider<UmlComponent.UmlComponentDependency> provider, UmlComponentDependencyFigureAnchor source, UmlComponentDependencyFigureAnchor target, ConnectionRouter router) {
        super((Object)dependency);
        assert (dependency != null) : "Parameter 'dependency' of method 'UmlComponentDependencyFigure' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'UmlComponentDependencyFigure' must not be null";
        assert (source != null) : "Parameter 'source' of method 'UmlComponentDependencyFigure' must not be null";
        assert (target != null) : "Parameter 'target' of method 'UmlComponentDependencyFigure' must not be null";
        this.initialize(provider, source, target, router);
        if (dependency.getType() == UmlComponent.DependencyType.USES) {
            this.add((IFigure)new PolylineDecoration(), new ArrowLocator((Connection)this, 3));
        }
        this.setVisible(!dependency.isHidden());
        this.updateBounds();
    }

    private void updateBounds() {
        Rectangle rect = new Rectangle(this.getPoints().getBounds());
        rect.expand(3, 3);
        this.bounds = rect;
    }

    public UmlComponentDependencyFigureAnchor getSourceAnchor() {
        return (UmlComponentDependencyFigureAnchor)super.getSourceAnchor();
    }

    public UmlComponentDependencyFigureAnchor getTargetAnchor() {
        return (UmlComponentDependencyFigureAnchor)super.getTargetAnchor();
    }

    public void setPoints(PointList pointList) {
        assert (pointList != null) : "Parameter 'pointList' of method 'setPoints' must not be null";
        assert (pointList == this.getPoints()) : "Different instances";
        this.updateBounds();
        this.firePropertyChange("points", null, pointList);
        this.repaint();
    }

    private boolean childrenContainsPoint(int x, int y) {
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure nextChild = (IFigure)this.getChildren().get(i);
            if (nextChild.containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsPoint(int x, int y) {
        return this.getPoints().polylineContainsPoint(x, y, 2) || this.childrenContainsPoint(x, y);
    }

    protected void performPaintFigure(Graphics graphics, UmlComponent.UmlComponentDependency dependency) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'performPaintFigure' must not be null";
        Color initialFgColor = graphics.getForegroundColor();
        if (dependency.getType() == UmlComponent.DependencyType.USES) {
            graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY));
        } else {
            graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.VERY_VERY_LIGHT_GREY));
        }
        graphics.drawPolyline(this.getPoints());
        graphics.setForegroundColor(initialFgColor);
    }

    protected boolean performUpdate(UmlComponent.UmlComponentDependency dependency) {
        boolean visible;
        assert (dependency != null) : "Parameter 'dependency' of method 'performUpdate' must not be null";
        boolean bl = visible = !dependency.isHidden();
        if (this.isVisible() != visible) {
            this.setVisible(visible);
            return true;
        }
        return false;
    }
}

