/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.TransferCommand;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferArchitectureExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferRefactoringsExecutionInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TransferArchitectureWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TransferRefactoringsWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.jface.wizard.IWizardPage;

public final class TransferWizard
extends ArchitecturalViewWizard {
    private final TransferExecutionInfo m_info;

    public TransferWizard(TransferExecutionInfo info) {
        super("Transfer Architectural View");
        assert (info != null) : "Parameter 'info' of method 'TransferWizard' must not be null";
        this.m_info = info;
    }

    public int getPreferredWidth() {
        return 300;
    }

    public int getPreferredHeight() {
        return 300;
    }

    public int getMinimumWidth() {
        return 200;
    }

    public int getMinimumHeight() {
        return 200;
    }

    public void addPages() {
        TransferRefactoringsExecutionInfo refactoringsExecutionInfo;
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        TransferArchitectureExecutionInfo architectureExecutionInfo = this.m_info.getArchitectureExecutionInfo();
        if (architectureExecutionInfo != null) {
            TransferArchitectureWizardPage page = new TransferArchitectureWizardPage(architectureExecutionInfo);
            this.addPage((SonargraphWizardPage)page);
            String warningInfo = this.m_info.getWarningInfo();
            if (!warningInfo.isEmpty()) {
                page.setErrorMessage(warningInfo);
            }
        }
        if ((refactoringsExecutionInfo = this.m_info.getRefactoringsExecutionInfo()) != null) {
            this.addPage((SonargraphWizardPage)new TransferRefactoringsWizardPage(refactoringsExecutionInfo));
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.m_info.isTransferPossible();
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            TFile targetFile;
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            assert (this.m_info.isTransferPossible()) : "Transfer not possible: " + String.valueOf(this.m_info);
            TransferArchitectureExecutionInfo architectureExecutionInfo = this.m_info.getArchitectureExecutionInfo();
            if (architectureExecutionInfo != null && architectureExecutionInfo.transfer() && (targetFile = architectureExecutionInfo.getTargetFile()).exists() && UserInterfaceAdapter.getInstance().question("Architecture file '" + targetFile.getAbsolutePath() + " already exists!\n\nDo you want to overwrite the existing file?", false) == UserInterfaceAdapter.Feedback.DISAGREED) {
                SonargraphWizardPage page = this.getPage(TransferArchitectureWizardPage.NAME);
                assert (page != null) : "Parameter 'page' of method 'performFinish' must not be null";
                this.getContainer().showPage((IWizardPage)page);
                return false;
            }
            TransferCommand command = new TransferCommand(provider, new TransferCommand.ITransferInteraction(){

                public boolean collect(TransferCommand.TransferData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setTransferExecutionInfo(TransferWizard.this.m_info);
                    return true;
                }

                public void processTransferResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processGenerateArchitectureFileResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
            return true;
        }
        return false;
    }
}

