/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FocusPropertiesDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LayoutCreator;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

final class OpenOnDemandAdvancedDialog
extends FocusPropertiesDialog {
    private final List<Button> m_structureModeButtons = new ArrayList<Button>(2);
    private final List<ExplorationViewOnDemand> m_onDemand;
    private ExplorationViewOnDemand m_selectedOnDemand;
    private boolean m_useFocus;

    OpenOnDemandAdvancedDialog(Shell shell, ExplorationViewFocusProperties focusProperties, List<ExplorationViewOnDemand> onDemand) {
        super(shell, CoreDialogId.EXPLORATION_VIEW_OPEN_ON_DEMAND_ADVANCED.getPresentationName(), focusProperties);
        assert (onDemand != null && !onDemand.isEmpty()) : "Parameter 'onDemand' of method 'OpenOnDemandAdvancedDialog' must not be empty";
        this.m_onDemand = onDemand;
        this.m_selectedOnDemand = this.m_onDemand.get(0);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.EXPLORATION_VIEW_OPEN_ON_DEMAND_ADVANCED;
    }

    @Override
    protected void addFocusTypesWidgets(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addFocusTypesWidgets' must not be null";
        EnumSet types = this.getFocusProperties().getAvailableFocusTypes();
        assert (types != null && types.size() == 1 && types.contains(ExplorationViewFocusProperties.FocusType.SET_FOCUS)) : "'types' of method 'addFocusTypesWidgets' must contain only 'FocusType.SET_FOCUS'";
        if (this.m_onDemand.size() > 1) {
            Group group = new Group(composite, 32);
            group.setText("Structure Mode");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createGroupLayout(1));
            for (final ExplorationViewOnDemand next : this.m_onDemand) {
                Button nextButton = new Button((Composite)group, 16);
                nextButton.setText(next.getStructureMode().getPresentationName());
                nextButton.setData((Object)next);
                nextButton.setSelection(this.m_selectedOnDemand == next);
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        OpenOnDemandAdvancedDialog.this.m_selectedOnDemand = next;
                    }
                });
                nextButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
                this.m_structureModeButtons.add(nextButton);
            }
            Group modeGroup = new Group(composite, 32);
            modeGroup.setText("Open Mode");
            modeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            modeGroup.setLayout((Layout)LayoutCreator.createGroupLayout(1));
            Button selectAndRevealButton = new Button((Composite)modeGroup, 16);
            selectAndRevealButton.setText("Select and Reveal");
            selectAndRevealButton.setSelection(true);
            selectAndRevealButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OpenOnDemandAdvancedDialog.this.enableFocus(false);
                    OpenOnDemandAdvancedDialog.this.m_useFocus = false;
                }
            });
            selectAndRevealButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            Button focusButton = new Button((Composite)modeGroup, 16);
            focusButton.setText("Focus");
            focusButton.setSelection(false);
            focusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OpenOnDemandAdvancedDialog.this.enableFocus(true);
                    OpenOnDemandAdvancedDialog.this.m_useFocus = true;
                }
            });
            focusButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            this.m_useFocus = false;
        } else {
            this.m_useFocus = true;
        }
    }

    @Override
    protected void applyData() {
        super.applyData();
        this.enableFocus(this.m_onDemand.size() == 1);
    }

    @Override
    protected IEclipsePreferences saveData() {
        return super.saveData();
    }

    ExplorationViewOnDemand getSelectedOnDemand() {
        return this.m_selectedOnDemand;
    }

    boolean useFocus() {
        return this.m_useFocus;
    }
}

