/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.NewArchitecturalViewWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ExplorationViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class NewArchitecturalViewWizard
extends ArchitecturalViewWizard {
    private final ArchitecturalViewFile m_baseOn;
    private final boolean m_openArchitecturalViewIsPossible;
    private NewArchitecturalViewWizardPage m_page;

    public NewArchitecturalViewWizard(ArchitecturalViewFile basedOn, boolean openArchitecturalViewIsPossible) {
        super("New Architectural View");
        this.m_baseOn = basedOn;
        this.m_openArchitecturalViewIsPossible = openArchitecturalViewIsPossible;
    }

    public int getPreferredHeight() {
        return super.getPreferredHeight() + 100;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        this.m_page = new NewArchitecturalViewWizardPage(((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewNameValidator(), ((Files)softwareSystem.getUniqueExistingChild(Files.class)).getArchitecturalViews(), this.m_baseOn, this.m_openArchitecturalViewIsPossible);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            final CreateArchitecturalViewInteraction interaction = new CreateArchitecturalViewInteraction();
            CreateArchitecturalViewCommand createCommand = new CreateArchitecturalViewCommand(provider, (CreateArchitecturalViewCommand.ICreateArchitecturalViewInteraction)interaction);
            UserInterfaceAdapter.getInstance().run((Command)createCommand, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    OperationResultWithOutcome<ArchitecturalViewFile> result;
                    if (exception == null && NewArchitecturalViewWizard.this.m_page.openView() && (result = interaction.getResult()) != null && result.isSuccess()) {
                        ArchitecturalViewFile file = (ArchitecturalViewFile)result.getOutcome();
                        if (!$assertionsDisabled && file == null) {
                            throw new AssertionError((Object)"'file' of method 'consume' must not be null");
                        }
                        ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.EXPLORATION_VIEW, (String)file.getIdentifyingPath(), Collections.singletonList(new ExplorationViewShowInViewRequest(ExplorationViewShowInViewRequest.Type.ARCHITECTURAL_VIEW, null, null)), Collections.singletonList(file), (boolean)false);
                    }
                    super.consume(exception);
                }
            });
            return true;
        }
        return false;
    }

    final class CreateArchitecturalViewInteraction
    implements CreateArchitecturalViewCommand.ICreateArchitecturalViewInteraction {
        private OperationResultWithOutcome<ArchitecturalViewFile> m_result;

        CreateArchitecturalViewInteraction() {
        }

        public void processCreateArchitecturalViewResult(OperationResultWithOutcome<ArchitecturalViewFile> result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateArchitecturalViewResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
            this.m_result = result;
        }

        public boolean collect(CreateArchitecturalViewCommand.CreateArchitecturalViewData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (NewArchitecturalViewWizard.this.m_page != null) : "Parameter 'm_page' of method 'collect' must not be null";
            ArchitecturalViewFile basedOn = NewArchitecturalViewWizard.this.m_page.getBasedOn();
            if (basedOn != null) {
                data.setData(NewArchitecturalViewWizard.this.m_page.getElementName(), NewArchitecturalViewWizard.this.m_page.getElementDescription(), basedOn);
            } else {
                data.setData(NewArchitecturalViewWizard.this.m_page.getElementName(), NewArchitecturalViewWizard.this.m_page.getElementDescription(), NewArchitecturalViewWizard.this.m_page.getStructureMode());
            }
            return true;
        }

        OperationResultWithOutcome<ArchitecturalViewFile> getResult() {
            return this.m_result;
        }
    }
}

