/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ElementsData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.HideElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class HideElementsHandler
extends ArchitecturalViewHandler {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> elements, String defaultLabel) {
                if (!$assertionsDisabled && elements == null) {
                    throw new AssertionError((Object)"Parameter 'elements' of method 'getLabel' must not be null");
                }
                return elements.size() == 1 ? "Hide Element" : "Hide Elements";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.OTHER;
            }
        };
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.HIDE_ARCHITECTURAL_VIEW_ELEMENTS;
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        List elements;
        if (this.mayBeExecuted(selection) && !(elements = HideElementsHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, (List)selection.getElements())).isEmpty()) {
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isHideElementsPossible(elements);
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        final List elements = HideElementsHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, (List)selection.getElements());
        HideElementsCommand command = new HideElementsCommand(WorkbenchRegistry.getInstance().getProvider(), new HideElementsCommand.IHideElementsInteraction(){

            public boolean collect(ElementsData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setElements(elements);
                return true;
            }

            public void processHideElementsResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processHideElementsResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

