/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ApplyFocusOperationCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FocusDialog;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public abstract class FocusOperationHandler
extends ArchitecturalViewHandler {
    public final ICommandId getCorrespondingCommandId() {
        return CoreCommandId.APPLY_ARCHITECTURAL_VIEW_FOCUS_OPERATION;
    }

    @Override
    protected boolean mayBeExecutedInView(IViewId viewId) {
        return viewId == ViewId.EXPLORATION_VIEW || viewId == ViewId.ARCHITECTURAL_FINDINGS_VIEW;
    }

    protected abstract ExplorationViewFocusProperties.FocusType getOperation();

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                return FocusOperationHandler.this.getOperation().getPresentationName() + (FocusOperationHandler.this.getOperation().supportUserInteraction() ? "..." : "");
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.FOCUS;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.mayBeExecuted(selection)) {
            List findings = FocusOperationHandler.getMultipleSelection(ArchitecturalViewFinding.class, (List)selection.getElements());
            List nodes = FocusOperationHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
            List dependencies = FocusOperationHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
            return ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isApplyFocusPossible(this.getOperation(), nodes, dependencies, findings) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        List findings = FocusOperationHandler.getMultipleSelection(ArchitecturalViewFinding.class, (List)selection.getElements());
        List nodes = FocusOperationHandler.getMultipleSelection(ArchitecturalViewNode.class, (List)selection.getElements());
        List dependencies = FocusOperationHandler.getMultipleSelection(ArchitecturalViewNode.ArchitecturalViewDependency.class, (List)selection.getElements());
        final ExplorationViewFocusRequest request = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isApplyFocusPossible(this.getOperation(), nodes, dependencies, findings);
        assert (request != null) : "'request' of method 'execute' must not be null";
        ApplyFocusOperationCommand command = new ApplyFocusOperationCommand(WorkbenchRegistry.getInstance().getProvider(), new ApplyFocusOperationCommand.IApplyFocusOperationInteraction(){

            public boolean collect(ApplyFocusOperationCommand.FocusOperationtData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.set(FocusOperationHandler.this.getOperation(), request);
                return true;
            }

            public void processApplyResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processApplyResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean collect(final ExplorationViewFocusProperties properties) {
                if (!$assertionsDisabled && properties == null) {
                    throw new AssertionError((Object)"Parameter 'properties' of method 'collect' must not be null");
                }
                RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                    public void run() {
                        FocusDialog dialog = new FocusDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), properties);
                        if (dialog.open() == 0) {
                            this.setResult(Boolean.TRUE);
                        } else {
                            this.setResult(Boolean.FALSE);
                        }
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                return (Boolean)runnable.getResult();
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

