/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PrimaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureRouter;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import java.util.List;

final class ExplorationViewLayout
extends DrawNodeAndConnectionFigureCanvasLayout<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency> {
    private static final int NODE_INDETATION_OFFSET_X = 16;
    private static final int NODE_POSITIONING_OFFSET_Y = 6;
    private static final int ROW_HEIGHT = 22;
    private static final int MIN_WIDTH_ARCS_WITH_SPACE_LIMIT = 32;
    private static final int DISTANCE_PRIMARY_NODES_AND_LEFT_ARCS = 4;
    private static final int RIGHT_BORDER = 6;
    private final TreeEdgeFigureRouter m_router = new TreeEdgeFigureRouter();

    ExplorationViewLayout() {
    }

    int getRowHeight() {
        return 22;
    }

    int getNodeIndentationOffsetX() {
        return 16;
    }

    TreeEdgeFigureRouter getEdgeFigureRouter() {
        return this.m_router;
    }

    private static double getPercentage(int part, int total) {
        assert (total >= part) : "Total is less than part";
        if (total == 0 || part == 0) {
            return 0.0;
        }
        return 100.0 / (double)total * (double)part;
    }

    private static int getPart(double percentage, int total) {
        assert (percentage >= 0.0) : "'percentage' must not be negative";
        assert (total > 0) : "'total' must not be negative";
        if (percentage == 0.0) {
            return 0;
        }
        if (percentage >= 100.0) {
            return total;
        }
        return (int)((double)total * (percentage / 100.0));
    }

    protected boolean needsLayoutOnZoom() {
        return true;
    }

    protected boolean needsLayoutOnResize() {
        return true;
    }

    private int scale(int toBeScaled, double scale) {
        if (toBeScaled == 0) {
            return 0;
        }
        if (scale == 1.0) {
            return toBeScaled;
        }
        return (int)Math.ceil(scale * (double)toBeScaled);
    }

    private int descale(int toBeScaled, double scale) {
        if (toBeScaled == 0) {
            return 0;
        }
        if (scale == 1.0) {
            return toBeScaled;
        }
        return (int)Math.ceil((double)toBeScaled / scale);
    }

    protected void calculateSizeAndScale(List<DrawNodeFigure<ArchitecturalViewNode>> nodeFigures, List<DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency>> edgeFigures, DrawNodeAndConnectionFigureCanvasLayout.SizeAndScale sizeAndScale, DrawCache cache) {
        int rightArcsWidthAsHalfCircle;
        int leftArcsWidthAsHalfCircle;
        assert (nodeFigures != null && !nodeFigures.isEmpty()) : "Parameter 'nodeFigures' of method 'calculateSizeAndScale' must not be empty";
        assert (edgeFigures != null) : "Parameter 'edgeFigures' of method 'calculateSizeAndScale' must not be null";
        assert (sizeAndScale != null) : "Parameter 'sizeAndScale' of method 'calculateSizeAndScale' must not be null";
        double scale = sizeAndScale.getScale();
        assert (scale >= 1.0) : "Unexpected 'scale': " + scale;
        if (edgeFigures.isEmpty()) {
            leftArcsWidthAsHalfCircle = 0;
            rightArcsWidthAsHalfCircle = 0;
        } else {
            int maxIndexDiffLeft = 0;
            int maxIndexDiffRight = 0;
            int weightLeft = 0;
            int weightRight = 0;
            int weightFullArc = -1;
            for (DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency> nextEdgeFigure : edgeFigures) {
                int nextDiff;
                assert (nextEdgeFigure != null && nextEdgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'calculateSizeAndScale': " + String.valueOf(nextEdgeFigure);
                TreeEdgeFigure nextTreeEdgeFigure = (TreeEdgeFigure)nextEdgeFigure;
                int nextFromNodeIndex = nextTreeEdgeFigure.getFromNodeIndex();
                int nextToNodeIndex = nextTreeEdgeFigure.getToNodeIndex();
                int nextWeight = nextTreeEdgeFigure.getWeight();
                if (nextFromNodeIndex < nextToNodeIndex) {
                    nextDiff = nextToNodeIndex - nextFromNodeIndex;
                    if (maxIndexDiffLeft < nextDiff) {
                        maxIndexDiffLeft = nextDiff;
                        weightLeft = nextWeight;
                        continue;
                    }
                    if (maxIndexDiffLeft != nextDiff || weightLeft >= nextWeight) continue;
                    weightLeft = nextWeight;
                    continue;
                }
                if (nextFromNodeIndex > nextToNodeIndex) {
                    nextDiff = nextFromNodeIndex - nextToNodeIndex;
                    if (maxIndexDiffRight < nextDiff) {
                        maxIndexDiffRight = nextDiff;
                        weightRight = nextWeight;
                        continue;
                    }
                    if (maxIndexDiffRight != nextDiff || weightRight >= nextWeight) continue;
                    weightRight = nextWeight;
                    continue;
                }
                if (weightFullArc == -1) {
                    weightFullArc = 0;
                }
                weightFullArc = Math.max(weightFullArc, nextWeight);
            }
            leftArcsWidthAsHalfCircle = maxIndexDiffLeft > 0 ? TreeEdgeFigure.getNeededArcWidthBeingCircle(maxIndexDiffLeft * 22, weightLeft) : 0;
            rightArcsWidthAsHalfCircle = maxIndexDiffRight > 0 ? TreeEdgeFigure.getNeededArcWidthBeingCircle(maxIndexDiffRight * 22, weightRight) : 0;
        }
        int height = 6;
        int primaryNodesWidth = 0;
        for (DrawNodeFigure<ArchitecturalViewNode> nextNode : nodeFigures) {
            if (nextNode instanceof PrimaryTreeNodeFigure) {
                height += 22;
                PrimaryTreeNodeFigure nextPrimaryNode = (PrimaryTreeNodeFigure)nextNode;
                int nextPrimaryNodeWidth = nextPrimaryNode.getPreferredSize().width + ((ArchitecturalViewNode)nextPrimaryNode.getSecondaryTreeNode().getNode()).getDepth() * 16;
                primaryNodesWidth = Math.max(primaryNodesWidth, nextPrimaryNodeWidth);
                continue;
            }
            assert (nextNode instanceof SecondaryTreeNodeFigure) : "Unexpected class: " + String.valueOf(nextNode);
            SecondaryTreeNodeFigure nextSecondaryNode = (SecondaryTreeNodeFigure)nextNode;
            nextSecondaryNode.setVisible(((ArchitecturalViewNode)nextSecondaryNode.getNode()).hasDependencies());
        }
        int widthScaled = this.scale(primaryNodesWidth, scale) + 4 + this.scale(leftArcsWidthAsHalfCircle, scale) + (rightArcsWidthAsHalfCircle == 0 ? this.scale(8, scale) : this.scale(rightArcsWidthAsHalfCircle, scale)) + 6;
        int width = (primaryNodesWidth += 4) + leftArcsWidthAsHalfCircle + (rightArcsWidthAsHalfCircle == 0 ? 8 : rightArcsWidthAsHalfCircle) + 6;
        int widthDelta = sizeAndScale.getAvailableSize().width - widthScaled;
        if (widthDelta >= 0) {
            sizeAndScale.setSize(new Dimension(width, height));
            int secondaryNodesPosX = primaryNodesWidth + leftArcsWidthAsHalfCircle - 8;
            this.m_router.set(-1, rightArcsWidthAsHalfCircle > 0 ? -1 : -2, secondaryNodesPosX);
        } else if (rightArcsWidthAsHalfCircle == 0) {
            int arcSpaceLeft = Math.max(leftArcsWidthAsHalfCircle + this.descale(widthDelta, scale), 32);
            sizeAndScale.setSize(new Dimension(primaryNodesWidth + arcSpaceLeft + 8 + 6, height));
            int secondaryNodesPosX = primaryNodesWidth + arcSpaceLeft - 8;
            this.m_router.set(arcSpaceLeft, -2, secondaryNodesPosX);
        } else {
            int availableWidthForArcs = Math.max(leftArcsWidthAsHalfCircle + rightArcsWidthAsHalfCircle + this.descale(widthDelta, scale), 64);
            int totalRequiredArcsWidth = leftArcsWidthAsHalfCircle + rightArcsWidthAsHalfCircle;
            double percentageLeft = ExplorationViewLayout.getPercentage(leftArcsWidthAsHalfCircle, totalRequiredArcsWidth);
            int arcSpaceLeft = ExplorationViewLayout.getPart(percentageLeft, availableWidthForArcs);
            double percentageRight = ExplorationViewLayout.getPercentage(rightArcsWidthAsHalfCircle, totalRequiredArcsWidth);
            int arcSpaceRight = ExplorationViewLayout.getPart(percentageRight, availableWidthForArcs);
            sizeAndScale.setSize(new Dimension(primaryNodesWidth + arcSpaceLeft + arcSpaceRight + 6, height));
            int secondaryNodesPosX = primaryNodesWidth + arcSpaceLeft - 8;
            this.m_router.set(arcSpaceLeft, arcSpaceRight, secondaryNodesPosX);
        }
    }

    protected void layout(List<DrawNodeFigure<ArchitecturalViewNode>> nodes, List<DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency>> edges, DrawCache cache) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'layout' must not be empty";
        assert (edges != null) : "Parameter 'edges' of method 'layout' must not be null";
        int secondaryNodeFiguresPosX = this.m_router.getSecondaryNodesPosX();
        int posY = 6;
        for (DrawNodeFigure<ArchitecturalViewNode> nextNode : nodes) {
            if (nextNode instanceof PrimaryTreeNodeFigure) {
                PrimaryTreeNodeFigure nextPrimaryTreeNode = (PrimaryTreeNodeFigure)nextNode;
                int nextPosX = ((ArchitecturalViewNode)nextPrimaryTreeNode.getSecondaryTreeNode().getNode()).getDepth() * 16;
                Dimension nextPreferredSize = nextPrimaryTreeNode.getPreferredSize();
                Rectangle nextBounds = Rectangle.SINGLETON;
                nextBounds.x = nextPosX;
                nextBounds.y = posY;
                nextBounds.width = nextPreferredSize.width;
                nextBounds.height = nextPreferredSize.height;
                nextPrimaryTreeNode.setBounds(nextBounds);
                continue;
            }
            assert (nextNode instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'layout': " + String.valueOf(nextNode);
            SecondaryTreeNodeFigure nextSecundaryTreeNode = (SecondaryTreeNodeFigure)nextNode;
            Dimension nextPreferredSize = nextSecundaryTreeNode.getPreferredSize();
            Rectangle nextBounds = Rectangle.SINGLETON;
            nextBounds.width = nextPreferredSize.width;
            nextBounds.height = nextPreferredSize.height;
            nextBounds.x = secondaryNodeFiguresPosX;
            nextBounds.y = posY;
            nextSecundaryTreeNode.setBounds(nextBounds);
            posY += 22;
        }
    }
}

