/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CalculateMetricsCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetric;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetrics;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationView;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewMetricBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CancellableUiWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public final class ExplorationMetricsView
extends WorkbenchAuxiliaryView {
    private PropertyTableViewer<ExplorationViewMetric> m_metricsViewer;
    private CancellableUiWorkerContext m_currentWorkerContext;
    private CalculateMetricsCommand m_currentCommand;
    private int m_lastTopIndex = -1;

    public IViewId getViewId() {
        return ViewId.EXPLORATION_METRICS_VIEW;
    }

    protected boolean supportsSleep() {
        return false;
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }

    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        return view.getViewId() == ViewId.EXPLORATION_VIEW;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_metricsViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new ExplorationViewMetricBeanAdapter(), PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_metricsViewer.addColumn("Metric", "name", null, "image", 70, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricsViewer.addColumn("Value", "value", null, null, 30, PropertyTableViewer.ColumnType.NUMBER);
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewUnloadedEvent>(ArchitecturalViewUnloadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ExplorationMetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystem system = ExplorationMetricsView.this.getSoftwareSystem();
                    if (system != null && !((IArchitecturalViewProvider)system.getExtension(IArchitecturalViewProvider.class)).hasLoadedArchitecturalViews(true)) {
                        ExplorationMetricsView.this.hideView();
                    } else {
                        IExplorationViewRepresentationOwner owner;
                        WorkbenchView connectedView = ExplorationMetricsView.this.getConnectedView();
                        if (connectedView instanceof ExplorationView && (owner = ((ExplorationView)connectedView).getOwner()) == event.getOwner()) {
                            ExplorationMetricsView.this.cancelCollect(false);
                        }
                    }
                }
            }
        });
    }

    private void collect(final List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'collect' must not be empty";
        assert (this.m_currentWorkerContext == null) : "'m_currentWorkerContext' of method 'collect' must be null";
        assert (this.m_currentCommand == null) : " 'm_currentCommand' of method 'collect' must be null";
        this.m_metricsViewer.setAdditionalFirstColumnInfo("Calculating...");
        this.m_metricsViewer.showData(Collections.emptyList());
        final CalculateMetricsCommand command = new CalculateMetricsCommand(this.getSoftwareSystemProvider(), new CalculateMetricsCommand.IInteraction(){

            public boolean collect(CalculateMetricsCommand.Data data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(elements);
                return true;
            }
        });
        assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
        this.m_currentCommand = command;
        this.m_currentWorkerContext = new CancellableUiWorkerContext(this.m_metricsViewer.getDisplay());
        UserInterfaceAdapter.getInstance().run((Command)command, (IWorkerContext)this.m_currentWorkerContext, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                if (ExplorationMetricsView.this.m_currentCommand == command && ExplorationMetricsView.this.m_metricsViewer != null && !ExplorationMetricsView.this.m_metricsViewer.isDisposed()) {
                    Table table = ExplorationMetricsView.this.m_metricsViewer.getTable();
                    table.setRedraw(false);
                    boolean reset = true;
                    ExplorationViewMetrics metrics = ExplorationMetricsView.this.m_currentCommand.getMetrics();
                    if (exception == null && metrics != null) {
                        ExplorationMetricsView.this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
                        ExplorationMetricsView.this.m_metricsViewer.showData((Collection)metrics.getMetrics());
                        if (ExplorationMetricsView.this.m_lastTopIndex != -1 && table.getItemCount() > ExplorationMetricsView.this.m_lastTopIndex) {
                            table.setTopIndex(ExplorationMetricsView.this.m_lastTopIndex);
                        }
                        ExplorationMetricsView.this.setTitleTooltip(metrics.getInfo());
                        WorkbenchView connectedTo = ExplorationMetricsView.this.getConnectedView();
                        if (connectedTo != null) {
                            ExplorationMetricsView.this.setPartName(connectedTo.getPresentationName());
                        }
                        reset = false;
                    }
                    if (reset) {
                        ExplorationMetricsView.this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
                        ExplorationMetricsView.this.m_metricsViewer.showData(Collections.emptyList());
                        ExplorationMetricsView.this.setTitleTooltip("No metrics available for selection");
                        ExplorationMetricsView.this.m_lastTopIndex = -1;
                    }
                    table.setRedraw(true);
                    ExplorationMetricsView.this.m_currentCommand = null;
                    ExplorationMetricsView.this.m_currentWorkerContext = null;
                }
            }
        });
    }

    private void cancelCollect(boolean inDestroy) {
        if (!inDestroy) {
            this.resetPartName();
            this.setTitleTooltip(null);
            this.m_metricsViewer.setAdditionalFirstColumnInfo(null);
            this.m_metricsViewer.showData(null);
        }
        if (this.m_currentWorkerContext != null) {
            assert (this.m_currentCommand != null) : "'m_currentCommand' of method 'cancelCollect' must not be null";
            this.m_currentWorkerContext.cancel();
            this.m_currentWorkerContext = null;
            this.m_currentCommand = null;
        }
    }

    protected final void destroyViewContent() {
        this.cancelCollect(true);
        EventManager.getInstance().detach(ArchitecturalViewUnloadedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    protected final void handleSelection(WorkbenchView connectedView, List<Element> selectedElements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'handleSelection' must not be null";
        this.m_lastTopIndex = this.m_metricsViewer.isDisposed() ? -1 : this.m_metricsViewer.getTable().getTopIndex();
        this.cancelCollect(false);
        if (!selectedElements.isEmpty()) {
            this.collect(selectedElements);
        }
    }
}

