/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.EditArtifactCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.EditArtifactsCommand;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactFilterPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactsWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.MultipleArtifactsPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SingleArtifactPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.List;

public final class EditArtifactsWizard
extends ArtifactsWizard {
    private final List<ArtifactNode> m_artifactNodes;

    public EditArtifactsWizard(List<ArtifactNode> artifactNodes) {
        super("Edit Artifact" + (artifactNodes == null || artifactNodes.size() == 1 ? "" : "s"));
        assert (artifactNodes != null && !artifactNodes.isEmpty()) : "Parameter 'artifactNodes' of method 'EditArtifactsWizard' must not be empty";
        this.m_artifactNodes = new ArrayList<ArtifactNode>(artifactNodes);
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        ExplorationViewRepresentation representation = architecturalViewProvider.getArchitecturalViewRepresentation(this.m_artifactNodes);
        if (this.m_artifactNodes.size() == 1) {
            ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isEditArtifactsPossible(this.m_artifactNodes);
            assert (availability != null) : "'availability' of method 'addPages' must not be null";
            assert (availability.isAvailable()) : "Operation not available";
            ArtifactNode artifactNode = this.m_artifactNodes.get(0);
            AssignableTargetInfo assignableTargetInfo = new AssignableTargetInfo(availability.getAssignableTarget(), artifactNode.getRelativeIndex());
            SingleArtifactPage artifactPage = new SingleArtifactPage(architecturalViewProvider.getArtifactNameValidator(assignableTargetInfo, artifactNode), artifactNode, availability.getIgnoreSubTrees(), representation);
            this.addPage((SonargraphWizardPage)artifactPage);
            ArtifactFilterPage filterPage = new ArtifactFilterPage(provider.getSoftwareSystem().getUsedLanguages(), architecturalViewProvider, representation, artifactNode.getFilter());
            this.addPage((SonargraphWizardPage)filterPage);
            artifactPage.setFilterPage(filterPage);
        } else {
            ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isEditArtifactsPossible(this.m_artifactNodes);
            assert (availability != null) : "'availability' of method 'addPages' must not be null";
            assert (availability.isAvailable()) : "Operation not available";
            this.addPage((SonargraphWizardPage)new MultipleArtifactsPage(architecturalViewProvider, new AssignableTargetInfo(availability.getAssignableTarget(), -1), this.m_artifactNodes, availability.getIgnoreSubTrees(), representation));
        }
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            if (this.m_artifactNodes.size() == 1) {
                ArtifactFilterPage artifactFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
                assert (artifactFilterPage != null) : "'artifactFilterPage' of method 'canFinish' must not be null";
                if (artifactFilterPage.hasBeenEdited()) {
                    return true;
                }
                SingleArtifactPage singleArtifactPage = (SingleArtifactPage)this.getPage(SingleArtifactPage.NAME);
                assert (singleArtifactPage != null) : "'singleArtifactPage' of method 'canFinish' must not be null";
                if (singleArtifactPage.hasBeenEdited()) {
                    return true;
                }
            } else {
                MultipleArtifactsPage multipleArtifactsPage = (MultipleArtifactsPage)this.getPage(MultipleArtifactsPage.NAME);
                assert (multipleArtifactsPage != null) : "'multipleArtifactsPage' of method 'canFinish' must not be null";
                if (multipleArtifactsPage.hasBeenEdited()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            if (this.m_artifactNodes.size() == 1) {
                ArtifactFilterPage artifactFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
                assert (artifactFilterPage != null) : "'artifactFilterPage' of method 'canFinish' must not be null";
                if (!artifactFilterPage.assureCanFinish()) {
                    return false;
                }
                UserInterfaceAdapter.getInstance().run((Command)new EditArtifactCommand(provider, (EditArtifactCommand.IEditArtifactInteraction)new EditArtifactInteraction()));
            } else {
                UserInterfaceAdapter.getInstance().run((Command)new EditArtifactsCommand(provider, (EditArtifactsCommand.IEditArtifactsInteraction)new EditMultipleArtifactsInteraction()));
            }
            return true;
        }
        return false;
    }

    final class EditArtifactInteraction
    implements EditArtifactCommand.IEditArtifactInteraction {
        EditArtifactInteraction() {
        }

        public boolean collect(EditArtifactCommand.EditArtifactData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            SingleArtifactPage page = (SingleArtifactPage)EditArtifactsWizard.this.getPage(SingleArtifactPage.NAME);
            assert (page != null) : "'page' of method 'collect' must not be null";
            data.setArtifact(EditArtifactsWizard.this.m_artifactNodes.get(0));
            data.setTargetInfo(page.getAssignableTargetInfo());
            data.setShortName(page.getElementName());
            data.setProperties(page.getArtifactProperties());
            ArtifactFilterPage filterPage = (ArtifactFilterPage)EditArtifactsWizard.this.getPage(ArtifactFilterPage.NAME);
            assert (filterPage != null) : "'filterPage' of method 'collect' must not be null";
            data.setFilter(filterPage.getEditedFilter());
            return true;
        }

        public void processEditArtifactResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processEditArtifactResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class EditMultipleArtifactsInteraction
    implements EditArtifactsCommand.IEditArtifactsInteraction {
        EditMultipleArtifactsInteraction() {
        }

        public boolean collect(EditArtifactsCommand.EditArtifactsData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            MultipleArtifactsPage page = (MultipleArtifactsPage)EditArtifactsWizard.this.getPage(MultipleArtifactsPage.NAME);
            assert (page != null) : "'page' of method 'collect' must not be null";
            data.setArtifacts(EditArtifactsWizard.this.m_artifactNodes);
            data.setTargetInfo(page.getAssignableTargetInfo());
            data.setProperties(page.getArtifactProperties());
            return true;
        }

        public void processEditArtifactsResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processEditArtifactResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

