/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.DeleteArchitecturalViewsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteArchitecturalViewFileInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import java.util.List;

public final class DeleteArchitecturalViewCommandAdapter
extends ArchitecturalViewCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEWS;
    }

    public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> elements) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContectMenu' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'showInContectMenu' must not be null";
        return workbenchView.getViewId() == ViewId.FILES_VIEW;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        DeleteArchitecturalViewFileInfo info;
        List files;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (provider.hasSoftwareSystem() && !elements.isEmpty() && !(files = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewFile.class, elements)).isEmpty() && (info = ((IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isDeleteArchitecturalViewsPossible(files)) != null && info.getNumberOfFiles() > 0) {
            List allFiles = info.getAllFiles();
            String presentationKind = ((ArchitecturalViewFile)allFiles.get(0)).getPresentationKind();
            if (allFiles.size() == 1) {
                return new CompositeCommandAdapter.Applicable(presentationKind + " [" + ((ArchitecturalViewFile)allFiles.get(0)).getIdentifyingPath() + "]", presentationKind);
            }
            return new CompositeCommandAdapter.Applicable(allFiles.size() + " " + presentationKind + "s");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        final List files = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewFile.class, elements);
        assert (files != null && !files.isEmpty()) : "'files' of method 'apply' must not be empty";
        DeleteArchitecturalViewsCommand.IDeleteArchitecturalViewsInteraction interaction = new DeleteArchitecturalViewsCommand.IDeleteArchitecturalViewsInteraction(){

            public boolean collect(DeleteArchitecturalViewsCommand.DeleteArchitecturalViewsData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setFiles(files);
                return true;
            }

            public boolean confirmDeletion(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'confirmDeletion' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(info, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }

            public void processDeletionResult(OperationResult result) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        };
        DeleteArchitecturalViewsCommand cmd = new DeleteArchitecturalViewsCommand(provider, interaction);
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }
}

