/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FigureBasedFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PrimaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import org.eclipse.swt.graphics.Color;

final class CycleIndicator
extends FigureBasedFigure<PrimaryTreeNodeFigure> {
    private final Color m_color;

    CycleIndicator(ExplorationViewLayout layout, PrimaryTreeNodeFigure figure, int cycleIndex) {
        super(layout, figure);
        assert (cycleIndex != -1) : "Not cyclic";
        this.m_color = UiResourceManager.getInstance().getCyclicColor(cycleIndex);
    }

    static Color getCycleGroupSeparatorColor() {
        return UiResourceManager.getInstance().getCyclicColor(0);
    }

    public void postLayout(IFigure container) {
        Rectangle figureBounds = ((PrimaryTreeNodeFigure)((Object)this.getBasedOnFigure())).getBounds();
        this.setBounds(new Rectangle(figureBounds.x + DrawUtilities.EXPAND_COLLAPSE_FIGURE_DIMENSION.width, figureBounds.y - 1, 16, this.getLayout().getRowHeight()));
    }

    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialBgColor = graphics.getBackgroundColor();
        graphics.setBackgroundColor(this.m_color);
        graphics.fillRectangle(this.getBounds());
        graphics.setBackgroundColor(initialBgColor);
    }
}

