/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ClearFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class ClearFocusHandler
extends ArchitecturalViewHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.CLEAR_ARCHITECTURAL_VIEW_FOCUS;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                return "Clear Focus";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.FOCUS;
            }

            public boolean addSeparatorAfter() {
                return true;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.mayBeExecuted(selection)) {
            List architecturalViewElements = ClearFocusHandler.getMultipleSelectionIfAllAreAssignable(IArchitecturalViewElement.class, (List)selection.getElements());
            ExplorationViewRepresentation representation = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewRepresentation((Collection)architecturalViewElements);
            return representation != null && !representation.getFocus().isEmpty();
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        List architecturalViewElements = ClearFocusHandler.getMultipleSelectionIfAllAreAssignable(IArchitecturalViewElement.class, (List)selection.getElements());
        final ExplorationViewRepresentation representation = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewRepresentation((Collection)architecturalViewElements);
        assert (representation != null) : "Parameter 'representation' of method 'execute' must not be null";
        ClearFocusCommand command = new ClearFocusCommand(WorkbenchRegistry.getInstance().getProvider(), new ClearFocusCommand.IClearFocusInteraction(){

            public boolean collect(ArchitecturalViewRepresentationData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setRepresentation(representation);
                return true;
            }

            public void processClearResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processClearResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

