/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.ImageSupport;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.AssignableTargetTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.DraggableAssignableTargetTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExistingAssignableTargetTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.IArchitecturalViewSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LayoutCreator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PartialAlternativeInfoComposite;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.StandardUiTreeNodeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class ArtifactComposite
extends Composite
implements IArchitecturalViewSettingsProvider,
DraggableAssignableTargetTreeNode.IImageProvider,
DropTargetAdapter.IDropTargetActionHandler<AssignableTargetTreeNode>,
DragSourceAdapter.IDragActionHandler<AssignableTargetTreeNode>,
DisposeListener {
    private static final String INCOMING_DEPENDENCY_MODE = "artifact.incomingDependencyMode";
    private static final String OUTGOING_DEPENDENCY_MODE = "artifact.outgoingDependencyMode";
    private static final String ASSIGNMENT_MODE = "artifact.assignmentMode";
    private static final String VISIBILITY_HIDDEN = "artifact.visibilityHidden";
    private static final String VISIBILITY_LOCAL = "artifact.visibilityLocal";
    private final List<Button> m_visibilityButtons = new ArrayList<Button>();
    private final IConsumer m_consumer;
    private AssignableTargetInfo m_assignableTargetInfo;
    private ArtifactProperties m_artifactProperties;
    private PartialAlternativeInfoComposite m_partialAlternativeInfoComposite;
    private DraggableAssignableTargetTreeNode m_dynamicTreeNode;
    private Composite m_visibilityComposite;
    private TreeViewer m_treeViewer;

    private static ArtifactProperties load(IEclipsePreferences preferences) {
        assert (preferences != null) : "Parameter 'preferences' of method 'load' must not be null";
        EnumSet<ArtifactVisibility> visibility = EnumSet.noneOf(ArtifactVisibility.class);
        if (preferences.getBoolean(VISIBILITY_HIDDEN, false)) {
            visibility.add(ArtifactVisibility.HIDDEN);
        }
        if (preferences.getBoolean(VISIBILITY_LOCAL, false)) {
            visibility.add(ArtifactVisibility.LOCAL);
        }
        ArtifactIncomingDependencyMode in = ArtifactIncomingDependencyMode.NONE;
        try {
            in = ArtifactIncomingDependencyMode.fromStandardName((String)preferences.get(INCOMING_DEPENDENCY_MODE, ArtifactIncomingDependencyMode.NONE.getStandardName()));
        }
        catch (IllegalArgumentException e) {
            in = ArtifactIncomingDependencyMode.NONE;
        }
        ArtifactOutgoingDependencyMode out = ArtifactOutgoingDependencyMode.UNRESTRICTED;
        try {
            out = ArtifactOutgoingDependencyMode.fromStandardName((String)preferences.get(OUTGOING_DEPENDENCY_MODE, ArtifactOutgoingDependencyMode.UNRESTRICTED.getStandardName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArtifactAssignmentMode mode = ArtifactAssignmentMode.STANDARD;
        try {
            mode = ArtifactAssignmentMode.fromStandardName((String)preferences.get(ASSIGNMENT_MODE, ArtifactAssignmentMode.STANDARD.getStandardName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new ArtifactProperties(in, out, mode, visibility);
    }

    private static void save(ArtifactProperties properties, IEclipsePreferences preferences) {
        assert (properties != null) : "Parameter 'properties' of method 'save' must not be null";
        assert (preferences != null) : "Parameter 'preferences' of method 'save' must not be null";
        preferences.put(INCOMING_DEPENDENCY_MODE, properties.getIncomingDependencyMode().getStandardName());
        preferences.put(OUTGOING_DEPENDENCY_MODE, properties.getOutgoingDependencyMode().getStandardName());
        preferences.put(ASSIGNMENT_MODE, properties.getAssignmentMode().getStandardName());
        preferences.putBoolean(VISIBILITY_HIDDEN, properties.getVisibility().contains(ArtifactVisibility.HIDDEN));
        preferences.putBoolean(VISIBILITY_LOCAL, properties.getVisibility().contains(ArtifactVisibility.LOCAL));
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }

    private void setEnabledStateOfVisibilityComposite() {
        assert (this.m_visibilityComposite != null) : "'m_visibilityComposite' of method 'setEnabledStateOfVisibilityComposite' must not be null";
        boolean enabled = this.m_assignableTargetInfo.getTarget() instanceof ArtifactNode;
        Control[] controlArray = this.m_visibilityComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control nextControl = controlArray[n2];
            nextControl.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            for (Button next : this.m_visibilityButtons) {
                next.setSelection(this.m_artifactProperties.getVisibility().contains(next.getData()));
            }
        } else {
            this.m_artifactProperties = this.m_artifactProperties.clearVisibility();
            this.m_visibilityButtons.forEach(b -> b.setSelection(false));
        }
    }

    private void createWidgets(ExistingAssignableTargetTreeNode rootNode, PartialAlternativeInfo partialAlternativeInfo) {
        assert (rootNode != null) : "Parameter 'rootNode' of method 'createWidgets' must not be null";
        this.setLayout((Layout)new GridLayout(2, false));
        if (partialAlternativeInfo != null) {
            this.m_partialAlternativeInfoComposite = new PartialAlternativeInfoComposite(this, partialAlternativeInfo, new PartialAlternativeInfoComposite.IConsumer(){});
            this.m_partialAlternativeInfoComposite.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
            new Label((Composite)this, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        Label incomingMode = new Label((Composite)this, 0);
        incomingMode.setText("Incoming:");
        incomingMode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite incomingModeComposite = new Composite((Composite)this, 0);
        incomingModeComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        incomingModeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button publicCheckBox = new Button(incomingModeComposite, 32);
        publicCheckBox.setText(ArtifactIncomingDependencyMode.PUBLIC.getPresentationName());
        publicCheckBox.setToolTipText(ArtifactIncomingDependencyMode.PUBLIC.getDescription());
        publicCheckBox.setSelection(this.m_artifactProperties.getIncomingDependencyMode().equals((Object)ArtifactIncomingDependencyMode.PUBLIC));
        publicCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArtifactComposite.this.m_artifactProperties = ArtifactComposite.this.m_artifactProperties.setIncomingDependencyMode(publicCheckBox.getSelection() ? ArtifactIncomingDependencyMode.PUBLIC : ArtifactIncomingDependencyMode.NONE);
                ArtifactComposite.this.m_consumer.inputModified();
                ArtifactComposite.this.updateArtifactTreeAndRevealDynamicNode();
            }
        });
        Label outgoingMode = new Label((Composite)this, 0);
        outgoingMode.setText("Outgoing:");
        outgoingMode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite outgoingModeComposite = new Composite((Composite)this, 0);
        outgoingModeComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        outgoingModeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ArtifactOutgoingDependencyMode[] artifactOutgoingDependencyModeArray = ArtifactOutgoingDependencyMode.values();
        int n = artifactOutgoingDependencyModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ArtifactOutgoingDependencyMode next = artifactOutgoingDependencyModeArray[n2];
            Button nextButton = new Button(outgoingModeComposite, 16);
            nextButton.setText(next.getPresentationName());
            nextButton.setToolTipText(next.getDescription());
            if (next.equals((Object)this.m_artifactProperties.getOutgoingDependencyMode())) {
                nextButton.setSelection(true);
            }
            nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ArtifactComposite.this.m_artifactProperties = ArtifactComposite.this.m_artifactProperties.setOutgoingDependencyMode(next);
                    ArtifactComposite.this.m_consumer.inputModified();
                    ArtifactComposite.this.updateArtifactTreeAndRevealDynamicNode();
                }
            });
            ++n2;
        }
        Label assignmentMode = new Label((Composite)this, 0);
        assignmentMode.setText("Assignment:");
        assignmentMode.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite assignmentOptionComposite = new Composite((Composite)this, 0);
        assignmentOptionComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        assignmentOptionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ArtifactAssignmentMode[] artifactAssignmentModeArray = ArtifactAssignmentMode.values();
        int nextButton = artifactAssignmentModeArray.length;
        int n3 = 0;
        while (n3 < nextButton) {
            final ArtifactAssignmentMode next = artifactAssignmentModeArray[n3];
            Button nextButton2 = new Button(assignmentOptionComposite, 16);
            nextButton2.setText(next.getPresentationName());
            nextButton2.setToolTipText(next.getDescription());
            if (next.equals((Object)this.m_artifactProperties.getAssignmentMode())) {
                nextButton2.setSelection(true);
            }
            nextButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ArtifactComposite.this.m_artifactProperties = ArtifactComposite.this.m_artifactProperties.setAssignmentMode(next);
                    ArtifactComposite.this.m_consumer.inputModified();
                    ArtifactComposite.this.updateArtifactTreeAndRevealDynamicNode();
                }
            });
            ++n3;
        }
        Label visibility = new Label((Composite)this, 0);
        visibility.setText("Visibility:");
        visibility.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_visibilityComposite = new Composite((Composite)this, 0);
        this.m_visibilityComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        this.m_visibilityComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ArtifactVisibility[] artifactVisibilityArray = ArtifactVisibility.values();
        int n4 = artifactVisibilityArray.length;
        nextButton = 0;
        while (nextButton < n4) {
            final ArtifactVisibility next = artifactVisibilityArray[nextButton];
            final Button nextButton3 = new Button(this.m_visibilityComposite, 32);
            nextButton3.setText(next.getPresentationName());
            nextButton3.setToolTipText(next.getDescription());
            nextButton3.setData((Object)next);
            this.m_visibilityButtons.add(nextButton3);
            if (this.m_artifactProperties.getVisibility().contains(next)) {
                nextButton3.setSelection(true);
            }
            nextButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ArtifactComposite.this.m_artifactProperties = nextButton3.getSelection() ? ArtifactComposite.this.m_artifactProperties.addVisibility(next) : ArtifactComposite.this.m_artifactProperties.removeVisibility(next);
                    ArtifactComposite.this.m_consumer.inputModified();
                    ArtifactComposite.this.updateArtifactTreeAndRevealDynamicNode();
                }
            });
            ++nextButton;
        }
        this.setEnabledStateOfVisibilityComposite();
        new Label((Composite)this, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label = new Label((Composite)this, 0);
        label.setText("Use drag and drop to choose a different parent and/or position in the artifact tree:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_treeViewer = new TreeViewer((Composite)this, 4);
        this.m_treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ElementTreeContentAndLabelProvider contentAndLabelProvider = new ElementTreeContentAndLabelProvider(this.m_dynamicTreeNode);
        this.m_treeViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.m_treeViewer.setInput(Collections.singletonList(rootNode));
        this.m_treeViewer.expandAll();
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_dynamicTreeNode), true);
        DropTargetAdapter targetAdapter = new DropTargetAdapter((StructuredViewer)this.m_treeViewer, this, Collections.singletonList(ExistingAssignableTargetTreeNode.class), false);
        new DragSourceAdapter<AssignableTargetTreeNode>((StructuredViewer)this.m_treeViewer, 2, Collections.singletonList(targetAdapter), Collections.singletonList(DraggableAssignableTargetTreeNode.class), this);
        this.addDisposeListener(this);
    }

    private void createNodes(AssignableTargetTreeNode node, ArchitecturalViewElement nodeElement, AssignableTargetInfo assignableTargetInfo, DraggableAssignableTargetTreeNode.INameProvider nameProvider, Set<ArtifactNode> ignoreSubTree) {
        assert (node != null) : "Parameter 'node' of method 'createNodes' must not be null";
        assert (nodeElement != null) : "Parameter 'nodeElement' of method 'createNodes' must not be null";
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'createNodes' must not be null";
        assert (nameProvider != null) : "Parameter 'nameProvider' of method 'createNodes' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'ignoreSubTree' of method 'createNodes' must not be null";
        for (ArtifactNode nextArtifact : nodeElement.getChildren(ArtifactNode.class)) {
            if (ignoreSubTree.contains(nextArtifact)) continue;
            ExistingAssignableTargetTreeNode nextArtifactTreeNode = new ExistingAssignableTargetTreeNode((IAssignableTarget)nextArtifact);
            node.addChild(nextArtifactTreeNode);
            this.createNodes(nextArtifactTreeNode, (ArchitecturalViewElement)nextArtifact, assignableTargetInfo, nameProvider, ignoreSubTree);
        }
        if (this.m_dynamicTreeNode == null && assignableTargetInfo.getTarget() == nodeElement) {
            this.m_dynamicTreeNode = new DraggableAssignableTargetTreeNode(this, nameProvider);
            if (assignableTargetInfo.getRelativeIndex() == -1) {
                node.addChild(this.m_dynamicTreeNode);
            } else {
                node.addChild(this.m_dynamicTreeNode, assignableTargetInfo.getRelativeIndex());
            }
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        ArtifactComposite.save(this.m_artifactProperties, this.getPreferences());
    }

    ArtifactComposite(Composite parent, AssignableTargetInfo assignableTargetInfo, ArtifactProperties artifactProperties, DraggableAssignableTargetTreeNode.INameProvider nameProvider, Set<ArtifactNode> ignoreSubTree, PartialAlternativeInfo partialAlternativeInfo, ExplorationViewRepresentation representation, IConsumer consumer) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'ArtifactComposite' must not be null";
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'ArtifactComposite' must not be null";
        assert (nameProvider != null) : "Parameter 'nameProvider' of method 'ArtifactComposite' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'invalidTargetParents' of method 'ArtifactComposite' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArtifactComposite' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ArtifactComposite' must not be null";
        this.m_artifactProperties = artifactProperties == null ? ArtifactComposite.load(this.getPreferences()) : artifactProperties;
        this.m_consumer = consumer;
        ExistingAssignableTargetTreeNode rootNode = new ExistingAssignableTargetTreeNode((IAssignableTarget)representation);
        this.createNodes(rootNode, (ArchitecturalViewElement)representation, assignableTargetInfo, nameProvider, ignoreSubTree);
        assert (this.m_dynamicTreeNode != null) : "'m_dynamicTreeNode' of method 'ArtifactComposite' must not be null";
        this.m_assignableTargetInfo = new AssignableTargetInfo(assignableTargetInfo.getTarget(), ((UiTreeNode)this.m_dynamicTreeNode.getParent()).getIndexOf(this.m_dynamicTreeNode));
        this.createWidgets(rootNode, partialAlternativeInfo);
    }

    private void createNodes(AssignableTargetTreeNode node, ArchitecturalViewElement nodeElement, List<ArtifactNode> toBeEdited, AssignableTargetInfo assignableTargetInfo, DraggableAssignableTargetTreeNode.INameProvider nameProvider, Set<ArtifactNode> ignoreSubTree) {
        assert (node != null) : "Parameter 'node' of method 'createNodes' must not be null";
        assert (nodeElement != null) : "Parameter 'nodeElement' of method 'createNodes' must not be null";
        assert (toBeEdited != null && !toBeEdited.isEmpty()) : "Parameter 'toBeEdited' of method 'createNodes' must not be empty";
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'createNodes' must not be null";
        assert (nameProvider != null) : "Parameter 'nameProvider' of method 'createNodes' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'ignoreSubTree' of method 'createNodes' must not be null";
        for (ArtifactNode nextArtifact : nodeElement.getChildren(ArtifactNode.class)) {
            if (ignoreSubTree.contains(nextArtifact)) continue;
            AssignableTargetTreeNode nextArtifactTreeNode = null;
            boolean addAsExisting = true;
            for (ArtifactNode nextToBeEdited : toBeEdited) {
                if (nextToBeEdited != nextArtifact) continue;
                addAsExisting = false;
            }
            if (addAsExisting) {
                nextArtifactTreeNode = new ExistingAssignableTargetTreeNode((IAssignableTarget)nextArtifact);
                node.addChild(nextArtifactTreeNode);
            } else if (this.m_dynamicTreeNode == null) {
                this.m_dynamicTreeNode = new DraggableAssignableTargetTreeNode(this, nameProvider);
                nextArtifactTreeNode = this.m_dynamicTreeNode;
                if (assignableTargetInfo.getRelativeIndex() == -1) {
                    node.addChild(nextArtifactTreeNode);
                } else {
                    node.addChild(nextArtifactTreeNode, assignableTargetInfo.getRelativeIndex());
                }
            }
            if (nextArtifactTreeNode == null) continue;
            this.createNodes(nextArtifactTreeNode, (ArchitecturalViewElement)nextArtifact, toBeEdited, assignableTargetInfo, nameProvider, ignoreSubTree);
        }
    }

    ArtifactComposite(Composite parent, AssignableTargetInfo assignableTargetInfo, ArtifactProperties artifactProperties, DraggableAssignableTargetTreeNode.INameProvider nameProvider, List<ArtifactNode> toBeEdited, Set<ArtifactNode> ignoreSubTree, PartialAlternativeInfo partialAlternativeInfo, ExplorationViewRepresentation representation, IConsumer consumer) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'ArtifactComposite' must not be null";
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'ArtifactComposite' must not be null";
        assert (nameProvider != null) : "Parameter 'nameProvider' of method 'ArtifactComposite' must not be null";
        assert (ignoreSubTree != null) : "Parameter 'ignoreSubTree' of method 'ArtifactComposite' must not be null";
        assert (toBeEdited != null && !toBeEdited.isEmpty()) : "Parameter 'toBeEdited' of method 'ArtifactComposite' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'ArtifactComposite' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ArtifactComposite' must not be null";
        this.m_artifactProperties = artifactProperties == null ? ArtifactComposite.load(this.getPreferences()) : artifactProperties;
        this.m_consumer = consumer;
        ExistingAssignableTargetTreeNode rootNode = new ExistingAssignableTargetTreeNode((IAssignableTarget)representation);
        this.createNodes(rootNode, (ArchitecturalViewElement)representation, toBeEdited, assignableTargetInfo, nameProvider, ignoreSubTree);
        assert (this.m_dynamicTreeNode != null) : "'m_dynamicTreeNode' of method 'ArtifactComposite' must not be null";
        this.m_assignableTargetInfo = new AssignableTargetInfo(assignableTargetInfo.getTarget(), ((UiTreeNode)this.m_dynamicTreeNode.getParent()).getIndexOf(this.m_dynamicTreeNode));
        this.createWidgets(rootNode, partialAlternativeInfo);
    }

    @Override
    public Image getNodeImage() {
        return UiResourceManager.getInstance().getImage(ImageSupport.getImageResourceName((ArtifactOutgoingDependencyMode)this.m_artifactProperties.getOutgoingDependencyMode()), ImageSupport.getImageResourceDecoratorInfo((ArtifactIncomingDependencyMode)this.m_artifactProperties.getIncomingDependencyMode(), (EnumSet)this.m_artifactProperties.getVisibility(), (ImageSupport.Marker)ImageSupport.Marker.NONE, (boolean)false, (boolean)false));
    }

    void updateArtifactTreeAndRevealDynamicNode() {
        this.m_treeViewer.getControl().setRedraw(false);
        this.m_treeViewer.refresh();
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_dynamicTreeNode), true);
        this.m_treeViewer.getControl().setRedraw(true);
    }

    private boolean changeParent(UiTreeNode currentParent, UiTreeNode targetParent, int atPos) {
        assert (currentParent != null && currentParent instanceof ExistingAssignableTargetTreeNode) : "Unexpected class in method 'changeParent': " + String.valueOf((Object)currentParent);
        assert (targetParent != null && targetParent instanceof ExistingAssignableTargetTreeNode) : "Unexpected class in method 'changeParent': " + String.valueOf((Object)targetParent);
        int currentPos = targetParent.getIndexOf(this.m_dynamicTreeNode);
        boolean parentOrPositionChanged = false;
        int resultingPos = -1;
        if (atPos == -1) {
            if (currentPos == -1 || targetParent.getNumberOfChildren() - 1 != currentPos) {
                resultingPos = targetParent.addChild(this.m_dynamicTreeNode);
                parentOrPositionChanged = true;
            }
        } else if (currentPos == -1 || currentPos != atPos) {
            targetParent.addChild(this.m_dynamicTreeNode, atPos);
            resultingPos = targetParent.getIndexOf(this.m_dynamicTreeNode);
            parentOrPositionChanged = true;
        }
        if (parentOrPositionChanged) {
            this.m_assignableTargetInfo = new AssignableTargetInfo(((ExistingAssignableTargetTreeNode)targetParent).getAssignableTarget(), resultingPos);
            this.m_consumer.inputModified();
            this.setEnabledStateOfVisibilityComposite();
            this.updateArtifactTreeAndRevealDynamicNode();
            return true;
        }
        return false;
    }

    @Override
    public boolean perform(AssignableTargetTreeNode target, DropLocation location, List<AssignableTargetTreeNode> dropped, StructuredViewer viewer) {
        assert (target != null) : "Parameter 'target' of method 'perform' must not be null";
        assert (dropped != null && dropped.size() == 1) : "Parameter 'dropped' of method 'perform' must contain 1 element";
        assert (this.m_dynamicTreeNode == dropped.get(0)) : "Unexpected dropped: " + String.valueOf((Object)dropped.get(0));
        if (target == this.m_dynamicTreeNode) {
            return false;
        }
        if (this.m_dynamicTreeNode.isParentOf(target)) {
            return false;
        }
        UiTreeNode parentOfTarget = (UiTreeNode)target.getParent();
        UiTreeNode parentOfDropped = (UiTreeNode)this.m_dynamicTreeNode.getParent();
        switch (location) {
            case BEFORE: {
                if (parentOfTarget == null) break;
                return this.changeParent(parentOfDropped, parentOfTarget, parentOfTarget.getIndexOf(target));
            }
            case ON: {
                if (parentOfDropped == target) break;
                return this.changeParent(parentOfDropped, target, -1);
            }
            case AFTER: {
                if (parentOfTarget == null) break;
                return this.changeParent(parentOfDropped, parentOfTarget, parentOfTarget.getIndexOf(target) + 1);
            }
            default: {
                assert (false) : "Unhandled location: " + String.valueOf(location);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean validateDrag(List<AssignableTargetTreeNode> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'validateDrag' must not be empty";
        return elements.size() == 1;
    }

    AssignableTargetInfo getAssignableTargetInfo() {
        return this.m_assignableTargetInfo;
    }

    ArtifactProperties getArtifactProperties() {
        return this.m_artifactProperties;
    }

    List<? extends ArchitecturalViewElement> getPartialAlternative() {
        if (this.m_partialAlternativeInfoComposite != null) {
            return this.m_partialAlternativeInfoComposite.getAlternativeElements();
        }
        return null;
    }

    private static final class ElementTreeContentAndLabelProvider
    extends StandardUiTreeNodeContentAndLabelProvider
    implements IColorProvider {
        private final AssignableTargetTreeNode m_highlight;

        ElementTreeContentAndLabelProvider(AssignableTargetTreeNode highlight) {
            assert (highlight != null) : "Parameter 'highlight' of method 'ElementTreeContentAndLabelProvider' must not be null";
            this.m_highlight = highlight;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (element == this.m_highlight) {
                return UiResourceManager.getInstance().getColor(UiResourceManager.VERY_VERY_LIGHT_GREY);
            }
            return null;
        }
    }

    public static interface IConsumer {
        public void inputModified();
    }
}

