/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewSplitEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalListView;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationView;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ArchitecturalNonLazyListView
extends ArchitecturalListView {
    private ArchitecturalViewFile m_file;

    protected abstract void createViewer(Composite var1);

    protected final void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.createViewer(viewContentArea);
        this.initialize();
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitecturalNonLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getModifiableFiles().contains(ArchitecturalNonLazyListView.this.getFile())) {
                    ArchitecturalNonLazyListView.this.clear();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewModifiedEvent>(ArchitecturalViewModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalNonLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalNonLazyListView.this.getFile()) {
                    ArchitecturalNonLazyListView.this.show(ArchitecturalNonLazyListView.this.getFile());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewLoadedEvent>(ArchitecturalViewLoadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewLoadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalNonLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalNonLazyListView.this.getFile()) {
                    ArchitecturalNonLazyListView.this.show(ArchitecturalNonLazyListView.this.getFile());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewUnloadedEvent>(ArchitecturalViewUnloadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalNonLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalNonLazyListView.this.getFile()) {
                    ArchitecturalNonLazyListView.this.show(ArchitecturalNonLazyListView.this.getFile());
                    SoftwareSystem system = ArchitecturalNonLazyListView.this.getSoftwareSystem();
                    if (system != null && !((IArchitecturalViewProvider)system.getExtension(IArchitecturalViewProvider.class)).hasLoadedArchitecturalViews(false)) {
                        ArchitecturalNonLazyListView.this.hideView();
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewSplitEvent>(ArchitecturalViewSplitEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewSplitEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalNonLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalNonLazyListView.this.getFile()) {
                    ArchitecturalNonLazyListView.this.show(ArchitecturalNonLazyListView.this.getFile());
                }
            }
        });
    }

    protected final void destroyViewContent() {
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewLoadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewUnloadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewSplitEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public final List<Element> getSelectedElements() {
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.getViewer().getSelection());
    }

    public final void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        this.getViewer().getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected final ArchitecturalViewFile getFile() {
        return this.m_file;
    }

    protected void clear() {
        this.resetPartName();
        this.m_file = null;
    }

    protected abstract void show(ArchitecturalViewFile var1);

    protected final void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        assert (ViewId.EXPLORATION_VIEW.equals((Object)connectedView.getViewId())) : "Unexpected view: " + String.valueOf(connectedView.getViewId());
        ArchitecturalViewFile file = ((ExplorationView)connectedView).getModifiableFile();
        if (file != null) {
            if (file != this.m_file) {
                this.m_file = file;
                this.setPartName(file.getIdentifyingPath());
                this.show(file);
            }
        } else {
            this.clear();
        }
    }

    protected final void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clear();
    }
}

