/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArchitecturalViewListCommand;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewBaseProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalListView;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewInfoBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationView;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ArchitecturalLazyListView
extends ArchitecturalListView {
    private PropertyTableViewer<ArchitecturalViewInfo<? extends Element>> m_viewer;
    private ArchitecturalViewFile m_file;

    protected ArchitecturalLazyListView() {
    }

    public IContext getContext() {
        ExplorationViewRepresentation representation;
        SoftwareSystem softwareSystem;
        if (this.m_file != null && (softwareSystem = this.getSoftwareSystem()) != null && (representation = (ExplorationViewRepresentation)this.m_file.getUniqueChild(ExplorationViewRepresentation.class)) != null && representation.isValid()) {
            return ((IArchitecturalViewBaseProvider)softwareSystem.getExtension(IArchitecturalViewBaseProvider.class)).getContext(representation);
        }
        return super.getContext();
    }

    protected abstract String getTopic();

    protected abstract CreateArchitecturalViewListCommand createCommand(ISoftwareSystemProvider var1, ExplorationViewRepresentation var2);

    protected final void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_viewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new ArchitecturalViewInfoBeanAdapter(), "identifyingFilePath", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_viewer.addColumn(this.getTopic(), "topic", "topic", "topicImage", 14, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.addColumn("File", "identifyingFilePath", "identifyingFilePath", "identifyingFilePathImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.addColumn("Line", "lineNumberAsString", "lineNumber", null, 5, PropertyTableViewer.ColumnType.NUMBER);
        this.m_viewer.addColumn("Element", "elementName", "elementName", "elementImage", 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.addColumn("To Element", "toElementName", "toElementName", "toElementImage", 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_viewer.addColumn("Information", "information", "information", null, 17, PropertyTableViewer.ColumnType.TEXT);
        this.initialize();
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewLoadedEvent>(ArchitecturalViewLoadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewLoadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalLazyListView.this.m_file) {
                    ArchitecturalLazyListView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewModifiedEvent>(ArchitecturalViewModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalLazyListView.this.m_file) {
                    WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(ArchitecturalLazyListView.this.getPart(), ArchitecturalLazyListView.this.m_file.getShortName());
                    ArchitecturalLazyListView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewUnloadedEvent>(ArchitecturalViewUnloadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitecturalLazyListView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOwner() == ArchitecturalLazyListView.this.m_file) {
                    ArchitecturalLazyListView.this.clear();
                    SoftwareSystem system = ArchitecturalLazyListView.this.getSoftwareSystem();
                    if (system != null && !((IArchitecturalViewProvider)system.getExtension(IArchitecturalViewProvider.class)).hasLoadedArchitecturalViews(false)) {
                        ArchitecturalLazyListView.this.hideView();
                    }
                }
            }
        });
    }

    @Override
    protected PropertyTableViewer<? extends Element> getViewer() {
        return this.m_viewer;
    }

    protected abstract void removeCorrespondingList(IArchitecturalViewBaseProvider var1);

    protected final void destroyViewContent() {
        EventManager.getInstance().detach(ArchitecturalViewLoadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewUnloadedEvent.class, (Object)this);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null) {
            this.removeCorrespondingList((IArchitecturalViewBaseProvider)softwareSystem.getExtension(IArchitecturalViewBaseProvider.class));
        }
        super.destroyViewContent();
    }

    public final boolean supportsExcelExport() {
        return this.m_file != null && this.m_file.getUniqueChild(ExplorationViewRepresentation.class) != null && this.m_viewer != null && !this.m_viewer.isDisposed() && !this.m_viewer.getFilteredInputData().isEmpty();
    }

    public final boolean performAnalyzerExecutionLevelCheckOnExcelExport() {
        return false;
    }

    public final String getExcelExportContentName() {
        return this.getTopic() + " from '" + this.m_file.getIdentifyingPath() + "'";
    }

    public final List<ExportData> getExportData(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getExportData' must not be null";
        return ((IArchitecturalViewProvider)this.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).convertToExportData(workerContext, this.m_file, this.getTopic(), this.m_viewer.getFilteredInputData());
    }

    public final List<Element> getSelectedElements() {
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.m_viewer.getSelection());
    }

    public final void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        assert (this.m_viewer != null) : "Parameter 'm_viewer' of method 'clearSelection' must not be null";
        this.m_viewer.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void clear() {
        this.m_viewer.showData(null);
        this.resetPartName();
        this.m_file = null;
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    private void show() {
        assert (this.m_file != null) : "'m_file' of method 'show' must not be null";
        assert (this.getSoftwareSystemProvider().hasSoftwareSystem()) : "No system available";
        final ExplorationViewRepresentation representation = (ExplorationViewRepresentation)this.m_file.getUniqueChild(ExplorationViewRepresentation.class);
        if (representation != null) {
            final CreateArchitecturalViewListCommand cmd = this.createCommand(this.getSoftwareSystemProvider(), representation);
            UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    List list;
                    super.consume(exception);
                    boolean clear = true;
                    if (exception == null && ArchitecturalLazyListView.this.isActive() && ArchitecturalLazyListView.this.m_file != null && ArchitecturalLazyListView.this.m_file.getUniqueChild(ExplorationViewRepresentation.class) == representation && (list = cmd.getList()) != null) {
                        ArchitecturalLazyListView.this.m_viewer.showData((Collection)list);
                        WorkbenchRegistry.getInstance().refreshUIElements();
                        clear = false;
                    }
                    if (clear && ArchitecturalLazyListView.this.isActive()) {
                        ArchitecturalLazyListView.this.clear();
                    }
                }
            });
        } else {
            this.clear();
        }
    }

    protected final void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        ArchitecturalViewFile file = null;
        IViewId viewId = connectedView.getViewId();
        assert (ViewId.EXPLORATION_VIEW.equals((Object)viewId)) : "Unexpected view: " + String.valueOf(viewId);
        file = ((ExplorationView)connectedView).getModifiableFile();
        if (file != null) {
            if (this.m_file != file) {
                this.m_file = file;
                this.setPartName(file.getIdentifyingPath());
                this.show();
            }
        } else {
            this.clear();
        }
    }
}

