/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.application;

import com.hello2morrow.sonargraph.client.eclipse.application.EclipseApplication;
import com.hello2morrow.sonargraph.client.eclipse.application.EclipseLogListener;
import com.hello2morrow.sonargraph.client.eclipse.application.IExceptionHandler;
import com.hello2morrow.sonargraph.client.eclipse.application.LanguageProviderExtension;
import com.hello2morrow.sonargraph.core.application.ILicenseHandlerProvider;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandlerProduction;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderAdapter;
import com.hello2morrow.sonargraph.license.model.LicenseMessageCause;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.application.SonargraphStandaloneActivator;
import com.hello2morrow.sonargraph.ui.standalone.application.SonargraphStandaloneExitHandler;
import com.hello2morrow.sonargraph.ui.standalone.application.StandaloneExceptionHandler;
import com.hello2morrow.sonargraph.ui.standalone.application.StandaloneLanguageProviderExtension;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PreferencePageRegistry;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.StandaloneOutputStreamProvider;
import com.hello2morrow.sonargraph.ui.standalone.commandhandler.NewWizardsSubMenu;
import com.hello2morrow.sonargraph.ui.standalone.commandhandler.RenewLicenseTicketAutomaticallyHandler;
import com.hello2morrow.sonargraph.ui.standalone.debugview.DebugView;
import com.hello2morrow.sonargraph.ui.standalone.help.StandaloneHelpAdapter;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RecentlyUsedSubMenu;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StandaloneActions;
import com.hello2morrow.sonargraph.ui.standalone.update.UpdateSupport;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewBasedContentFilter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewCategoryProvider;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WizardRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CoreViewCategoryProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IExceptionHandlingSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.LinkSelectionListener;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseDialog;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseServerComposite;
import com.hello2morrow.sonargraph.ui.swt.license.NoLicenseTicketAvailableDialog;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonargraphStandaloneApplication
extends EclipseApplication
implements ILicenseHandlerProvider,
SonargraphLicenseHandler.ILicenseLostEventHandler,
IExceptionHandlingSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphStandaloneApplication.class);
    private final StandaloneProxySettingsProvider m_proxySettingsProvider = new StandaloneProxySettingsProvider();
    private final ILogListener m_logListener = new EclipseLogListener((IExceptionHandler)new StandaloneExceptionHandler(this, this.m_proxySettingsProvider));
    private IEclipseContext m_eclipseContext;
    private EModelService m_modelService;
    private MWindow m_mainApplicationWindow;
    private MApplication m_application;
    private Set<IViewId> m_allViewIds;
    private Set<IViewId> m_availableViewIds;
    private List<IViewBasedContentFilter> m_viewContentFilters;
    private List<IViewCategoryProvider> m_viewCategoryProviders;
    private ConnectionMode m_connectionMode;
    private ISoftwareSystemProvider m_provider;
    private SonargraphLicenseHandler m_licenseHandler;

    public SonargraphStandaloneApplication() {
        super(EclipseApplication.BundleHandling.DYNAMIC, SonargraphProduct.SONARGRAPH);
    }

    protected SonargraphLicenseHandler getLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, SonargraphLicenseHandler.ILicenseLostEventHandler handler) {
        assert (product != null) : "Parameter 'product' of method 'getLicenseHandler' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'getLicenseHandler' must not be null";
        return new SonargraphLicenseHandlerProduction(product, availableLanguages, handler);
    }

    private String getNoLicenseTicketsAvailableMessage(List<OperationResult.Message> messages) {
        assert (messages != null) : "Parameter 'messages' of method 'getNoLicenseTicketsAvailableMessage' must not be null";
        for (OperationResult.Message nextMessage : messages) {
            if (nextMessage.getCause() != LicenseMessageCause.NO_LICENSE_TICKETS_AVAILABLE) continue;
            String message = nextMessage.getMessage();
            if (message == null || message.isEmpty()) {
                return null;
            }
            return message;
        }
        return null;
    }

    public final SonargraphLicenseHandler initializeLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, SonargraphLicenseHandler.ILicenseLostEventHandler handler) {
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'initLicenseHandler' must not be null";
        assert (this.m_connectionMode != null) : "'m_connectionMode' of method 'initializeLicenseHandler' must not be null";
        this.m_licenseHandler = this.getLicenseHandler(product, availableLanguages, handler);
        if (this.m_connectionMode == ConnectionMode.ONLINE) {
            this.m_licenseHandler.setRenewLicenseTicketAutomatically(RenewLicenseTicketAutomaticallyHandler.isActive());
            this.m_licenseHandler.setProxySettings(this.m_proxySettingsProvider.getProxySettings(false));
        }
        this.m_licenseHandler.setLicenseServer(LicenseServerComposite.createLicenseServerSettings((boolean)false));
        OperationResult result = this.m_licenseHandler.initialize();
        if (result.isFailure()) {
            NoLicenseTicketAvailableDialog dialog;
            String message = this.getNoLicenseTicketsAvailableMessage(result.getMessages());
            if (message != null ? (dialog = new NoLicenseTicketAvailableDialog(message, this.m_licenseHandler, this.m_connectionMode, (IDialogId)CoreDialogId.INSTALL_LICENSE_DIALOG, (IProxySettingsProvider)this.m_proxySettingsProvider)).open() == 1 : (dialog = new LicenseDialog(null, this.m_licenseHandler, null, this.m_connectionMode, (IDialogId)CoreDialogId.INSTALL_LICENSE_DIALOG, (IProxySettingsProvider)this.m_proxySettingsProvider)).open() == 1) {
                return this.m_licenseHandler;
            }
            assert (this.m_licenseHandler.hasValidLicense()) : "No valid license";
        }
        return this.m_licenseHandler;
    }

    protected final void languageProviderExtensionFound(LanguageProviderExtension languageProviderExtension) {
        super.languageProviderExtensionFound(languageProviderExtension);
        if (languageProviderExtension instanceof StandaloneLanguageProviderExtension) {
            StandaloneLanguageProviderExtension extension = (StandaloneLanguageProviderExtension)languageProviderExtension;
            UiResourceManager.getInstance().addResourceProviderAdapter(extension.getResourceProviderAdapter());
            this.m_viewContentFilters.addAll(extension.getViewContentFilters());
            this.m_viewCategoryProviders.addAll(extension.getViewCategoryProviders());
            this.m_availableViewIds.addAll(extension.getAvaliableViewIds());
        } else {
            LOGGER.warn("Unexpected class: " + languageProviderExtension.getClass().getName());
        }
    }

    public final void startupComplete() {
        assert (this.m_modelService != null) : "'m_modelService' of method 'processCommandHandlers' must not be null";
        assert (this.m_application != null) : "'m_application' of method 'processCommandHandlers' must not be null";
        assert (this.m_mainApplicationWindow != null) : "'m_mainApplicationWindow' of method 'processCommandHandlers' must not be null";
        THashMap commandIdToMenuItem = new THashMap();
        LOGGER.debug("Processing command handlers");
        for (MHandledMenuItem nextMenuItem : this.m_modelService.findElements((MUIElement)this.m_mainApplicationWindow.getMainMenu(), null, MHandledMenuItem.class, null)) {
            MCommand nextModelCommand = nextMenuItem.getCommand();
            assert (nextModelCommand != null) : "'nextModelCommand' of method 'startupComplete' must not be null: " + nextMenuItem.getElementId();
            String nextCommandId = nextModelCommand.getElementId();
            assert (nextCommandId != null && nextCommandId.length() > 0) : "Parameter 'nextCommandId' of method 'startupComplete' must not be empty";
            if (!nextCommandId.startsWith("com.hello2morrow.sonargraph")) continue;
            commandIdToMenuItem.put(nextCommandId, nextMenuItem);
        }
        LOGGER.debug("Processing context menu contributors");
        this.m_modelService.findElements((MApplicationElement)this.m_application, MHandler.class, 29, new Selector((Map)commandIdToMenuItem){
            private final /* synthetic */ Map val$commandIdToMenuItem;
            {
                this.val$commandIdToMenuItem = map;
            }

            public boolean select(MApplicationElement element) {
                Object nextAssociated;
                MHandler nextHandler;
                if (element instanceof MHandler && (nextHandler = (MHandler)element).getElementId().startsWith("com.hello2morrow.sonargraph") && (nextAssociated = nextHandler.getObject()) instanceof CommandHandler) {
                    IContextMenuContributor contributor;
                    CommandHandler nextCommandHandler = (CommandHandler)nextAssociated;
                    MCommand nextModelCommand = nextHandler.getCommand();
                    if (nextModelCommand != null && (contributor = nextCommandHandler.createContextMenuContributor()) != null) {
                        List nextModelCommandParamters = nextModelCommand.getParameters();
                        if (nextModelCommandParamters.isEmpty()) {
                            String nextCommandId = nextModelCommand.getElementId();
                            MMenuItem nextMenuItem = (MMenuItem)this.val$commandIdToMenuItem.get(nextCommandId);
                            if (nextMenuItem != null && WorkbenchRegistry.hasInstance()) {
                                WorkbenchRegistry.getInstance().registerContextMenuContributor(nextCommandId, nextMenuItem, contributor);
                            }
                        } else {
                            LOGGER.warn("Context menu contributors not supported for commands with parameters: " + nextModelCommand.getElementId());
                        }
                    }
                }
                return false;
            }
        });
        assert (this.m_mainApplicationWindow != null) : "'m_mainApplicationWindow' of method 'handleEvent' must not be null";
        this.m_mainApplicationWindow.getContext().set(IWindowCloseHandler.class, (Object)new SonargraphStandaloneExitHandler());
        WorkbenchRegistry.getInstance().startupComplete();
        super.startupComplete();
        this.m_connectionMode = null;
        this.m_application = null;
        this.m_availableViewIds = null;
        this.m_allViewIds = null;
        this.m_viewContentFilters = null;
        this.m_viewCategoryProviders = null;
        this.m_modelService = null;
    }

    public final void shutdownStarted(ISoftwareSystemProvider provider) {
        assert (this.m_eclipseContext != null) : "Parameter 'm_eclipseContext' of method 'aboutToShutdown' must not be null";
        RecentlyUsedSubMenu.removeEntries(this.m_eclipseContext, this.m_mainApplicationWindow);
        NewWizardsSubMenu.removeEntries(this.m_eclipseContext, this.m_mainApplicationWindow);
        StandaloneOutputStreamProvider.delete();
        PreferencePageRegistry.delete();
        WizardRegistry.delete();
        CompositeCommandRegistry.delete();
        HelpRegistry.delete();
        WorkbenchRegistry.delete();
        StandaloneActions.delete();
        UiResourceManager.delete();
        UserInterfaceAdapter.delete();
        HelpAdapter.resetHelpAdapter();
        StandardWizardPage.resetHelpAdapter();
        AnalyzerPropertyPage.resetHelpAdapter();
        StandardPreferencePage.resetHelpAdapter();
        super.shutdownStarted(provider);
        org.eclipse.core.runtime.Platform.removeLogListener((ILogListener)this.m_logListener);
    }

    private void migrateStandaloneFiles() {
        TFile userHomeDir = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        TFile newProductTargetDirectory = new TFile((File)userHomeDir, SonargraphProduct.SONARGRAPH.getDirectoryName());
        TFile newLicenseFileLocation = new TFile((File)newProductTargetDirectory, SonargraphProduct.SONARGRAPH.getStandardName() + ".license");
        if (userHomeDir != null && userHomeDir.exists() && !newLicenseFileLocation.exists()) {
            TrueZipFacade.sync((TFile)userHomeDir);
            LOGGER.debug("Migrating Sonargraph Standalone files");
            newProductTargetDirectory.mkdirs();
            ArrayList<TFile> toBeRemoved = new ArrayList<TFile>();
            TFile[] tFileArray = userHomeDir.listFiles();
            int n = tFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TFile nextFile = tFileArray[n2];
                if (nextFile.getName().equals(SonargraphProduct.SONARGRAPH.getStandardName() + ".license") || nextFile.getName().equals("softwaresystem.rud")) {
                    try {
                        TFile.cp((File)nextFile, (File)new TFile((File)newProductTargetDirectory, nextFile.getName()));
                        toBeRemoved.add(nextFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to copy file: " + String.valueOf(nextFile) + "\n" + ExceptionUtility.collectAll((Throwable)e));
                    }
                } else if (nextFile.getName().equals("systems")) {
                    try {
                        TFile.cp_r((File)nextFile, (File)new TFile((File)newProductTargetDirectory, nextFile.getName()), (TArchiveDetector)TConfig.get().getArchiveDetector());
                        toBeRemoved.add(nextFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to copy directory: " + String.valueOf(nextFile) + "\n" + ExceptionUtility.collectAll((Throwable)e));
                    }
                } else if (nextFile.getName().endsWith(".log")) {
                    toBeRemoved.add(nextFile);
                } else if (nextFile.getName().equals(".metadata")) {
                    toBeRemoved.add(nextFile);
                    TFile pluginsDirectory = new TFile((File)nextFile, ".plugins");
                    if (pluginsDirectory.exists()) {
                        TFile newTargetPluginsDirectory = new TFile((File)newProductTargetDirectory, ".metadata/.plugins");
                        newTargetPluginsDirectory.mkdirs();
                        try {
                            TFile.cp_r((File)pluginsDirectory, (File)newTargetPluginsDirectory, (TArchiveDetector)TConfig.get().getArchiveDetector());
                        }
                        catch (IOException e) {
                            LOGGER.warn("Unable to copy plugins directory: " + String.valueOf(pluginsDirectory) + "\n" + ExceptionUtility.collectAll((Throwable)e));
                        }
                    }
                }
                ++n2;
            }
            if (!toBeRemoved.isEmpty()) {
                for (TFile nextToBeRemoved : toBeRemoved) {
                    try {
                        if (nextToBeRemoved.isFile()) {
                            nextToBeRemoved.rm();
                            continue;
                        }
                        nextToBeRemoved.rm_r();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to remove: " + String.valueOf(nextToBeRemoved) + "\n" + ExceptionUtility.collectAll((Throwable)e));
                    }
                }
            }
            TrueZipFacade.sync((TFile)userHomeDir);
            LOGGER.debug("Migrating Sonargraph Standalone files - done");
        }
    }

    @PostContextCreate
    final void postContextCreate(final IEventBroker eventBroker, IApplicationContext applicationContext, Display display, org.eclipse.e4.core.services.log.Logger logger) {
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'postContextCreate' must not be null";
        assert (applicationContext != null) : "Parameter 'applicationContext' of method 'postContextCreate' must not be null";
        assert (display != null) : "Parameter 'display' of method 'postContextCreate' must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'postContextCreate' must not be null";
        org.eclipse.core.runtime.Platform.addLogListener((ILogListener)this.m_logListener);
        this.migrateStandaloneFiles();
        if (Platform.isLinux()) {
            display.setData("org.eclipse.swt.internal.gtk.noInputMethod", (Object)true);
        }
        UiResourceManager.createInstance((Display)display);
        UiResourceManager.getInstance().addResourceProviderAdapter((ResourceProviderAdapter)StandaloneResourceProviderAdapter.getInstance());
        HelpRegistry.createInstance((String)ViewId.DYNAMIC_HELP_VIEW.getContextId());
        StandaloneHelpAdapter helpAdapter = new StandaloneHelpAdapter();
        HelpAdapter.setHelpAdapter((HelpAdapter)helpAdapter);
        StandardWizardPage.setHelpAdapter((HelpAdapter)helpAdapter);
        AnalyzerPropertyPage.setHelpAdapter(helpAdapter);
        StandardPreferencePage.setHelpAdapter(helpAdapter);
        this.m_availableViewIds = new LinkedHashSet<ViewId>(Arrays.asList(ViewId.values()));
        this.m_viewContentFilters = new ArrayList<IViewBasedContentFilter>();
        this.m_viewCategoryProviders = new ArrayList<IViewCategoryProvider>();
        this.m_viewCategoryProviders.addAll(CoreViewCategoryProvider.getViewCategoryProviders());
        Pair connectionInfo = ConnectionDialog.getOrConfigureConnectionMode((IProxySettingsProvider)this.m_proxySettingsProvider);
        if (connectionInfo == null) {
            LOGGER.info("User chose to exit - servers at hello2morrow are not reachable.");
            System.exit(0);
        }
        this.m_connectionMode = (ConnectionMode)connectionInfo.getFirst();
        assert (this.m_connectionMode != null) : "'m_connectionMode' of method 'postContextCreate' must not be null";
        ProxySettings usedProxySettings = (ProxySettings)connectionInfo.getSecond();
        ProxySettings configuredProxy = this.m_proxySettingsProvider.getProxySettings(false);
        LOGGER.info("Initializing in '" + String.valueOf(this.m_connectionMode) + "' mode." + (String)(usedProxySettings != null ? " Using proxy: " + String.valueOf(usedProxySettings) + "." : ""));
        if (configuredProxy != null && usedProxySettings != null) {
            assert (usedProxySettings.equals((Object)configuredProxy)) : "Proxy settings are different (used/configured): " + String.valueOf(usedProxySettings) + "/" + String.valueOf(configuredProxy);
            LOGGER.debug("Using configured proxy: " + String.valueOf(configuredProxy));
        }
        this.m_provider = super.initialize(SonargraphStandaloneActivator.getBundleContext(), (ScriptOutputStreamProvider)StandaloneOutputStreamProvider.getInstance(), this.getSpecifiedLanguages(), WorkbenchRegistry.readAnalyzerExecutionLevel(), (ILicenseHandlerProvider)this, (SonargraphLicenseHandler.ILicenseLostEventHandler)this);
        if (this.m_provider == null) {
            System.exit(0);
        }
        LOGGER.info("Using meta data directory: " + RcpUtility.getRcpWorkspaceMetaDataDirectoryPath());
        UpdateSupport.processPersistedStateOnStartup(this.getSpecifiedLanguages());
        this.m_allViewIds = new LinkedHashSet<IViewId>(this.m_availableViewIds);
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.DUPLICATE_CODE)) {
            this.m_availableViewIds.remove(ViewId.DUPLICATE_CODE_BLOCKS_VIEW);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.CYCLE_BREAK_UP)) {
            this.m_availableViewIds.remove(ViewId.CYCLE_BREAK_UP_VIEW);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            this.m_availableViewIds.remove(ViewId.ARCHITECTURE_VIEW);
            this.m_availableViewIds.remove(ViewId.EXPLORATION_VIEW);
            this.m_availableViewIds.remove(ViewId.ARCHITECTURAL_OPERATIONS_VIEW);
            this.m_availableViewIds.remove(ViewId.ARCHITECTURAL_VIOLATIONS_VIEW);
            this.m_availableViewIds.remove(ViewId.ARCHITECTURAL_REFACTORINGS_VIEW);
            this.m_availableViewIds.remove(ViewId.SYSTEM_DIFF_VIEW);
            this.m_availableViewIds.remove(ViewId.TREE_MAP_VIEW);
            this.m_availableViewIds.remove(ViewId.TREE_MAP_INFO_VIEW);
            this.m_availableViewIds.remove(ViewId.RANKING_VIEW);
            this.m_availableViewIds.remove(ViewId.CYCLE_VIEW);
            this.m_availableViewIds.remove(ViewId.CYCLE_ELEMENT_METRICS_VIEW);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
            this.m_availableViewIds.remove(ViewId.TASKS_VIEW);
            this.m_availableViewIds.remove(ViewId.IGNORE_VIEW);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS) || !CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            this.m_availableViewIds.remove(ViewId.REFACTORINGS_VIEW);
        }
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                SonargraphStandaloneApplication.this.startupComplete();
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
    }

    public void handleLicenseLostEvent(String serverReply) {
        LOGGER.error("Floating license was lost due to lost connection to license server. Response: " + serverReply);
        UserInterfaceAdapter.getInstance().displayUiElement(() -> {
            MessageDialog dialog = new MessageDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Floating License Lost", null, "Connection to license server was lost. (Response: " + serverReply + ")\nEither close Sonargraph or try again to obtain a license.", 1, new String[]{"Retry", "Close Sonargraph"}, 0);
            boolean hasLicense = false;
            if (dialog.open() == 0) {
                hasLicense = this.m_licenseHandler.refetchLicense();
            }
            if (!hasLicense) {
                MessageDialog dialog2 = new MessageDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "No License Available", null, "Failed to get a new floating license.\nPlease contact your license administrator.", 1, new String[]{"Close Sonargraph"}, 0);
                dialog2.open();
                SonargraphStandaloneExitHandler.closeApplicationDueToLicenseLost();
            }
        });
    }

    @PreSave
    void preSave() {
        this.shutdownStarted(this.m_provider);
    }

    private void removeViewFromModel(IViewId viewId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'removeViewFromModel' must not be null";
        List viewParts = RcpUtility.findModelElements((IEclipseContext)this.m_eclipseContext, (MUIElement)this.m_application, (String)viewId.getId(), MPart.class);
        block0: for (MPart nextViewPart : viewParts) {
            MElementContainer parent = nextViewPart.getParent();
            List children = parent.getChildren();
            children.remove(nextViewPart);
            nextViewPart.setParent(null);
            if (children.isEmpty()) continue;
            for (MUIElement nextChild : children) {
                if (!nextChild.isToBeRendered()) continue;
                parent.setSelectedElement(nextChild);
                continue block0;
            }
        }
    }

    private void removeMenuElementFromModel(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'removeMenuElementFromModel' must not be empty";
        if (this.m_mainApplicationWindow != null) {
            List elements = RcpUtility.findModelElements((IEclipseContext)this.m_eclipseContext, (MUIElement)this.m_mainApplicationWindow.getMainMenu(), (String)id, MMenuElement.class);
            for (MMenuElement element : elements) {
                MElementContainer parent = element.getParent();
                List children = parent.getChildren();
                children.remove(element);
                element.setParent(null);
            }
        }
    }

    private void removeToolBarElementFromModel(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'removeToolBarElementFromModel' must not be empty";
        if (this.m_application != null) {
            List elements = RcpUtility.findModelElements((IEclipseContext)this.m_eclipseContext, (MUIElement)this.m_application, (String)id, MToolBarElement.class);
            for (MToolBarElement element : elements) {
                MElementContainer parent = element.getParent();
                List children = parent.getChildren();
                children.remove(element);
                element.setParent(null);
            }
        }
    }

    @ProcessAdditions
    void processAdditions(IEventBroker eventBroker, IApplicationContext applicationContext, IEclipseContext eclipseContext, EModelService modelService, MApplication application, Display display, org.eclipse.e4.core.services.log.Logger logger) {
        boolean bl;
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'processAdditions' must not be null";
        assert (applicationContext != null) : "Parameter 'applicationContext' of method 'processAdditions' must not be null";
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'processAdditions' must not be null";
        assert (modelService != null) : "Parameter 'modelService' of method 'processAdditions' must not be null";
        assert (application != null) : "Parameter 'application' of method 'processAdditions' must not be null";
        assert (display != null) : "Parameter 'display' of method 'processAdditions' must not be null";
        assert (logger != null) : "Parameter 'logger' of method 'processAdditions' must not be null";
        this.m_eclipseContext = eclipseContext;
        this.m_modelService = modelService;
        this.m_application = application;
        this.m_mainApplicationWindow = (MWindow)this.m_modelService.find("com.hello2morrow.sonargraph.standalone.mainApplicationWindow", (MUIElement)this.m_application);
        assert (this.m_mainApplicationWindow != null) : "'m_mainApplicationWindow' of method 'processAdditions' must not be null";
        PreferencePageRegistry.createInstance(this.m_eclipseContext);
        WizardRegistry.createInstance((IEclipseContext)this.m_eclipseContext);
        CompositeCommandRegistry.createInstance((IEclipseContext)this.m_eclipseContext);
        WorkbenchRegistry.createInstance((IEclipseContext)eclipseContext, (IEventBroker)eventBroker, (Display)display, (MWindow)this.m_mainApplicationWindow, (ISoftwareSystemProvider)this.m_provider, this.m_availableViewIds, (WorkbenchRegistry.ILinkSelectionListener)new LinkSelectionListener(), this.m_viewContentFilters, this.m_viewCategoryProviders, (WorkbenchRegistry.Mode)WorkbenchRegistry.Mode.STANDALONE);
        StandaloneActions.createInstance();
        UserInterfaceAdapter.createInstance((org.eclipse.e4.core.services.log.Logger)logger, (boolean)true);
        RecentlyUsedSubMenu.removeEntries(this.m_eclipseContext, this.m_mainApplicationWindow);
        NewWizardsSubMenu.removeEntries(this.m_eclipseContext, this.m_mainApplicationWindow);
        String newMenuElementId = "com.hello2morrow.sonargraph.standalone.dynamicmenucontribution.newWizards";
        MMenuItem newMenuItem = null;
        ArrayList<MHandledMenuItem> toBeRemoved = new ArrayList<MHandledMenuItem>();
        for (MMenuItem mMenuItem : this.m_modelService.findElements((MUIElement)this.m_mainApplicationWindow.getMainMenu(), null, MMenuItem.class, null)) {
            if (newMenuItem == null && "com.hello2morrow.sonargraph.standalone.dynamicmenucontribution.newWizards".equals(mMenuItem.getElementId())) {
                newMenuItem = mMenuItem;
            }
            if (!(mMenuItem instanceof MHandledMenuItem)) continue;
            MCommand nextModelCommand = ((MHandledMenuItem)mMenuItem).getCommand();
            if (nextModelCommand == null) {
                toBeRemoved.add((MHandledMenuItem)mMenuItem);
                continue;
            }
            String nextElementId = nextModelCommand.getElementId();
            if (nextElementId != null && !nextElementId.isEmpty()) continue;
            toBeRemoved.add((MHandledMenuItem)mMenuItem);
        }
        for (MHandledMenuItem mHandledMenuItem : toBeRemoved) {
            MElementContainer nextParent = mHandledMenuItem.getParent();
            if (nextParent == null) continue;
            nextParent.getChildren().remove(mHandledMenuItem);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            this.removeMenuElementFromModel("com.hello2morrow.sonargraph.standalone.menu.openExplorationViewAutomatically");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.standalone.directtoolitem.openExplorationView");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.standalone.toolbarseparator.revealSelectionSeparator");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.standalone.handledtoolitem.startStopServer");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.standalone.handledtoolitem.revealSelection");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.standalone.handledtoolitem.sendSelectionRequest");
        }
        for (IViewId iViewId : this.m_allViewIds) {
            if (this.m_availableViewIds.contains(iViewId) && !iViewId.hasProperty(new IViewId.Property[]{IViewId.Property.ALLOWS_MULTIPLE_INSTANCES}) && (!ViewId.DEBUG_VIEW.equals((Object)iViewId) || DebugView.LOGGER.isDebugEnabled())) continue;
            LOGGER.debug("Remove view '" + String.valueOf(iViewId) + "' from application model");
            this.removeViewFromModel(iViewId);
        }
        for (IViewId iViewId : this.m_availableViewIds) {
            LOGGER.debug("View '" + String.valueOf(iViewId) + "' is available");
        }
        boolean bl2 = false;
        List wizardAdapters = WizardRegistry.getInstance().getWizardAdapters();
        for (SonargraphWizardAdapter nextWizardAdapter : wizardAdapters) {
            if (!nextWizardAdapter.isAvailable()) continue;
            bl = true;
            break;
        }
        if (!bl && newMenuItem != null) {
            newMenuItem.setToBeRendered(false);
        }
        applicationContext.applicationRunning();
    }

    public boolean isRunning() {
        return WorkbenchRegistry.isRunning();
    }

    public ISoftwareSystemProvider getSoftwareSystemProvider() {
        return this.m_provider;
    }
}

