/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.filter.ComponentFilter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

final class WorkspaceViewContentProvider
implements ITreeContentProvider {
    private final List<Class<?>> m_roots = new ArrayList(5);
    private final List<Class<?>> m_children = new ArrayList(5);

    WorkspaceViewContentProvider() {
    }

    public final void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.m_roots.clear();
            this.m_children.clear();
        } else {
            assert (newInput != null && newInput instanceof Workspace) : "Unexpected class in method 'inputChanged': " + String.valueOf(newInput);
            SoftwareSystem softwareSystem = (SoftwareSystem)((Workspace)newInput).getParent(SoftwareSystem.class, ParentMode.ONLY_DIRECT_PARENT);
            if (softwareSystem != null) {
                boolean supportsFileFilter = false;
                for (Language nextLanguage : softwareSystem.getUsedLanguages()) {
                    if (!nextLanguage.supportsFileFilter()) continue;
                    supportsFileFilter = true;
                    break;
                }
                if (supportsFileFilter) {
                    this.m_roots.add(WorkspaceFilter.class);
                }
                this.m_roots.add(ComponentFilter.class);
                this.m_roots.add(Module.class);
                this.m_roots.add(External.class);
                this.m_children.add(IBaseDirectory.class);
                this.m_children.add(Pattern.class);
            }
        }
    }

    private Object[] getChildren(NamedElement parent, List<Class<?>> classes) {
        assert (parent != null) : "Parameter 'parent' of method 'getChildren' must not be null";
        assert (classes != null && !classes.isEmpty()) : "Parameter 'classes' of method 'getChildren' must not be empty";
        ArrayList children = new ArrayList();
        for (Class<?> nextClazz : classes) {
            children.addAll(parent.getChildren(nextClazz));
        }
        return children.toArray();
    }

    public final Object[] getElements(Object parent) {
        assert (parent instanceof NamedElement) : "Not a named element: " + String.valueOf(parent);
        return this.getChildren((NamedElement)parent, this.m_roots);
    }

    public final Object getParent(Object child) {
        assert (child instanceof NamedElement) : "Not an named named element: " + String.valueOf(child);
        return ((NamedElement)child).getParent();
    }

    public final Object[] getChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        return this.getChildren((NamedElement)parent, this.m_children);
    }

    public final boolean hasChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        for (Class<?> nextClazz : this.m_children) {
            if (!((NamedElement)parent).hasChildren(false, new Class[]{nextClazz})) continue;
            return true;
        }
        return false;
    }

    public final void dispose() {
    }
}

