/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceprofile;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePatternModification;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfileRootPathMapping;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.StandardUiTreeNodeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.MappingPathNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.ModuleNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceprofile.WorkspaceProfilePatternDialog;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class WorkspaceProfilePatternsWizardPage
extends StandardWizardPage
implements SelectionListener,
ISelectionChangedListener {
    private final List<IWorkspaceProfilePattern> m_patterns = new ArrayList<IWorkspaceProfilePattern>();
    private final boolean m_isCreation;
    private Button m_add;
    private Button m_delete;
    private Button m_up;
    private Button m_down;
    private PropertyTableViewer<IWorkspaceProfilePattern> m_patternTable;
    private Button m_edit;
    private final IWorkspaceProfileProvider m_provider = (IWorkspaceProfileProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IWorkspaceProfileProvider.class);
    private TreeViewer m_translationViewer;

    public WorkspaceProfilePatternsWizardPage(WorkspaceProfile toBeEdited) {
        super(CoreDialogId.CREATE_WORKSPACE_PROFILE_PATTERNS.getStandardName(), toBeEdited == null ? "Create Workspace Profile Patterns" : "Edit Workspace Profile Patterns");
        boolean bl = this.m_isCreation = toBeEdited == null;
        if (!this.m_isCreation) {
            this.m_patterns.addAll(this.m_provider.getPatterns(toBeEdited));
        }
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CREATE_WORKSPACE_PROFILE_PATTERNS;
    }

    protected void createContent(Composite composite) {
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        Composite patternsComposite = new Composite((Composite)sashForm, 0);
        patternsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        patternsComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2));
        WorkspaceProfilePatternBeanAdapter beanAdapter = new WorkspaceProfilePatternBeanAdapter();
        this.m_patternTable = new PropertyTableViewer(patternsComposite, (BeanPropertyReader.BeanAdapter)beanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_patternTable.addColumn("Module Matcher", "moduleMatcher", "moduleMatcher", "", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_patternTable.addColumn("Root Path Matcher", "rootPathMatcher", "rootPathMatcher", "", 30, PropertyTableViewer.ColumnType.TEXT);
        this.m_patternTable.addColumn("Root Path Replacement", "rootPathReplacement", "rootPathReplacement", "", 40, PropertyTableViewer.ColumnType.TEXT);
        this.m_patternTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_patternTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonRow = new Composite(patternsComposite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_add.addSelectionListener((SelectionListener)this);
        this.m_edit = new Button(buttonRow, 8);
        this.m_edit.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_edit.addSelectionListener((SelectionListener)this);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((SelectionListener)this);
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        this.m_up.addSelectionListener((SelectionListener)this);
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        this.m_down.addSelectionListener((SelectionListener)this);
        this.m_translationViewer = new TreeViewer((Composite)sashForm, 66306);
        this.m_translationViewer.getTree().setHeaderVisible(true);
        StandardUiTreeNodeContentAndLabelProvider contentAndLabelProvider = new StandardUiTreeNodeContentAndLabelProvider();
        TreeViewerColumn rootPathColumn = new TreeViewerColumn(this.m_translationViewer, 0);
        rootPathColumn.getColumn().setWidth(400);
        rootPathColumn.getColumn().setText("Root Directory");
        rootPathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UiTreeNode) {
                    return ((UiTreeNode)((Object)element)).getName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("element type '" + element.getClass().getName() + "' is not supported"));
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof UiTreeNode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(element)));
                }
                return ((UiTreeNode)((Object)element)).getImage();
            }
        });
        TreeViewerColumn translationColumn = new TreeViewerColumn(this.m_translationViewer, 0);
        translationColumn.getColumn().setWidth(300);
        translationColumn.getColumn().setText("Translation");
        translationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof MappingPathNode)) {
                    return null;
                }
                return ((MappingPathNode)((Object)element)).getTranslation();
            }

            public Image getImage(Object element) {
                if (!(element instanceof MappingPathNode)) {
                    return null;
                }
                MappingPathNode node = (MappingPathNode)((Object)element);
                CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor(node.getClassForImage());
                if (node.getValidationResult().hasErrors()) {
                    compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.LOWER_LEFT, "ErrorMarker");
                }
                if (node.getValidationResult().hasWarnings()) {
                    compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "WarningMarker");
                }
                return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof MappingPathNode)) {
                    return super.getToolTipText(element);
                }
                MappingPathNode node = (MappingPathNode)((Object)element);
                StringBuilder msg = new StringBuilder();
                ValidationResult validationResult = node.getValidationResult();
                if (validationResult.hasErrors()) {
                    msg.append(StringUtility.concat((Collection)validationResult.getErrors(), (String)StringUtility.LINE_SEPARATOR));
                }
                if (validationResult.hasWarnings()) {
                    msg.append(StringUtility.concat((Collection)validationResult.getWarnings(), (String)StringUtility.LINE_SEPARATOR));
                }
                if (msg.length() == 0) {
                    return null;
                }
                return msg.toString();
            }
        });
        this.m_translationViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        sashForm.setWeights(new int[]{40, 60});
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.m_patternTable.showData(this.m_patterns);
        WorkspaceProfileRootPathMapping rootDirectoryPathMapping = this.m_provider.getRootDirectoryPathMapping(this.m_patterns);
        this.m_translationViewer.setInput(this.createTreeViewerInput(rootDirectoryPathMapping));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_translationViewer, (int)2);
        this.m_translationViewer.expandAll();
        this.m_edit.setEnabled(false);
        this.m_delete.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
    }

    private List<UiTreeNode> createTreeViewerInput(WorkspaceProfileRootPathMapping mapping) {
        assert (mapping != null) : "Parameter 'mapping' of method 'createTreeViewerInput' must not be null";
        ArrayList<UiTreeNode> nodes = new ArrayList<UiTreeNode>();
        for (Module nextModule : mapping.getModules()) {
            ModuleNode moduleNode = new ModuleNode(nextModule);
            nodes.add(moduleNode);
            for (RootDirectoryPath nextPath : mapping.getRootDirectoryPaths(nextModule)) {
                MappingPathNode pathNode = new MappingPathNode(nextPath, mapping.getTranslation(nextPath), mapping.getMappingResult(nextPath));
                moduleNode.addChild(pathNode);
            }
        }
        return nodes;
    }

    public List<IWorkspaceProfilePattern> getPatterns() {
        return this.m_patterns;
    }

    private void applyModification(IWorkspaceProfilePattern select) {
        this.m_patternTable.showData(this.m_patterns);
        this.m_patternTable.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
        WorkspaceProfileRootPathMapping mapping = this.m_provider.getRootDirectoryPathMapping(this.m_patterns);
        this.m_translationViewer.setInput(this.createTreeViewerInput(mapping));
        this.m_translationViewer.expandAll();
        this.setPageComplete(mapping.isSuccess());
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        List selected = this.m_patternTable.getSelected();
        Object source = event.getSource();
        if (source == this.m_add) {
            WorkspaceProfilePatternDialog dialog = new WorkspaceProfilePatternDialog(this.getShell());
            if (dialog.open() == 0) {
                this.m_patterns.add((IWorkspaceProfilePattern)new WorkspaceProfilePatternModification(dialog.getModuleMatcher(), dialog.getRootPathMatcher(), dialog.getRootPathReplacement()));
                this.applyModification(null);
            }
        } else if (source == this.m_edit) {
            assert (selected.size() == 1) : "Only one selected element expected";
            IWorkspaceProfilePattern edit = (IWorkspaceProfilePattern)selected.get(0);
            WorkspaceProfilePatternDialog dialog = new WorkspaceProfilePatternDialog(this.getShell(), new WorkspaceProfilePatternModification(edit.getModuleMatcher(), edit.getRootPathMatcher(), edit.getRootPathReplacement()));
            if (dialog.open() == 0) {
                WorkspaceProfilePatternModification modified = new WorkspaceProfilePatternModification(dialog.getModuleMatcher(), dialog.getRootPathMatcher(), dialog.getRootPathReplacement());
                int pos = this.m_patterns.indexOf(edit);
                this.m_patterns.add(pos, (IWorkspaceProfilePattern)modified);
                this.m_patterns.remove(pos + 1);
                this.applyModification(null);
            }
        } else if (source == this.m_delete) {
            this.m_patterns.removeAll(selected);
            this.applyModification(null);
        } else if (source == this.m_up) {
            assert (selected.size() == 1) : "Only one selected element expected";
            IWorkspaceProfilePattern move = (IWorkspaceProfilePattern)selected.get(0);
            int pos = this.m_patterns.indexOf(move);
            IWorkspaceProfilePattern replaced = this.m_patterns.set(pos - 1, move);
            this.m_patterns.set(pos, replaced);
            this.applyModification(move);
        } else if (source == this.m_down) {
            assert (selected.size() == 1) : "Only one selected element expected";
            IWorkspaceProfilePattern move = (IWorkspaceProfilePattern)selected.get(0);
            int pos = this.m_patterns.indexOf(move);
            if (pos < this.m_patterns.size() - 1) {
                IWorkspaceProfilePattern replaced = this.m_patterns.set(pos + 1, move);
                this.m_patterns.set(pos, replaced);
                this.applyModification(move);
            }
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        assert (event.getSource() == this.m_patternTable.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSelectionProvider());
        List selected = this.m_patternTable.getSelected();
        if (selected.size() == 0) {
            this.m_edit.setEnabled(false);
            this.m_delete.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        } else if (selected.size() == 1) {
            this.m_edit.setEnabled(true);
            this.m_delete.setEnabled(true);
            int pos = this.m_patterns.indexOf(selected.get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < this.m_patterns.size() - 1);
        } else {
            this.m_edit.setEnabled(false);
            this.m_delete.setEnabled(true);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    static class WorkspaceProfilePatternBeanAdapter
    extends BeanPropertyReader.BeanAdapter<IWorkspaceProfilePattern> {
        private IWorkspaceProfilePattern m_pattern;

        WorkspaceProfilePatternBeanAdapter() {
        }

        protected void setAdaptedObject(IWorkspaceProfilePattern adaptedObject) {
            this.m_pattern = adaptedObject;
        }

        public String getModuleMatcher() {
            return this.m_pattern.getModuleMatcher();
        }

        public String getRootPathMatcher() {
            return this.m_pattern.getRootPathMatcher();
        }

        public String getRootPathReplacement() {
            return this.m_pattern.getRootPathReplacement();
        }
    }
}

