/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

final class ChunkWorkerThread
extends Thread {
    private final int m_chunkIndex;
    private final int m_from;
    private final int m_to;
    private final IAction m_action;

    ChunkWorkerThread(int chunkIndex, int from, int to, IAction action) {
        assert (chunkIndex >= 0) : "'chunkIndex' must not be negative";
        assert (from <= to) : "'from' must be less or equal than 'to': " + from + " ... " + to;
        assert (action != null) : "Parameter 'action' of method 'ChunkWorkerThread' must not be null";
        this.m_chunkIndex = chunkIndex;
        this.m_from = from;
        this.m_to = to;
        this.m_action = action;
    }

    @Override
    public void run() {
        int i = this.m_from;
        while (i < this.m_to) {
            this.m_action.perform(this.m_chunkIndex, i);
            ++i;
        }
    }

    @FunctionalInterface
    public static interface IAction {
        public void perform(int var1, int var2);
    }
}

