/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CanvasImageData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.PixelInfo;
import com.hello2morrow.sonargraph.ui.standalone.treemap.PixelInfo3D;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapNodeView;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapRectangle;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CanvasImageData2D
extends CanvasImageData {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanvasImageData2D.class);
    private final IInfoProvider2D m_provider;
    private final PixelInfo[] m_pixelInfo;
    private final ImageData m_imageData;

    CanvasImageData2D(IInfoProvider2D provider, final Point size) {
        assert (provider != null) : "Parameter 'provider' of method 'CanvasImageData2D' must not be null";
        assert (size != null) : "Parameter 'size' of method 'CanvasImageData' must not be null";
        this.m_provider = provider;
        this.m_pixelInfo = new PixelInfo[size.x * size.y];
        this.m_imageData = new ImageData(size.x, size.y, 24, PixelInfo.PALETTE_DATA);
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CanvasImageData2D.this.m_pixelInfo.length) {
                    CanvasImageData2D.this.m_pixelInfo[i] = new PixelInfo3D();
                    ++i;
                }
            }
        });
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < size.x) {
                    int j = 0;
                    while (j < size.y) {
                        CanvasImageData2D.this.m_imageData.setPixel(i, j, PixelInfo.BACKGROUND_PIXEL_VALUE);
                        ++j;
                    }
                    ++i;
                }
            }
        });
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
    }

    @Override
    Point getTreeMapNodeViewLocation(Point location) {
        assert (location != null) : "Parameter 'location' of method 'getTreeMapNodeViewLocation' must not be null";
        int index = location.y * this.m_imageData.width + location.x;
        return index >= 0 && index < this.m_pixelInfo.length ? new Point(location.x, location.y) : null;
    }

    @Override
    TreeMapNodeView getTreeMapNodeView(int x, int y) {
        return this.m_pixelInfo[y * this.m_imageData.width + x].getView();
    }

    @Override
    ImageData getImageData() {
        return this.m_imageData;
    }

    @Override
    boolean needsReCreation(Point size, boolean requires3D) {
        assert (size != null) : "Parameter 'size' of method 'needsReCreation' must not be null";
        return this.m_imageData.width != size.x || this.m_imageData.height != size.y || requires3D;
    }

    @Override
    void reInitialize() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CanvasImageData2D.this.m_pixelInfo.length) {
                    CanvasImageData2D.this.m_pixelInfo[i].reset();
                    ++i;
                }
            }
        });
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < CanvasImageData2D.this.m_imageData.width) {
                    int j = 0;
                    while (j < CanvasImageData2D.this.m_imageData.height) {
                        CanvasImageData2D.this.m_imageData.setPixel(i, j, PixelInfo.BACKGROUND_PIXEL_VALUE);
                        ++j;
                    }
                    ++i;
                }
            }
        });
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Initialize for color update only - done");
    }

    @Override
    void createImageData(Rectangle monitorBounds, TreeMapNode<NamedElement, TreeMapNodeData> root, List<? extends TreeMapNodeView> nodeViews, Point translation, boolean isAutoResizeEnabled, boolean greyNonSelected) {
        assert (monitorBounds != null) : "Parameter 'monitorBounds' of method 'createImageData' must not be null";
        assert (root != null) : "Parameter 'root' of method 'createImageData' must not be null";
        assert (nodeViews != null && !nodeViews.isEmpty()) : "Parameter 'nodeViews' of method 'createImageData' must not be empty";
        assert (translation != null) : "Parameter 'translation' of method 'createImageData' must not be null";
        double scale2d = this.m_provider.getScale2D();
        if (isAutoResizeEnabled) {
            scale2d = Math.min((double)this.m_imageData.width / (double)root.getWidth(), (double)this.m_imageData.height / (double)root.getHeight());
            this.m_provider.setScale2D(scale2d);
        }
        for (TreeMapNodeView treeMapNodeView : nodeViews) {
            assert (treeMapNodeView instanceof TreeMapRectangle) : "Unexpected class in method 'createImage': " + String.valueOf(treeMapNodeView);
            TreeMapNode<NamedElement, TreeMapNodeData> nextNode = treeMapNodeView.getNode();
            int nextX = (int)Math.round((double)nextNode.getAbsoluteX() * scale2d + (double)translation.x);
            int nextY = (int)Math.round((double)nextNode.getAbsoluteY() * scale2d + (double)translation.y);
            int nextMinX = Math.max(nextX, 0);
            int nextMinY = Math.max(nextY, 0);
            int nextMaxX = Math.min(nextX + (int)Math.round((double)nextNode.getWidth() * scale2d), this.m_imageData.width - 1);
            int nextMaxY = Math.min(nextY + (int)Math.round((double)nextNode.getHeight() * scale2d), this.m_imageData.height - 1);
            int nextPixelColorValue = -1;
            int y = nextMinY;
            while (y < nextMaxY) {
                int x = nextMinX;
                while (x < nextMaxX) {
                    if (nextPixelColorValue == -1) {
                        nextPixelColorValue = PixelInfo.PALETTE_DATA.getPixel(treeMapNodeView.getRGB(greyNonSelected));
                    }
                    PixelInfo nextInfo = this.m_pixelInfo[y * this.m_imageData.width + x];
                    this.m_imageData.setPixel(x, y, nextPixelColorValue);
                    nextInfo.setView(treeMapNodeView);
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    void updateColors(boolean greyNonSelected) {
        int y = 0;
        while (y < this.m_imageData.height) {
            int x = 0;
            while (x < this.m_imageData.width) {
                TreeMapNodeView nextView = this.getTreeMapNodeView(x, y);
                if (nextView != null) {
                    this.m_imageData.setPixel(x, y, PixelInfo.PALETTE_DATA.getPixel(nextView.getRGB(greyNonSelected)));
                }
                ++x;
            }
            ++y;
        }
    }

    static interface IInfoProvider2D {
        public double getScale2D();

        public void setScale2D(double var1);
    }
}

